/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.gmc.domain.EnvProperties;
import com.digiwin.dap.middleware.gmc.domain.dealerauthorization.SearchAuthorizationDataVO;
import com.digiwin.dap.middleware.gmc.domain.excel.AuthorizationDataExcel;
import com.digiwin.dap.middleware.gmc.domain.excel.GoodsCounselExcel;
import com.digiwin.dap.middleware.gmc.domain.goods.SearchGoodsCounselVO;
import com.digiwin.dap.middleware.gmc.mapper.AuthorizationDataMapper;
import com.digiwin.dap.middleware.gmc.service.goodscounsel.GoodsCounselQueryService;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/excel"})
public class ExcelController {
    @Autowired
    private AuthorizationDataMapper authorizationDataMapper;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private DictDataService dictDataService;
    @Autowired
    private GoodsCounselQueryService goodsCounselQueryService;

    @GetMapping(value={"/authorizationdata/{authSid}/export"})
    public void deviceExport(@PathVariable(value="authSid") long authSid, @RequestParam(name="orderBy", defaultValue="ad.begin_date desc") String orderBy, @RequestParam(name="params", required=false) String params, HttpServletResponse response) throws Exception {
        SearchAuthorizationDataVO searchAuthorizationDataVO = SearchAuthorizationDataVO.getSelf((String)params);
        searchAuthorizationDataVO.setAuthSid(authSid);
        List authorizationDataList = this.authorizationDataMapper.findAuthorizationDataExport(searchAuthorizationDataVO, orderBy);
        ArrayList authorizationDataExcels = new ArrayList();
        authorizationDataList.forEach(o -> authorizationDataExcels.add(new AuthorizationDataExcel(o)));
        InputStream inputStream = Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getArea()) ? this.getClass().getResourceAsStream("/static/templates/authorizationData_export_template_TW.xlsx") : this.getClass().getResourceAsStream("/static/templates/authorizationData_export_template_CN.xlsx");
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String fileName = URLEncoder.encode("\u6388\u6743\u7801\u5217\u8868", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        ((ExcelWriterSheetBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), AuthorizationDataExcel.class).withTemplate(inputStream).sheet(Integer.valueOf(0)).needHead(Boolean.valueOf(false))).doWrite(authorizationDataExcels);
    }

    @GetMapping(value={"/goodscounsel/export"})
    public void getGoodsCounsel(@RequestParam(name="params", required=false) String params, HttpServletResponse response) throws Exception {
        SearchGoodsCounselVO searchGoodsCounselVO = SearchGoodsCounselVO.getSelf((String)params);
        List goodsCounselList = this.goodsCounselQueryService.getGoodsCounsel(searchGoodsCounselVO);
        ArrayList goodsCounselExcelList = new ArrayList();
        Map<String, String> trialSourceMap = this.dictDataService.selectDictDataList(new DictDataDTO("trialSource", null)).stream().collect(Collectors.toMap(DictData::getDictKey, DictData::getDictValue, (k1, k2) -> k1));
        goodsCounselList.forEach(o -> goodsCounselExcelList.add(new GoodsCounselExcel(o, trialSourceMap)));
        InputStream inputStream = Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getArea()) ? this.getClass().getResourceAsStream("/static/templates/goodsCounsel_export_template_TW.xlsx") : this.getClass().getResourceAsStream("/static/templates/goodsCounsel_export_template_CN.xlsx");
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String fileName = URLEncoder.encode("\u5546\u54c1\u54a8\u8be2\u4fe1\u606f", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        ((ExcelWriterSheetBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), GoodsCounselExcel.class).withTemplate(inputStream).sheet(Integer.valueOf(0)).needHead(Boolean.valueOf(false))).doWrite(goodsCounselExcelList);
    }
}

