/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.domain.pack.ExperienceGoodsPageRequest;
import com.digiwin.dap.middleware.gmc.domain.pack.ExperiencePackVO;
import com.digiwin.dap.middleware.gmc.entity.ExperienceGoods;
import com.digiwin.dap.middleware.gmc.mapper.PackMapper;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsService;
import com.digiwin.dap.middleware.gmc.service.pack.ExperienceGoodsCrudService;
import com.github.pagehelper.PageSerializable;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/experience"})
public class ExperienceController {
    @Autowired
    private GoodsService goodsService;
    @Autowired
    private PackMapper packMapper;
    @Autowired
    private ExperienceGoodsCrudService experienceGoodsCrudService;

    @PostMapping(value={"/add"})
    public StdData<?> addExperienceGoods(@RequestBody ExperiencePackVO input) {
        this.goodsService.addExperienceGoods(input);
        return StdData.ok().build();
    }

    @PostMapping(value={"/del"})
    public StdData<?> delExperienceGoods(@RequestBody ExperiencePackVO input) {
        this.experienceGoodsCrudService.deleteById(input.getSid().longValue());
        return StdData.ok().build();
    }

    @PostMapping(value={"/mod"})
    public StdData<?> modExperienceGoods(@RequestBody ExperiencePackVO input) {
        ExperienceGoods bySid = (ExperienceGoods)this.experienceGoodsCrudService.findBySid(input.getSid().longValue());
        if (bySid != null) {
            bySid.setSort(input.getSort());
            bySid.setUrl(input.getUrl());
            this.experienceGoodsCrudService.update((BaseEntity)bySid);
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/search"})
    public StdData<?> searchExperienceGoods(@RequestBody ExperienceGoodsPageRequest input) {
        input.setOrderBy(Optional.ofNullable(input.getOrderBy()).orElse("sort is null asc,sort asc"));
        List vos = this.packMapper.findExperienceGoodsPage(input);
        return StdData.ok((Object)PageSerializable.of((List)vos));
    }
}

