/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.goodsalias.GoodsAliasDTO;
import com.digiwin.dap.middleware.gmc.entity.GoodsAlias;
import com.digiwin.dap.middleware.gmc.repository.GoodsAliasRepository;
import com.digiwin.dap.middleware.gmc.service.goodsalias.GoodsAliasCrudService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cloudgoods"})
public class GoodsAliasController {
    @Autowired
    private GoodsAliasRepository goodsAliasRepository;
    @Autowired
    private GoodsAliasCrudService goodsAliasCrudService;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/alias/save"})
    public StdData save(@Valid @RequestBody GoodsAliasDTO goodsAliasDTO) {
        if (!CollectionUtils.isEmpty((Collection)goodsAliasDTO.getGoodsAliases())) {
            Map<String, List<GoodsAlias>> goodsAliasMap = goodsAliasDTO.getGoodsAliases().stream().collect(Collectors.groupingBy(o -> o.getGoodsCode() + ":" + o.getGoodsAliasId() + ":" + o.getLanguage()));
            goodsAliasMap.forEach((k, v) -> {
                if (v.size() > 1) {
                    throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("[%s]\u5b58\u5728\u91cd\u590d\u7684\u591a\u6761\u8bb0\u5f55", k));
                }
            });
        }
        if (this.goodsAliasRepository.existsByGoodsCodeAndLanguage(goodsAliasDTO.getGoodsCode(), goodsAliasDTO.getLanguage())) {
            this.goodsAliasRepository.deleteByGoodsCodeAndLanguage(goodsAliasDTO.getGoodsCode(), goodsAliasDTO.getLanguage());
            this.goodsAliasRepository.flush();
        }
        if (!CollectionUtils.isEmpty((Collection)goodsAliasDTO.getGoodsAliases())) {
            this.goodsAliasCrudService.saveAll((Iterable)goodsAliasDTO.getGoodsAliases());
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/alias"})
    public StdData<List<GoodsAlias>> findGoodsAliasList(@Valid @RequestBody GoodsAliasDTO dto) {
        return StdData.ok((Object)this.goodsAliasCrudService.findGoodsAliasList(dto));
    }

    @PostMapping(value={"/alias/exist"})
    public StdData exist(@RequestBody GoodsAliasDTO goodsAliasDTO) {
        return StdData.ok((Object)this.goodsAliasRepository.existsByGoodsCodeAndLanguageAndAndGoodsAliasId(goodsAliasDTO.getGoodsCode(), goodsAliasDTO.getLanguage(), goodsAliasDTO.getGoodsAliasId()));
    }
}

