/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.goodscategory.GoodsCategoryDTO;
import com.digiwin.dap.middleware.gmc.entity.GoodsCategory;
import com.digiwin.dap.middleware.gmc.mapper.GoodsCategoryMapper;
import com.digiwin.dap.middleware.gmc.repository.GoodsCategoryRepository;
import com.digiwin.dap.middleware.gmc.service.goodscategory.GoodsCategoryCrudService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cloudgoods"})
public class GoodsCategoryController {
    @Autowired
    private GoodsCategoryRepository goodsCategoryRepository;
    @Autowired
    private GoodsCategoryCrudService goodsCategoryCrudService;
    @Autowired
    private GoodsCategoryMapper goodsCategoryMapper;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/category/goods/save"})
    public StdData save(@Valid @RequestBody GoodsCategoryDTO goodsCategoryDTO) {
        if (!CollectionUtils.isEmpty((Collection)goodsCategoryDTO.getGoodsCategoryList())) {
            Map<String, List<GoodsCategory>> goodsCategoryMap = goodsCategoryDTO.getGoodsCategoryList().stream().collect(Collectors.groupingBy(o -> o.getGoodsCode() + ":" + o.getCategoryId()));
            goodsCategoryMap.keySet().forEach(o -> ((List)goodsCategoryMap.get(o)).size());
            goodsCategoryMap.forEach((k, v) -> {
                if (v.size() > 1) {
                    throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("[%s]\u5b58\u5728\u91cd\u590d\u7684\u591a\u6761\u8bb0\u5f55", k));
                }
            });
        }
        if (this.goodsCategoryRepository.existsByCategoryId(goodsCategoryDTO.getGoodsCategoryId())) {
            this.goodsCategoryCrudService.deleteByCategoryId(goodsCategoryDTO.getGoodsCategoryId());
            this.goodsCategoryRepository.flush();
        }
        if (!CollectionUtils.isEmpty((Collection)goodsCategoryDTO.getGoodsCategoryList())) {
            this.goodsCategoryCrudService.saveAll((Iterable)goodsCategoryDTO.getGoodsCategoryList());
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/category/goods"})
    public StdData getGoodsCategoryList(@RequestBody GoodsCategoryDTO goodsCategoryDTO) {
        Assert.hasText((String)goodsCategoryDTO.getGoodsCategoryId(), (String)"\u5546\u54c1\u5206\u7c7bid\u4e0d\u80fd\u4e3a\u7a7a!");
        return StdData.ok((Object)this.goodsCategoryMapper.findByCategoryId(goodsCategoryDTO));
    }
}

