/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.api.GoodsController;
import com.digiwin.dap.middleware.gmc.constant.GmcConstant;
import com.digiwin.dap.middleware.gmc.constant.I18nCode;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.gmc.constant.enums.GoodsTrialTypeEnum;
import com.digiwin.dap.middleware.gmc.constant.enums.NoticeTypeEnum;
import com.digiwin.dap.middleware.gmc.domain.EnvProperties;
import com.digiwin.dap.middleware.gmc.domain.goods.DeployGoodsInfo;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsAndLanguageVO;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsDTO;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsResult;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsTrialTypeRequest;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsVO;
import com.digiwin.dap.middleware.gmc.domain.goods.ISVGoodsShelveVO;
import com.digiwin.dap.middleware.gmc.domain.goods.SearchParamVO;
import com.digiwin.dap.middleware.gmc.domain.remote.ModuleVO;
import com.digiwin.dap.middleware.gmc.domain.remote.SysCascadeVO;
import com.digiwin.dap.middleware.gmc.domain.sellingstrategy.CustomAttributeVO;
import com.digiwin.dap.middleware.gmc.domain.sellingstrategy.EnabledModulesVO;
import com.digiwin.dap.middleware.gmc.domain.sellingstrategy.MultipleItemVO;
import com.digiwin.dap.middleware.gmc.domain.sellingstrategy.SellingStrategyVO;
import com.digiwin.dap.middleware.gmc.entity.Goods;
import com.digiwin.dap.middleware.gmc.entity.PackDetail;
import com.digiwin.dap.middleware.gmc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.gmc.repository.GoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.PackDetailRepository;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsCrudService;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsService;
import com.digiwin.dap.middleware.gmc.service.goods.SellingStrategyService;
import com.digiwin.dap.middleware.gmc.service.goodsextra.GoodsExtraCrudService;
import com.digiwin.dap.middleware.gmc.service.goodswebsite.GoodsCloudWebsiteCrudService;
import com.digiwin.dap.middleware.gmc.service.pack.PackService;
import com.digiwin.dap.middleware.gmc.support.remote.CacService;
import com.digiwin.dap.middleware.gmc.support.remote.IamService;
import com.digiwin.dap.middleware.gmc.support.remote.MiswsService;
import com.digiwin.dap.middleware.gmc.support.remote.RemoteLMCService;
import com.digiwin.dap.middleware.gmc.support.stream.PutawayMessageService;
import com.digiwin.dap.middleware.util.AssertUtils;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cloudgoods"})
public class GoodsController {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoodsController.class);
    @Autowired
    private GoodsService goodsService;
    @Autowired
    private GoodsCrudService goodsCrudService;
    @Autowired
    private GoodsRepository goodsRepository;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private PutawayMessageService putawayMessageService;
    @Autowired
    private CacService cacService;
    @Autowired
    private PackDetailRepository packDetailRepository;
    @Autowired
    private IamService iamService;
    @Autowired
    private RemoteLMCService remoteLMCService;
    @Autowired
    private SellingStrategyService sellingStrategyService;
    @Autowired
    private PackService packService;
    @Autowired
    private GoodsExtraCrudService goodsExtraCrudService;
    @Autowired
    private MiswsService miswService;
    @Autowired
    private GoodsCloudWebsiteCrudService goodsCloudWebsiteCrudService;
    @Autowired
    private EnvProperties envProperties;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping
    public ResponseEntity<?> saveCloudGoods(@Validated @RequestBody GoodsVO goodsVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        Goods goodsDb;
        GoodsResult goodsResult = new GoodsResult();
        if (goodsVO.getPurchaseSalesOpen().booleanValue()) {
            if (goodsVO.getPurchaseSalesType() == null) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u81ea\u52a8\u51fa\u8d27\u9500\u552e\u65b9\u6848\u4f9d\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (goodsVO.getPurchaseSalesType() == 0 && goodsVO.getPurchaseStrategySid() == 0L) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u81ea\u52a8\u51fa\u8d27\u9500\u552e\u65b9\u6848\u9884\u8bbe\u7ebf\u4e0b\u9500\u552e\u65b9\u6848\u7684\u9500\u552e\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (StringUtils.hasText((String)goodsVO.getCourseId()) && Objects.nonNull(goodsDb = this.goodsRepository.findByCourseId(goodsVO.getCourseId())) && !Objects.equals(goodsDb.getCode(), goodsVO.getCode())) {
            throw new BusinessException((ErrorHandler)I18nError.COURSE_ID_BIND_OTHER_GOOD, new Object[]{goodsDb.getDisplayName(), goodsDb.getCode()});
        }
        if (goodsVO.getId() == null || goodsVO.getId() == 0L) {
            if (this.goodsRepository.existsByCode(goodsVO.getCode())) {
                return new ResponseEntity((Object)"\u5546\u54c1Id\u5df2\u5b58\u5728", HttpStatus.INTERNAL_SERVER_ERROR);
            }
            goodsVO.initDefaultValue(true);
            Goods goods = goodsVO.generateGoods(true);
            long sid = this.goodsCrudService.create((BaseEntity)goods);
            goodsResult.setSid(Long.valueOf(sid));
            goodsResult.setGoodsCode(goods.getCode());
        } else {
            SysCascadeVO sysCascadeVO;
            List whiteList;
            goodsDb = this.goodsRepository.findByCode(goodsVO.getCode());
            Integer oldPaymentType = goodsDb.getPaymentType();
            Integer newPaymentType = goodsVO.getPaymentType();
            if (Objects.nonNull(newPaymentType) && !Objects.equals(oldPaymentType, newPaymentType) && (CollectionUtils.isEmpty((Collection)(whiteList = this.iamService.getWhiteList("UPDATE_GOODS_PAYMENT_TYPE_USERS"))) || !whiteList.contains(user.getUserId()))) {
                throw new BusinessException((ErrorHandler)I18nError.CURRENT_USER_NO_PERMISSION, new Object[]{user.getUserId()});
            }
            Goods goods = goodsVO.generateGoods(false);
            if (StrUtils.isNotEmpty((String)goodsDb.getCustomAttributes())) {
                goods.setCustomAttributes(goodsDb.getCustomAttributes());
            }
            this.checkServicerGoods(goodsVO, goods);
            goods.setTrialType(goodsDb.getTrialType());
            goods.setCreateById(goodsDb.getCreateById());
            goods.setCreateBy(goodsDb.getCreateBy());
            goods.setCreateDate(goodsDb.getCreateDate());
            goods.setCreateOrg(goodsDb.getCreateOrg());
            EntityUtils.setModifyFields((BaseEntity)goods);
            Goods before = this.goodsRepository.findBySid(goodsDb.getSid());
            this.remoteLMCService.logChangeFields(before, goodsDb);
            this.goodsRepository.save((Object)goods);
            if (!StrUtils.isEmpty((String)goods.getCustomUnit())) {
                this.cacService.updateCustomUnit(goods.getCode(), goods.getCustomUnit());
            }
            goodsResult.setSid(Long.valueOf(goods.getSid()));
            goodsResult.setGoodsCode(goods.getCode());
            List sellingStrategyVOList = this.sellingStrategyService.getSellingStrategyList(goods.getCode(), true);
            if (!CollectionUtils.isEmpty((Collection)sellingStrategyVOList) && StringUtils.hasLength((String)goods.getModules()) && Objects.nonNull(sysCascadeVO = (SysCascadeVO)JsonUtils.jsonToObj((String)goods.getModules(), SysCascadeVO.class)) && !CollectionUtils.isEmpty((Collection)sysCascadeVO.getModules())) {
                Map moduleMap = sysCascadeVO.getModules().stream().collect(Collectors.toMap(ModuleVO::getId, Function.identity()));
                for (SellingStrategyVO sellingStrategyVO : sellingStrategyVOList) {
                    for (EnabledModulesVO enabledModulesVO : sellingStrategyVO.getEnabledModules()) {
                        ModuleVO moduleVO = (ModuleVO)moduleMap.get(enabledModulesVO.getId());
                        if (moduleVO == null || moduleVO.getName().equals(enabledModulesVO.getName())) continue;
                        enabledModulesVO.setName(moduleVO.getName());
                        this.sellingStrategyService.update(sellingStrategyVO);
                    }
                }
            }
        }
        this.goodsExtraCrudService.save(goodsVO);
        this.goodsCloudWebsiteCrudService.saveAll(goodsVO);
        return ResponseEntity.ok((Object)StdData.ok((Object)goodsResult));
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/add/with/strategy"})
    public StdData<?> saveCloudGoodsWithDefaultStrategy(@Validated @RequestBody GoodsVO goodsVO) {
        this.saveCloudGoods(goodsVO, UserUtils.getAuthoredUser());
        long strategySid = this.sellingStrategyService.createDefaultStrategy(goodsVO.getCode(), goodsVO.getDisplayName());
        Goods goods = this.goodsRepository.findByCode(goodsVO.getCode());
        goods.setDefaultStrategySid(Long.valueOf(strategySid));
        this.goodsCrudService.update((BaseEntity)goods);
        return StdData.ok().build();
    }

    @Transactional
    @PutMapping(value={"/code"})
    public StdData<?> updateGoods(@RequestBody GoodsDTO dto) {
        Assert.hasText((String)dto.getCode(), (String)"\u5546\u54c1code\u4e0d\u80fd\u4e3a\u7a7a");
        Goods goods = Optional.ofNullable(this.goodsRepository.findByCode(dto.getCode())).orElseThrow(() -> new BusinessException(String.format("\u5546\u54c1[%s]\u4e0d\u5b58\u5728", dto.getCode())));
        Goods goodsSnapShot = new Goods();
        BeanUtils.copyProperties((Object)goods, (Object)goodsSnapShot);
        Optional.ofNullable(dto.getDisabled()).ifPresent(o -> goods.setDisabled(dto.getDisabled().booleanValue()));
        Optional.ofNullable(dto.getShowEntry()).ifPresent(o -> goods.setShowEntry(dto.getShowEntry()));
        Optional.ofNullable(dto.getSourceCloud()).ifPresent(o -> goods.setSourceCloud(dto.getSourceCloud()));
        Optional.ofNullable(dto.getSourceArea()).ifPresent(o -> goods.setSourceArea(dto.getSourceArea()));
        Optional.ofNullable(dto.getDevId()).ifPresent(o -> goods.setDevId(dto.getDevId()));
        Optional.ofNullable(dto.getDevName()).ifPresent(o -> goods.setDevName(dto.getDevName()));
        Optional.ofNullable(dto.getDisplayName()).ifPresent(o -> goods.setDisplayName(dto.getDisplayName()));
        if (dto.getOptionalOrderPeriods() != null) {
            goods.setOptionalOrderPeriod(dto.getOptionalOrderPeriods().stream().map(String::valueOf).collect(Collectors.joining(",")));
        }
        this.goodsCrudService.update((BaseEntity)goods);
        this.remoteLMCService.logChangeFields(dto, goodsSnapShot);
        return StdData.ok((Object)goods);
    }

    @PostMapping(value={"/code/trial-type/mod"})
    public StdData<?> updateGoodsTrialType(@RequestBody GoodsTrialTypeRequest req) {
        this.checkTrialTypeInfo(req);
        this.goodsService.updateTrialTypeInfo(req.toDTO());
        return StdData.ok((Object)req.getCode());
    }

    @GetMapping(value={"/code/trial-type/find"})
    public StdData<?> updateGoodsTrialType(@RequestParam String code) {
        return StdData.ok((Object)this.goodsService.getTrialTypeInfo(code));
    }

    private void checkServicerGoods(GoodsVO goodsVO, Goods goods) {
        Goods existedGoods = (Goods)this.goodsCrudService.findBySid(goodsVO.getId().longValue());
        if (existedGoods != null && !StrUtils.isEmpty((String)existedGoods.getDevId()) && StrUtils.isEmpty((String)existedGoods.getServicerId()) && !StrUtils.isEmpty((String)goods.getServicerId())) {
            EntityUtils.setCreateFields((BaseEntity)goods);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"/autoCreate"}, method={RequestMethod.POST})
    public StdData autoCreateCloudGoods(@RequestBody @Valid DeployGoodsInfo deployGoodsInfo) {
        LOGGER.info("\u7533\u8bf7\u90e8\u7f72\u53c2\u6570 {}", (Object)deployGoodsInfo);
        this.goodsService.deployGoods(deployGoodsInfo);
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"/autoCreate/other/sys"}, method={RequestMethod.POST})
    public ResponseEntity<?> autoCreateCloudGoodsForTest(@RequestBody DeployGoodsInfo deployGoodsInfo) {
        if (StrUtils.isEmpty((String)deployGoodsInfo.getSysId())) {
            throw new BusinessException("sysId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)UserUtils.getUserName())) {
            AuthoredUser authoredUser = new AuthoredUser();
            authoredUser.setUserName("\u7cfb\u7edf\u4ea7\u751f");
            AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
        }
        this.goodsService.autoCreateOrUpdateGoodsForOther(deployGoodsInfo);
        return ResponseEntity.ok((Object)StdData.ok(null));
    }

    @PostMapping(value={"/auto/deploy"})
    public StdData<?> autoDeployGoods(@RequestBody DeployGoodsInfo deployGoodsInfo, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.isTrue((authoredUser.getTenantSid() != 0L ? 1 : 0) != 0, (String)"\u7528\u6237\u79df\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)deployGoodsInfo.getSysId(), (String)"\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)deployGoodsInfo.getPlatformCode(), (String)"\u5173\u8054\u7684\u5e73\u53f0\u5546\u54c1code\u4e0d\u80fd\u4e3a\u7a7a");
        Boolean result = this.goodsService.autoDeployGoods(deployGoodsInfo);
        return StdData.ok((Object)result);
    }

    @RequestMapping(value={"/{goodsCode}/simple"}, method={RequestMethod.GET})
    public ResponseEntity<?> getGoodsInfo(@PathVariable String goodsCode) {
        GoodsVO goodsInfo = this.goodsService.getGoodsInfoByCode(goodsCode);
        return ResponseEntity.ok((Object)goodsInfo);
    }

    @RequestMapping(value={"/{goodsCode}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getGoodsDetail(@PathVariable String goodsCode, @RequestParam(name="isIncludeDealerSales", defaultValue="true") Boolean isIncludeDealerSales, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        GoodsVO goodsVO = this.goodsService.getGoodsDetailByCode(goodsCode, isIncludeDealerSales.booleanValue(), authoredUser);
        return ResponseEntity.ok((Object)goodsVO);
    }

    @RequestMapping(value={"/sid/{goodsSid}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getGoodsDetailBySid(@PathVariable Long goodsSid, @RequestParam(name="isIncludeDealerSales", defaultValue="true") Boolean isIncludeDealerSales, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        GoodsVO goodsVO = this.goodsService.getGoodsDetailBySid(goodsSid, isIncludeDealerSales.booleanValue(), authoredUser);
        return ResponseEntity.ok((Object)goodsVO);
    }

    @RequestMapping(value={"/list/onsale/{containSellingStrategy}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getOnSaleGoodsList(@PathVariable Boolean containSellingStrategy) {
        List goodsList = this.goodsService.getGoodsList(GmcConstant.GoodsStatus.OnSale, containSellingStrategy.booleanValue(), Boolean.valueOf(true));
        return ResponseEntity.ok((Object)goodsList);
    }

    @RequestMapping(value={"/list/onsale/search/sellingstrategy"}, method={RequestMethod.GET})
    public ResponseEntity<?> getOnSaleGoodsListWithSellingStrategy(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="onsale desc,sortnumber") String orderBy, @RequestParam(name="params", required=false) String params) {
        HashMap searchParamMap;
        try {
            searchParamMap = StrUtils.isEmpty((String)params) ? new HashMap() : (HashMap)JsonUtils.createObjectMapper().readValue(params, HashMap.class);
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "params\u89e3\u6790\u5f02\u5e38");
        }
        PageSerializable goodsList = this.goodsService.getOnSaleGoodsWithSellingStratery(searchParamMap.containsKey("content") ? ((String)searchParamMap.get("content")).toString() : "", Boolean.valueOf(searchParamMap.containsKey("isIncludeDealerSales") ? (StrUtils.isEmpty((String)((String)searchParamMap.get("isIncludeDealerSales"))) ? true : Boolean.valueOf((String)searchParamMap.get("isIncludeDealerSales"))) : true), pageNum.intValue(), pageSize.intValue(), orderBy);
        return ResponseEntity.ok((Object)goodsList);
    }

    @RequestMapping(value={"/list/{containSellingStrategy}"}, method={RequestMethod.GET})
    public ResponseEntity<?> cloudGoodsList(@PathVariable Boolean containSellingStrategy, @RequestParam(name="isIncludeDealerSales", defaultValue="true") Boolean isIncludeDealerSales) {
        List goodsList = this.goodsService.getGoodsList(GmcConstant.GoodsStatus.UnShelve, containSellingStrategy.booleanValue(), isIncludeDealerSales);
        return ResponseEntity.ok((Object)goodsList);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public ResponseEntity<?> goodsList(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="onsale desc,sortnumber,code") String orderBy, @RequestParam(name="params", required=false) String params) {
        SearchParamVO searchParamVO = SearchParamVO.getSelf((String)params);
        PageSerializable goodsList = this.goodsService.getGoodsDetails(searchParamVO, pageNum.intValue(), pageSize.intValue(), orderBy);
        return ResponseEntity.ok((Object)goodsList);
    }

    @GetMapping(value={"/list/without/datapolicy"})
    public ResponseEntity<?> goodsListWithoutDataPolicy(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="onsale desc,sortnumber") String orderBy, @RequestParam(name="params", required=false) String params) {
        SearchParamVO searchParamVO = SearchParamVO.getSelf((String)params);
        PageSerializable goodsList = this.goodsService.getGoodsDetailsWithoutDataPolicy(searchParamVO, pageNum.intValue(), pageSize.intValue(), orderBy);
        return ResponseEntity.ok((Object)goodsList);
    }

    @GetMapping(value={"/simple/all"})
    public StdData<?> goodsListWithoutDataPolicy(SearchParamVO searchParamVO) {
        List goodsList = this.goodsService.listGoodsSimpleInfo(searchParamVO);
        return StdData.ok((Object)goodsList);
    }

    @RequestMapping(value={"/{goodsCode}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> deleteGoods(@PathVariable String goodsCode) {
        this.goodsService.cascadeDeleteGoods(goodsCode);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @RequestMapping(value={"/check/{goodsCode}/{onSale}"}, method={RequestMethod.POST})
    public StdData<?> checkOnSale(@PathVariable String goodsCode, @PathVariable int onSale) {
        Goods goods = this.goodsCrudService.findByCode(goodsCode);
        if (goods == null) {
            return StdData.of((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)("\u5546\u54c1" + goodsCode + "\u4e0d\u5b58\u5728"));
        }
        if (onSale == GmcConstant.GoodsStatus.UnShelve.ordinal()) {
            String errMsg = this.packService.checkDeletableResourceGoods(goods.getCategoryId(), goods.getCode(), false);
            if (errMsg != null) {
                return StdData.of((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)errMsg);
            }
        } else if (onSale == GmcConstant.GoodsStatus.Audit.ordinal() && GoodsCategoryEnum.PACK.name().equalsIgnoreCase(goods.getCategoryId())) {
            this.packService.checkAuditResourceGoods(goods.getSid());
        }
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"/{goodsCode}/{onSale}"}, method={RequestMethod.POST})
    public StdData setIsOnSale(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @PathVariable String goodsCode, @PathVariable int onSale, @RequestBody GoodsVO body) {
        List whiteList;
        if (onSale == GmcConstant.GoodsStatus.OnSale.ordinal() && !(whiteList = this.iamService.getWhiteList("GOODS_ON_SALE_ADMINS")).isEmpty() && !whiteList.contains(authoredUser.getUserId())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u7528\u6237%s\u6ca1\u6709\u4e0a\u67b6\u5546\u54c1%s\u7684\u6743\u9650", authoredUser.getUserId(), goodsCode));
        }
        if (!this.goodsRepository.existsByCode(goodsCode)) {
            return StdData.of((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        GoodsVO goodsVO = this.goodsMapper.selectGoodsByCode(goodsCode);
        if (onSale == GmcConstant.GoodsStatus.OnSale.ordinal()) {
            if (StrUtils.isNotEmpty((String)goodsVO.getServicerId()) && "app".equals(goodsVO.getCategoryId()) && (StrUtils.isEmpty((String)goodsVO.getIntellectualPropertyFile()) || StringUtils.isEmpty((Object)goodsVO.getServiceSupportFile()))) {
                return StdData.of((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)"\u670d\u52a1\u5546\u5546\u54c1\u7684\u76f8\u5173\u6587\u4ef6\u6ca1\u6709\u7ef4\u62a4\uff0c\u4e0d\u4e88\u6838\u51c6");
            }
            if ("app".equalsIgnoreCase(goodsVO.getCategoryId()) && StrUtils.isNotEmpty((String)goodsVO.getServicerId())) {
                Assert.hasText((String)goodsVO.getIntellectualPropertyFile(), (String)"\u77e5\u8bc6\u4ea7\u6743\u62a5\u544a\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.hasText((String)goodsVO.getServiceSupportFile(), (String)"\u670d\u52a1\u652f\u6301\u6761\u6b3e\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)body.getGoodsPurpose())) {
                throw new BusinessException((ErrorHandler)I18nError.GMC_PARAM_ERROR_GENERAL, "\u5546\u54c1\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List sellingStrategyVOList = this.sellingStrategyService.getSellingStrategyList(goodsCode, true);
            ArrayList itemCodes = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)sellingStrategyVOList)) {
                List errorItemCodes;
                Goods goods2 = goodsVO.generateGoods(false);
                SysCascadeVO sysCascadeVO = (SysCascadeVO)JsonUtils.jsonToObj((String)goods2.getModules(), SysCascadeVO.class);
                for (SellingStrategyVO sellingStrategyVO : sellingStrategyVOList) {
                    if (Objects.nonNull(sysCascadeVO) && !CollectionUtils.isEmpty((Collection)sysCascadeVO.getModules())) {
                        Map moduleMap = sysCascadeVO.getModules().stream().collect(Collectors.toMap(ModuleVO::getId, Function.identity()));
                        for (EnabledModulesVO enabledModulesVO : sellingStrategyVO.getEnabledModules()) {
                            ModuleVO moduleVO = (ModuleVO)moduleMap.get(enabledModulesVO.getId());
                            if (moduleVO == null || moduleVO.getName().equals(enabledModulesVO.getName())) continue;
                            enabledModulesVO.setName(moduleVO.getName());
                            this.sellingStrategyService.update(sellingStrategyVO);
                        }
                    }
                    itemCodes.addAll(sellingStrategyVO.getMultipleItems().stream().map(MultipleItemVO::getItemCode).collect(Collectors.toList()));
                }
                if (ObjectUtils.nullSafeEquals((Object)"official", (Object)body.getGoodsPurpose()) && ObjectUtils.nullSafeEquals((Object)0, (Object)goodsVO.getPlatform()) && (Boolean.TRUE.equals(goodsVO.getMarket()) || Boolean.TRUE.equals(goodsVO.getDisplayIntelly())) && !CollectionUtils.isEmpty((Collection)(errorItemCodes = this.miswService.checkItem(itemCodes, this.envProperties.getArea())))) {
                    return StdData.of((int)Integer.valueOf(I18nError.GMC_GOODS_ITEMCODE_CHECK_ERROR.getErrorCode()), (String)String.format("\u5546\u54c1\u9500\u552e\u65b9\u6848\u54c1\u53f7%s\u6821\u9a8c\u5931\u8d25", errorItemCodes.stream().collect(Collectors.joining(","))));
                }
            }
            body.setCode(goodsCode);
            this.goodsExtraCrudService.updateGoodsPurpose(body);
        }
        this.goodsService.updateOnSaleStatus(goodsVO, onSale);
        List<Object> goodsNames = new ArrayList();
        if (onSale == GmcConstant.GoodsStatus.UnShelve.ordinal()) {
            String[] split;
            List packDetails = this.packDetailRepository.findByGoodsSid(goodsVO.getId());
            if (!packDetails.isEmpty()) {
                Set sidSet = packDetails.stream().map(PackDetail::getPackSid).collect(Collectors.toSet());
                goodsNames = this.goodsRepository.findAllById(sidSet).stream().filter(goods -> GmcConstant.GoodsStatus.OnSale.ordinal() == goods.getOnSale().intValue()).map(Goods::getDisplayName).collect(Collectors.toList());
            }
            if (goodsVO.getCategoryId().equals("pack")) {
                goodsVO.setCategoryName("\u7ec4\u5408\u5546\u54c1");
            }
            if (goodsVO.getPaymentType() == 2 && ("app".equalsIgnoreCase(goodsVO.getCategoryId()) || "device".equalsIgnoreCase(goodsVO.getCategoryId())) && goodsVO.getPaymentTypeName() != null && (split = goodsVO.getPaymentTypeName().split("/")).length == 2) {
                goodsVO.setPaymentTypeName(goodsVO.getCustomUnit() + "/" + split[1]);
            }
            goodsVO.changeModulesAndCustomAttributeType();
            this.putawayMessageService.send(goodsVO, NoticeTypeEnum.GMC_GOODS_UNSHELVE.name());
        }
        if (!goodsNames.isEmpty()) {
            return StdData.ok().message(String.format(I18nCode.GOODS_UNSHELVE_PACKAGE_TIPS.getMessage(), StringUtil.join((String)",", (Object[])new Object[]{goodsNames}))).build();
        }
        return StdData.ok().message(null).build();
    }

    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"/audit/{goodsCode}/{onSale}"}, method={RequestMethod.GET})
    public ResponseEntity<?> onSaleAudit(@PathVariable String goodsCode, @PathVariable int onSale, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (!this.goodsRepository.existsByCode(goodsCode)) {
            return new ResponseEntity((Object)"\u5546\u54c1\u4e0d\u5b58\u5728", HttpStatus.INTERNAL_SERVER_ERROR);
        }
        List whiteList = this.iamService.getWhiteList("GOODS_ON_SALE_ADMINS");
        if (!whiteList.isEmpty() && !whiteList.contains(authoredUser.getUserId())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u7528\u6237%s\u6ca1\u6709\u4e0a\u67b6\u5546\u54c1%s\u7684\u6743\u9650", authoredUser.getUserId(), goodsCode));
        }
        GoodsVO goodsVO = this.goodsMapper.selectGoodsByCode(goodsCode);
        this.goodsService.updateOnSaleStatus(goodsVO, onSale);
        if (onSale == GmcConstant.GoodsStatus.UnShelve.ordinal()) {
            if (goodsVO.getCategoryId().equals("pack")) {
                goodsVO.setCategoryName("\u7ec4\u5408\u5546\u54c1");
            }
            goodsVO.changeModulesAndCustomAttributeType();
            this.putawayMessageService.send(goodsVO, NoticeTypeEnum.GMC_GOODS_SHELVE_REJECT.name());
        }
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"/isv/{goodsCode}/{onSale}"}, method={RequestMethod.POST})
    public ResponseEntity<?> isvOnSaleAudit(@RequestBody ISVGoodsShelveVO isvGoodsShelveVO, @PathVariable String goodsCode, @PathVariable int onSale) {
        if (!this.goodsRepository.existsByCode(goodsCode)) {
            return new ResponseEntity((Object)"\u5546\u54c1\u4e0d\u5b58\u5728", HttpStatus.INTERNAL_SERVER_ERROR);
        }
        List whiteList = this.iamService.getWhiteList("GOODS_ON_SALE_ADMINS");
        if (!whiteList.isEmpty() && !whiteList.contains(UserUtils.getUserId())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u7528\u6237%s\u6ca1\u6709\u4e0a\u67b6\u5546\u54c1%s\u7684\u6743\u9650", UserUtils.getUserId(), goodsCode));
        }
        GoodsVO goodsVO = this.goodsMapper.selectGoodsByCode(goodsCode);
        this.goodsService.updateOnSaleStatus(goodsVO, onSale);
        if (onSale == GmcConstant.GoodsStatus.UnShelve.ordinal()) {
            if (goodsVO.getCategoryId().equals("pack")) {
                goodsVO.setCategoryName("\u7ec4\u5408\u5546\u54c1");
            }
            goodsVO.changeModulesAndCustomAttributeType();
            goodsVO.setReason(isvGoodsShelveVO.getReason());
            this.putawayMessageService.send(goodsVO, NoticeTypeEnum.GMC_GOODS_SHELVE_REJECT.name());
        }
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @RequestMapping(value={"/{goodsCode}/logoimage"}, method={RequestMethod.POST})
    public ResponseEntity<?> setLogoImage(@PathVariable String goodsCode, @RequestBody Map<String, String> logoImage) {
        Goods existedGoods = this.goodsRepository.findByCode(goodsCode);
        this.goodsRepository.editLogoImage(goodsCode, logoImage.get("logoImage"));
        Goods updateGoods = new Goods();
        BeanUtils.copyProperties((Object)existedGoods, (Object)updateGoods);
        updateGoods.setBackUri(logoImage.get("logoImage"));
        this.remoteLMCService.logChangeFields(existedGoods, updateGoods);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @RequestMapping(value={"/{goodsCode}/backuri"}, method={RequestMethod.POST})
    public ResponseEntity<?> setBackUri(@PathVariable String goodsCode, @RequestBody Map<String, String> backUri) {
        Goods existedGoods = this.goodsRepository.findByCode(goodsCode);
        this.goodsRepository.editBackUri(goodsCode, backUri.get("backUri"));
        Goods updateGoods = new Goods();
        BeanUtils.copyProperties((Object)existedGoods, (Object)updateGoods);
        updateGoods.setBackUri(backUri.get("backUri"));
        this.remoteLMCService.logChangeFields(existedGoods, updateGoods);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"/{goodsCode}/customattributes"}, method={RequestMethod.POST})
    public ResponseEntity<?> setCustomAttributes(@PathVariable String goodsCode, @Validated @RequestBody List<CustomAttributeVO> customAttributes) {
        this.goodsService.updateCustomAttributes(goodsCode, customAttributes);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @RequestMapping(value={"/{goodsCode}/customattributes"}, method={RequestMethod.GET})
    public ResponseEntity<?> getCustomAttributes(@PathVariable String goodsCode) {
        return ResponseEntity.ok((Object)this.goodsService.getCustomAttributeVOS(goodsCode));
    }

    @RequestMapping(value={"/{goodsCode}/modules"}, method={RequestMethod.GET})
    public ResponseEntity<?> getModules(@PathVariable String goodsCode) {
        Object modules;
        try {
            modules = JsonUtils.createObjectMapper().readValue(this.goodsMapper.selectModules(goodsCode), Object.class);
        }
        catch (IOException e) {
            throw new BusinessException(goodsCode + "\u5546\u54c1\u6a21\u7ec4\u4fe1\u606f\u6216\u81ea\u5b9a\u4e49\u5c5e\u6027\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
        return ResponseEntity.ok((Object)modules);
    }

    @RequestMapping(value={"/{goodsCode}/pmEmails"}, method={RequestMethod.GET})
    public ResponseEntity<?> getPmEmails(@PathVariable String goodsCode) {
        String pmEmails = this.goodsMapper.selectPmEmails(goodsCode);
        if (StrUtils.isEmpty((String)pmEmails)) {
            pmEmails = "";
        }
        HashMap<String, String> pmEmails1 = new HashMap<String, String>();
        pmEmails1.put("pmEmails", pmEmails);
        return ResponseEntity.ok(pmEmails1);
    }

    @RequestMapping(value={"/{goodsCode}/adminemails"}, method={RequestMethod.GET})
    public ResponseEntity<?> getAdminEmails(@PathVariable String goodsCode) {
        String adminEmails = this.goodsMapper.selectAdminEmails(goodsCode);
        if (StrUtils.isEmpty((String)adminEmails)) {
            adminEmails = "";
        }
        HashMap<String, String> adminEmailsMap = new HashMap<String, String>();
        adminEmailsMap.put("adminEmails", adminEmails);
        return ResponseEntity.ok(adminEmailsMap);
    }

    @PostMapping(value={"/backuri"})
    public ResponseEntity<?> getBackUri(@RequestBody List<String> goodsCodes) {
        return ResponseEntity.ok((Object)this.goodsService.getBackUri(goodsCodes));
    }

    @PostMapping(value={"/modules"})
    public StdData saveCloudGoodModules(@RequestBody GoodsAndLanguageVO goodsVO) {
        SysCascadeVO sysCascadeVO;
        Assert.hasText((String)goodsVO.getCode(), (String)"\u5546\u54c1code\u4e0d\u80fd\u4e3a\u7a7a!");
        Goods goods = this.goodsRepository.findByCode(goodsVO.getCode());
        Assert.notNull((Object)goods, (String)String.format("\u627e\u4e0d\u5230\u6b64\u5546\u54c1%s", goodsVO.getCode()));
        this.goodsService.saveGoodModules(goods, goodsVO);
        List sellingStrategyVOList = this.sellingStrategyService.getSellingStrategyList(goods.getCode(), true);
        if (!CollectionUtils.isEmpty((Collection)sellingStrategyVOList) && StringUtils.hasLength((String)goods.getModules()) && Objects.nonNull(sysCascadeVO = (SysCascadeVO)JsonUtils.jsonToObj((String)goods.getModules(), SysCascadeVO.class)) && !CollectionUtils.isEmpty((Collection)sysCascadeVO.getModules())) {
            Map moduleMap = sysCascadeVO.getModules().stream().collect(Collectors.toMap(ModuleVO::getId, Function.identity()));
            for (SellingStrategyVO sellingStrategyVO : sellingStrategyVOList) {
                for (EnabledModulesVO enabledModulesVO : sellingStrategyVO.getEnabledModules()) {
                    ModuleVO moduleVO = (ModuleVO)moduleMap.get(enabledModulesVO.getId());
                    if (moduleVO == null || moduleVO.getName().equals(enabledModulesVO.getName())) continue;
                    enabledModulesVO.setName(moduleVO.getName());
                    this.sellingStrategyService.update(sellingStrategyVO);
                }
            }
        }
        return StdData.ok().build();
    }

    @RequestMapping(value={"/{goodsCode}/multirow/{enable}"}, method={RequestMethod.POST})
    public ResponseEntity<?> setMultiRow(@PathVariable String goodsCode, @PathVariable boolean enable) {
        this.goodsRepository.editMultiRow(goodsCode, enable);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @RequestMapping(value={"/{goodsCode}/multirow"}, method={RequestMethod.GET})
    public ResponseEntity<?> getMultiRow(@PathVariable String goodsCode) {
        return ResponseEntity.ok((Object)this.goodsRepository.findEnableMultiRowByCode(goodsCode));
    }

    @RequestMapping(value={"/detail"}, method={RequestMethod.POST})
    public ResponseEntity<?> getGoodsDetail(@RequestBody SearchParamVO searchParamVO) {
        return ResponseEntity.ok((Object)this.goodsMapper.findGoodsWithoutDataPolicy(searchParamVO, searchParamVO.getPageNum().intValue(), searchParamVO.getPageSize().intValue(), searchParamVO.getOrderBy()));
    }

    private void checkTrialTypeInfo(GoodsTrialTypeRequest dto) {
        AssertUtils.paramHasText((String)dto.getCode(), (String)"code");
        boolean checkTrialType = Objects.isNull(dto.getTrialType()) || Objects.nonNull(dto.getTrialType()) && GoodsTrialTypeEnum.contains((Integer)dto.getTrialType());
        AssertUtils.isTrue((boolean)checkTrialType, (ErrorHandler)I18nError.GMC_GOODS_TRIAL_TYPE_INVALID_ERROR, (Object[])new Object[]{dto.getTrialType()});
        if (dto.getTrialType() != null) {
            switch (1.$SwitchMap$com$digiwin$dap$middleware$gmc$constant$enums$GoodsTrialTypeEnum[GoodsTrialTypeEnum.fromValue((Integer)dto.getTrialType()).ordinal()]) {
                case 1: {
                    AssertUtils.paramNotAllNull((Object[])new Object[]{dto.getGoodsAttributes(), dto.getMobileTrialUrl()}, (String[])new String[]{"goodsAttributes", "mobileTrialUrl"});
                    break;
                }
                case 2: {
                    AssertUtils.paramHasText((String)dto.getDevTrialUrl(), (String)"devTrialUrl");
                    break;
                }
            }
        }
    }
}

