/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.gmc.domain.copy.GoodsCopyRequestVO;
import com.digiwin.dap.middleware.gmc.domain.copy.GoodsCopyVO;
import com.digiwin.dap.middleware.gmc.service.copy.GoodsCopyService;
import com.digiwin.dap.middleware.gmc.support.remote.IamService;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/copy"})
public class GoodsCopyController {
    @Resource
    private IamService iamService;
    @Resource
    private GoodsCopyService goodsCopyService;

    @PostMapping(value={"/export"})
    public StdData<?> exportGoods(@RequestBody GoodsCopyRequestVO requestVO) {
        return StdData.ok((Object)this.goodsCopyService.exportGoods(requestVO));
    }

    @PostMapping(value={"/import"})
    public StdData<?> exportGoods(@RequestBody GoodsCopyVO request) {
        this.goodsCopyService.importGoods(request);
        if (!CollectionUtils.isEmpty((Collection)request.getSysNotice())) {
            request.getSysNotice().forEach(a -> {
                a.setSid(null);
                this.iamService.addNotice(a);
            });
        }
        return StdData.ok().build();
    }
}

