/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.constant.enums.GoodsCounselBusinessTypeEnum;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsCounselDTO;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsCounselResultVO;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsCounselVO;
import com.digiwin.dap.middleware.gmc.domain.goods.SearchGoodsCounselVO;
import com.digiwin.dap.middleware.gmc.entity.GoodsCounsel;
import com.digiwin.dap.middleware.gmc.repository.GoodsCounselRepository;
import com.digiwin.dap.middleware.gmc.service.goodscounsel.GoodsCounselQueryService;
import com.digiwin.dap.middleware.gmc.service.goodscounsel.GoodsCounselService;
import com.digiwin.dap.middleware.gmc.support.remote.MailService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.github.pagehelper.PageSerializable;
import java.util.Collections;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/goodscounsel"})
public class GoodsCounselController {
    @Autowired
    private GoodsCounselService goodsCounselService;
    @Autowired
    private GoodsCounselQueryService goodsCounselQueryService;
    @Autowired
    private MailService mailService;
    @Autowired
    private GoodsCounselRepository goodsCounselRepository;

    @PostMapping(value={""})
    public ResponseEntity<?> addGoodsCounsel(@RequestBody @Validated GoodsCounselDTO dto) {
        if (!GoodsCounselBusinessTypeEnum.GMC_ZHIKE_CONSULTING.getValue().equals(dto.getBusinessType())) {
            Assert.hasLength((String)dto.getEmail(), (String)"\u8054\u7edc\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        long sid = this.goodsCounselService.addGoodsCounsel(dto);
        return ResponseEntity.ok((Object)StdData.ok(Collections.singletonMap("sid", sid)));
    }

    @GetMapping(value={""})
    public ResponseEntity<?> getGoodsCounsel(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="gc.create_date desc") String orderBy, @RequestParam(name="params", required=false) String params) {
        SearchGoodsCounselVO searchGoodsCounselVO = SearchGoodsCounselVO.getSelf((String)params);
        PageSerializable goodsCounselList = this.goodsCounselQueryService.getGoodsCounselPage(searchGoodsCounselVO, pageNum.intValue(), pageSize.intValue(), orderBy);
        return ResponseEntity.ok((Object)StdData.ok((Object)goodsCounselList));
    }

    @GetMapping(value={"/detail/{sid}"})
    public StdData<GoodsCounselResultVO> getGoodsCounselDetail(@PathVariable Long sid) {
        GoodsCounselResultVO goodsCounselVO = this.goodsCounselQueryService.getGoodsCounselDetail(sid);
        return StdData.ok((Object)goodsCounselVO);
    }

    @PostMapping(value={"/reply"})
    @Transactional
    public StdData<?> saveGoodsCounselReply(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestBody GoodsCounselVO goodsCounselVO) {
        GoodsCounsel goodsCounsel = this.goodsCounselRepository.findBySid(goodsCounselVO.getSid());
        Assert.notNull((Object)goodsCounsel, (String)"\u5546\u54c1\u54a8\u8be2sid\u6709\u8bef\uff01");
        goodsCounsel.setReply(goodsCounselVO.getReply());
        EntityUtils.setModifyFields((BaseEntity)goodsCounsel);
        this.goodsCounselRepository.save((Object)goodsCounsel);
        return StdData.ok().build();
    }

    @PostMapping(value={"/mail"})
    public ResponseEntity<?> sendGoodsCounselMail(@RequestBody GoodsCounselDTO dto) {
        if (dto.getSid() == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u54a8\u8be2sid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ResponseEntity.ok((Object)StdData.ok((Object)this.mailService.sendGoodsCounsel(dto.getSid().longValue())));
    }
}

