/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.domain.Page;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.enums.ResourceCategoryEnum;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsVO;
import com.digiwin.dap.middleware.gmc.domain.request.GoodsResourceSaveRequest;
import com.digiwin.dap.middleware.gmc.domain.request.GoodsResourceSearchRequest;
import com.digiwin.dap.middleware.gmc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.gmc.mapper.GoodsResourceMapper;
import com.digiwin.dap.middleware.gmc.service.goodsresource.GoodsResourceService;
import com.digiwin.dap.middleware.gmc.support.remote.CacService;
import com.github.pagehelper.PageSerializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/resource"})
public class GoodsResourceController {
    @Autowired
    private GoodsResourceService goodsResourceService;
    @Autowired
    private GoodsResourceMapper goodsResourceMapper;
    @Autowired
    private DictDataService dictDataService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private CacService cacService;

    @PostMapping(value={"/save"})
    public StdData<?> saveGoodsResource(@RequestBody GoodsResourceSaveRequest body) {
        List goods;
        Map<String, Long> goodsTypeCounts;
        boolean exists;
        if (!body.getResourceCodes().isEmpty() && (exists = (goodsTypeCounts = (goods = this.goodsMapper.findGoodsByCode(body.getResourceCodes())).stream().filter(x -> !Objects.equals(x.getResourceCategory(), ResourceCategoryEnum.OTHER.getCategory())).collect(Collectors.groupingBy(GoodsVO::getResourceCategory, Collectors.counting()))).values().stream().anyMatch(count -> count > 1L))) {
            throw new BusinessException("\u4e00\u4e2asaas\u5546\u54c1\uff0c\u53ea\u80fd\u5bf9\u5e94\u4e00\u4e2a\u76f8\u540c\u8ba1\u91cf\u5206\u7c7b\u7684\u6309\u91cf\u8ba1\u8d39\u5546\u54c1,\u53ef\u4ee5\u5173\u8054\u591a\u4e2a\u5176\u4ed6\u5206\u7c7b\u7684\u6309\u91cf\u8ba1\u8d39\u5546\u54c1");
        }
        this.goodsResourceService.save(body.getGoodsCode(), body.getResourceCodes());
        this.cacService.saveGoodsResource((Object)body);
        return StdData.ok().build();
    }

    @PostMapping(value={"/check"})
    public StdData<?> checkBeforeSave(@RequestBody GoodsResourceSaveRequest body) {
        boolean check = this.goodsResourceService.check(body.getGoodsCode(), body.getResourceCodes());
        if (check) {
            return StdData.of((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)"\u5c06\u4e00\u5e76\u53d6\u6d88\u9500\u552e\u65b9\u6848\u4e2d\uff0c\u8be5\u6309\u91cf\u8ba1\u8d39\u5546\u54c1\u5bf9\u5e94\u642d\u914d");
        }
        return StdData.ok().build();
    }

    @GetMapping(value={"/code"})
    public StdData<?> getGoodsResourceCodes(@RequestParam String goodsCode) {
        DictDataDTO dictDataDTO = new DictDataDTO();
        dictDataDTO.setDictId("resourceCategory");
        Map<String, String> dictMap = this.dictDataService.selectDictDataList(dictDataDTO).stream().collect(Collectors.toMap(DictData::getDictKey, DictData::getDictValue));
        List goodsResources = this.goodsResourceMapper.findByGoodsCode(goodsCode);
        goodsResources.forEach(resource -> resource.setResourceCategoryName((String)dictMap.get(resource.getResourceCategory())));
        return StdData.ok((Object)goodsResources);
    }

    @GetMapping(value={"/reverse/search"})
    public StdData<?> getGoodsByResourceCode(Page page, GoodsResourceSearchRequest params) {
        List pageData = this.goodsResourceMapper.findGoodsByPage(params, page.getPageNum().intValue(), page.getPageSize().intValue(), page.getOrderBy());
        return StdData.ok((Object)PageSerializable.of((List)pageData));
    }
}

