/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.gmc.domain.EnvProperties;
import com.digiwin.dap.middleware.gmc.domain.goods.AthenaUrlSettingDTO;
import com.digiwin.dap.middleware.gmc.domain.goods.DeletePurchase;
import com.digiwin.dap.middleware.gmc.domain.goods.Goods2CloudMapping;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsDTO;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsResult;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsSimpleRequest;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsVO;
import com.digiwin.dap.middleware.gmc.domain.goods.IndexSearchVO;
import com.digiwin.dap.middleware.gmc.domain.goods.RemoveDevGoodVO;
import com.digiwin.dap.middleware.gmc.domain.goods.SearchParamVO;
import com.digiwin.dap.middleware.gmc.domain.remote.GoodsExpiredDTO;
import com.digiwin.dap.middleware.gmc.domain.sellingstrategy.MultipleItemVO;
import com.digiwin.dap.middleware.gmc.domain.sellingstrategy.SellingStrategyVO;
import com.digiwin.dap.middleware.gmc.entity.Goods;
import com.digiwin.dap.middleware.gmc.entity.MultipleItem;
import com.digiwin.dap.middleware.gmc.entity.SellingStrategy;
import com.digiwin.dap.middleware.gmc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.gmc.mapper.GoodsOnPlatformMapper;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsCrudService;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsMappingService;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsOnPlatformService;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsService;
import com.digiwin.dap.middleware.gmc.service.goods.MultipleItemCrudService;
import com.digiwin.dap.middleware.gmc.service.goods.SellingStrategyCrudService;
import com.digiwin.dap.middleware.gmc.service.goods.SellingStrategyService;
import com.digiwin.dap.middleware.gmc.support.helper.CacheHelper;
import com.digiwin.dap.middleware.gmc.support.remote.CacService;
import com.digiwin.dap.middleware.gmc.support.remote.IamService;
import com.digiwin.dap.middleware.gmc.support.remote.MiswsService;
import com.github.pagehelper.PageSerializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/goods"})
public class GoodsV2Controller {
    @Autowired
    private IamService iamService;
    @Autowired
    private CacService cacService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private GoodsService goodsService;
    @Autowired
    private GoodsOnPlatformService goodsOnPlatformService;
    @Autowired
    private GoodsOnPlatformMapper goodsOnPlatformMapper;
    @Autowired
    private MiswsService miswService;
    @Autowired
    private GoodsMappingService goodsMappingService;
    @Autowired
    private CacheHelper cacheHelper;
    @Autowired
    private GoodsCrudService goodsCrudService;
    @Autowired
    private SellingStrategyService sellingStrategyService;
    @Autowired
    private SellingStrategyCrudService sellingStrategyCrudService;
    @Autowired
    private MultipleItemCrudService multipleItemCrudService;
    @Autowired
    private EnvProperties envProperties;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={""})
    public StdData<?> saveGoods(@RequestBody GoodsVO goodsVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        Object goods;
        if (!GoodsCategoryEnum.API.name().equalsIgnoreCase(goodsVO.getCategoryId())) {
            throw new BusinessException("\u53ea\u5141\u8bb8\u65b0\u589e\u66f4\u65b0API\u5546\u54c1");
        }
        goodsVO.initDefaultValue(false);
        if (goodsVO.getId() == null || goodsVO.getId() == 0L) {
            if (this.goodsCrudService.existsByCode(goodsVO.getCode())) {
                throw new BusinessException("\u5546\u54c1" + goodsVO.getCode() + "\u5df2\u5b58\u5728");
            }
            goods = goodsVO.generateGoods(true);
            this.goodsCrudService.create((BaseEntity)goods);
        } else {
            goods = (Goods)this.goodsCrudService.findBySid(goodsVO.getId().longValue());
            if (goods == null || !Objects.equals(goods.getCode(), goodsVO.getCode())) {
                throw new BusinessException("\u5546\u54c1\u4e0d\u5b58\u5728\u6216CODE\u4e0d\u6b63\u786e");
            }
            goodsVO.generateGoods((Goods)goods, false);
            this.goodsCrudService.update((BaseEntity)goods);
        }
        for (SellingStrategyVO sellingStrategy : goodsVO.getSellingStrategys()) {
            if (sellingStrategy.getId() == null || sellingStrategy.getId() == 0L) {
                this.sellingStrategyService.create(sellingStrategy);
                continue;
            }
            this.sellingStrategyService.update(sellingStrategy);
        }
        goods = this.goodsCrudService.findByCode(goodsVO.getCode());
        GoodsResult goodsResult = new GoodsResult(Long.valueOf(goods.getSid()), goods.getCode());
        ArrayList<GoodsResult> strategies = new ArrayList<GoodsResult>();
        goodsResult.setStrategies(strategies);
        for (SellingStrategyVO sellingStrategyVO : goodsVO.getSellingStrategys()) {
            SellingStrategy sellingStrategy = this.sellingStrategyCrudService.findByCode(sellingStrategyVO.getCode());
            GoodsResult strategyResult = new GoodsResult(Long.valueOf(sellingStrategy.getSid()), sellingStrategy.getCode());
            strategies.add(strategyResult);
            ArrayList<GoodsResult> multipleItems = new ArrayList<GoodsResult>();
            strategyResult.setItems(multipleItems);
            for (MultipleItemVO multipleItemVO : sellingStrategyVO.getMultipleItems()) {
                MultipleItem multipleItem = this.multipleItemCrudService.findByCode(sellingStrategy.getSid(), multipleItemVO.getItemCode());
                multipleItems.add(new GoodsResult(Long.valueOf(multipleItem.getSid()), multipleItem.getItemCode()));
            }
        }
        return StdData.ok((Object)goodsResult);
    }

    @PostMapping(value={"/list"})
    public StdData<?> getGoodsListBySids(@RequestBody GoodsDTO params) {
        List list = this.goodsMapper.getGoodsBySids(params.getSids(), params.getCodes());
        return StdData.ok((Object)list);
    }

    @PostMapping(value={"/list/search"})
    public ResponseEntity<?> searchGoodsList(@RequestBody IndexSearchVO indexSearchVO) {
        List<Object> contents = new ArrayList();
        if (StringUtils.hasLength((String)indexSearchVO.getContent())) {
            contents = Arrays.asList(indexSearchVO.getContent().split(" ")).stream().filter(str -> str.length() > 0).collect(Collectors.toList());
        }
        List indexGoodsVOList = this.goodsService.searchGoods(indexSearchVO, contents);
        PageSerializable pageResult = new PageSerializable(indexGoodsVOList);
        return ResponseEntity.ok((Object)StdData.ok((Object)pageResult));
    }

    @GetMapping(value={"/code"})
    public ResponseEntity<?> getGoodsCode(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", required=false) String orderBy, @RequestParam(name="code", required=false) String code, @RequestParam(name="categoryId", required=false) String categoryId) {
        List codes = this.goodsMapper.findGoodsCodes(categoryId, code, pageNum.intValue(), pageSize.intValue(), orderBy);
        return ResponseEntity.ok((Object)new PageSerializable(codes));
    }

    @PostMapping(value={"/product/code"})
    public ResponseEntity<?> getGoodsCaBy(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", required=false) String orderBy, @RequestBody Map<String, String> requestContent) {
        String code = requestContent.containsKey("productCode") ? requestContent.get("productCode") : null;
        List codes = this.goodsMapper.findProductCodes(code, pageNum.intValue(), pageSize.intValue(), orderBy);
        return ResponseEntity.ok((Object)new PageSerializable(codes));
    }

    @PostMapping(value={"/code"})
    public ResponseEntity<?> getGoodsCodeByProductCodes(@RequestBody List<String> body) {
        List codes = this.goodsMapper.findGoodsCodesByProductCodes(body);
        return ResponseEntity.ok((Object)codes);
    }

    @GetMapping(value={""})
    public ResponseEntity<?> getGoodsSimple(GoodsSimpleRequest req) {
        List codes = this.goodsMapper.findGoodsSimple(req.toGoodsDTO());
        return ResponseEntity.ok((Object)codes);
    }

    @GetMapping(value={"/willexpired/apps"})
    public ResponseEntity<?> goodsList(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", required=false) String orderBy, @RequestParam(name="params", required=false) String params) {
        GoodsExpiredDTO dto = GoodsExpiredDTO.getSelf((String)params);
        if (!CollectionUtils.isEmpty((Collection)dto.getProductCode())) {
            List codes = this.goodsMapper.findGoodsCodesByProductCodes(dto.getProductCode());
            dto.setProductCodeGoodsCodes(codes);
            if (codes.isEmpty()) {
                return ResponseEntity.ok((Object)new PageSerializable(new ArrayList()));
            }
        }
        PageSerializable willExpiredApps = this.cacService.getWillExpiredGoods(pageNum, pageSize, dto);
        return ResponseEntity.ok((Object)this.goodsService.generalAuthExpireGoods(willExpiredApps));
    }

    @PostMapping(value={"/servicer"})
    public StdData goodsTenant(@RequestBody SearchParamVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (body.getOrderBy() == null) {
            body.setOrderBy("onsale desc, sortnumber asc");
        }
        body.setServicerIdEq(authoredUser.getTenantId());
        List goods = this.goodsService.getGoodsByCondition(body, body.getPageNum().intValue(), body.getPageSize().intValue(), body.getOrderBy());
        return StdData.ok((Object)new PageSerializable(goods));
    }

    @PostMapping(value={"/current/servicer/codes"})
    public List<String> getCurrentServicerGoods(@RequestBody SearchParamVO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (dto.getOrderBy() == null) {
            dto.setOrderBy("onsale desc, sortnumber asc");
        }
        dto.setServicerIdEq(authoredUser.getTenantId());
        List goods = this.goodsService.getGoodsByCondition(dto, dto.getPageNum().intValue(), dto.getPageSize().intValue(), dto.getOrderBy());
        return goods.stream().map(GoodsVO::getCode).collect(Collectors.toList());
    }

    @PostMapping(value={"/dev/option"})
    public StdData goodsSelect(@RequestBody SearchParamVO body) {
        if (StringUtils.isEmpty((Object)body.getDevId())) {
            return StdData.ok(Collections.emptyList());
        }
        List sysIdSold = this.iamService.getSysIdSold(body.getDevId());
        if (sysIdSold.isEmpty()) {
            return StdData.ok(Collections.emptyList());
        }
        body.setOption(Boolean.valueOf(true));
        body.setGoodsCodes(sysIdSold);
        body.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        List goods = this.goodsService.getGoodsByCondition(body, body.getPageNum().intValue(), body.getPageSize().intValue(), body.getOrderBy());
        return StdData.ok((Object)goods);
    }

    @PostMapping(value={"/delete/purchase"})
    public StdData delPurchase(@RequestBody DeletePurchase body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List whiteList = this.iamService.getWhiteList("GOODS_OPERATION_ADMINS");
        if (!whiteList.contains(authoredUser.getUserId())) {
            return StdData.of((int)401, (String)String.format("\u7528\u6237[%s]\u7981\u6b62\u64cd\u4f5c", authoredUser.getUserId()));
        }
        this.goodsService.deletePurchase(body);
        return StdData.ok().build();
    }

    @PostMapping(value={"/platform/{goodsCode}"})
    public StdData saveGoodsPlatform(@PathVariable String goodsCode, @RequestBody List<String> platforms) {
        this.goodsOnPlatformService.save(goodsCode, platforms);
        return StdData.ok().build();
    }

    @GetMapping(value={"/platform/{goodsCode}"})
    public StdData<?> getGoodsPlatforms(@PathVariable String goodsCode) {
        return StdData.ok((Object)this.goodsOnPlatformMapper.getPlatformByGoodsCode(goodsCode));
    }

    @PostMapping(value={"/code/platform"})
    public StdData<?> getGoodsCodes(@RequestBody Map<String, String> body) {
        return StdData.ok((Object)this.goodsOnPlatformMapper.getGoodsCodeByPlatformCode(body.get("platformCode")));
    }

    @DeleteMapping(value={"/servicer/goods/{goodsCode}"})
    public StdData deleteServicerGoods(@PathVariable String goodsCode, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.goodsService.deleteServicerGoodsByCode(goodsCode);
        return StdData.ok().build();
    }

    @PostMapping(value={"/dev/isv/option"})
    public StdData getDevIsvGoods(@RequestBody SearchParamVO searchParamVO) {
        return StdData.ok((Object)this.goodsService.findAllByDevIdAndServicerId(searchParamVO.getDevIds(), searchParamVO.getServicerId()));
    }

    @GetMapping(value={"/mappings"})
    public StdData getCloudMappings(@RequestParam(name="code") String code) {
        List mappings = this.goodsMappingService.getMappings(code);
        return StdData.ok((Object)mappings);
    }

    @PostMapping(value={"/mapping"})
    public StdData saveCloudMappings(@RequestBody Goods2CloudMapping goodsMapping) {
        Assert.isTrue((!goodsMapping.getDatas().isEmpty() ? 1 : 0) != 0, (String)"\u96c6\u6210\u5e73\u53f0\u7684\u6620\u5c04\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        goodsMapping.getDatas().forEach(d -> {
            Assert.hasText((String)d.getKey(), (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)d.getName(), (String)"name\u4e0d\u80fd\u4e3a\u7a7a");
        });
        this.goodsMappingService.saveGoodsMappings(goodsMapping.getGoodsCode(), goodsMapping.getPlatform(), goodsMapping.getDatas());
        return StdData.ok().build();
    }

    @GetMapping(value={"/mapping/platform/info"})
    public ResponseEntity<?> getMappingById(@RequestParam Integer platform, @RequestParam(required=false) String key, @RequestParam(required=false) String value, @RequestParam(required=false) String sysId) {
        Map result;
        if (!StringUtils.isEmpty((Object)sysId)) {
            result = this.goodsMappingService.getMappingInfo(sysId, platform);
        } else if (!StringUtils.isEmpty((Object)value)) {
            result = this.goodsMappingService.getMappingInfo(platform, key, value);
        } else {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u5e94\u7528\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ResponseEntity.ok((Object)result);
    }

    @DeleteMapping(value={"/{goodsCode}"})
    public StdData<?> deleteGoods(@PathVariable String goodsCode) {
        List goodsAuthTenants = this.cacService.getGoodsAuthTenant(goodsCode);
        if (CollectionUtils.isEmpty((Collection)goodsAuthTenants)) {
            this.goodsService.cascadeDeleteGoods(goodsCode);
            this.iamService.deleteSysInfo(goodsCode);
            return StdData.ok().build();
        }
        return StdData.of((int)500, (String)I18nError.CODE_GOODS_DELETE_CHECK.getMessage(new Object[]{goodsCode}));
    }

    @PostMapping(value={"/url/auto"})
    public StdData<?> setAthenaUri(@RequestBody AthenaUrlSettingDTO dto) {
        this.goodsService.setAthenaUri(dto);
        return StdData.ok().build();
    }

    @PostMapping(value={"/remove/dev"})
    public StdData<?> removeDevGoods(@RequestBody RemoveDevGoodVO vo) {
        Assert.hasText((String)vo.getTenantId(), (String)"tenantId:\u79df\u6237id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        this.cacheHelper.delCorrespondingCaches("gmc:/api/cloudgoods/list:");
        ArrayList<String> codes = new ArrayList<String>();
        if (StringUtils.hasLength((String)vo.getGoodsCode())) {
            codes.add(vo.getGoodsCode());
        } else {
            codes.addAll(this.iamService.getDevSys(vo.getTenantId()));
        }
        for (String code : codes) {
            this.goodsService.cascadeDeleteGoods(code);
        }
        return StdData.ok().build();
    }

    @GetMapping(value={"/item/check"})
    public StdData<?> checkItem(GoodsVO cond) {
        List errorItemCodes;
        if (ObjectUtils.isEmpty((Object)cond.getCode())) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR, new Object[]{"code"});
        }
        GoodsVO goodsVO = this.goodsMapper.selectGoodsByCode(cond.getCode());
        List sellingStrategyVOList = this.sellingStrategyService.getSellingStrategyList(cond.getCode(), true);
        ArrayList itemCodes = new ArrayList();
        sellingStrategyVOList.forEach(s -> itemCodes.addAll(s.getMultipleItems().stream().map(MultipleItemVO::getItemCode).collect(Collectors.toList())));
        if ((Boolean.TRUE.equals(goodsVO.getMarket()) || Boolean.TRUE.equals(goodsVO.getDisplayIntelly())) && !CollectionUtils.isEmpty((Collection)(errorItemCodes = this.miswService.checkItem(itemCodes, this.envProperties.getArea())))) {
            return StdData.of((int)Integer.valueOf(I18nError.GMC_GOODS_ITEMCODE_CHECK_ERROR.getErrorCode()), (String)errorItemCodes.stream().collect(Collectors.joining(",")));
        }
        return StdData.ok().build();
    }
}

