/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.digiwin.dap.middleware.domain.Page;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.gmc.constant.enums.MarketingConfigTypeEnum;
import com.digiwin.dap.middleware.gmc.domain.marketing.MarketingConfigAddRequest;
import com.digiwin.dap.middleware.gmc.domain.marketing.MarketingConfigExcelVO;
import com.digiwin.dap.middleware.gmc.domain.marketing.MarketingConfigPlatformExcelVO;
import com.digiwin.dap.middleware.gmc.domain.marketing.MarketingConfigSearchRequest;
import com.digiwin.dap.middleware.gmc.service.marketing.MarketingConfigCrudService;
import com.digiwin.dap.middleware.gmc.service.marketing.MarketingConfigService;
import com.github.pagehelper.PageSerializable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/marketing"})
public class MarketingController {
    @Resource
    private MarketingConfigService marketingConfigService;
    @Autowired
    private MarketingConfigCrudService marketingConfigCrudService;

    @PostMapping(value={"/add"})
    public StdData<?> add(@Validated @RequestBody MarketingConfigAddRequest request) {
        if (MarketingConfigTypeEnum.isNeedStrategy((Integer)request.getType())) {
            Assert.notNull((Object)request.getMainStrategySid(), (String)StrUtil.format((CharSequence)"{}\u5546\u54c1\u914d\u7f6e\u65f6\uff0c\u9500\u552e\u65b9\u6848sid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{MarketingConfigTypeEnum.getName((Integer)request.getType())}));
        }
        this.marketingConfigService.save(request);
        return StdData.ok().build();
    }

    @GetMapping(value={"/search"})
    public StdData<?> search(MarketingConfigSearchRequest request, Page page) {
        Assert.notEmpty((Collection)request.getTypes(), (String)"types\u4e0d\u80fd\u4e3a\u7a7a");
        page.setOrderBy(Optional.ofNullable(page.getOrderBy()).orElse("ag.sid desc"));
        PageSerializable response = this.marketingConfigService.search(request, page);
        return StdData.ok((Object)response);
    }

    @GetMapping(value={"/export"})
    public void export(MarketingConfigSearchRequest request, Page page, HttpServletResponse response) throws IOException {
        Class<MarketingConfigExcelVO> clazz;
        List accountOrders;
        Assert.notEmpty((Collection)request.getTypes(), (String)"types\u4e0d\u80fd\u4e3a\u7a7a");
        page.setOrderBy(Optional.ofNullable(page.getOrderBy()).orElse("ag.sid desc"));
        PageSerializable result = this.marketingConfigService.search(request, page);
        if (request.getTypes().contains(MarketingConfigTypeEnum.RELATED.ordinal())) {
            accountOrders = result.getList().stream().map(MarketingConfigExcelVO::new).collect(Collectors.toList());
            clazz = MarketingConfigExcelVO.class;
        } else {
            accountOrders = result.getList().stream().map(MarketingConfigPlatformExcelVO::new).collect(Collectors.toList());
            clazz = MarketingConfigPlatformExcelVO.class;
        }
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String fileName = URLEncoder.encode("\u8425\u9500\u5546\u54c1", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), clazz).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet("Sheet1").doWrite(accountOrders);
    }

    @GetMapping(value={"/attached/strategy/exist"})
    public StdData<?> exist(@RequestParam Long strategySid) {
        List list = this.marketingConfigCrudService.findByAttachedStrategySid(strategySid);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("platform", list.stream().anyMatch(o -> MarketingConfigTypeEnum.isPlatform((Integer)o.getType())));
        map.put("related", list.stream().anyMatch(o -> Objects.equals(o.getType(), MarketingConfigTypeEnum.RELATED.getType())));
        return StdData.ok(map);
    }
}

