/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsLanguage;
import com.digiwin.dap.middleware.gmc.domain.multilanguage.DataVO;
import com.digiwin.dap.middleware.gmc.domain.multilanguage.MultiLanguageQueryVO;
import com.digiwin.dap.middleware.gmc.domain.multilanguage.MultiLanguageResourceVO;
import com.digiwin.dap.middleware.gmc.domain.multilanguage.MultiLanguageVO;
import com.digiwin.dap.middleware.gmc.entity.MultiLanguageResource;
import com.digiwin.dap.middleware.gmc.repository.MultiLanguageResourceRepository;
import com.digiwin.dap.middleware.gmc.repository.MultiLanguageTypeRepository;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsService;
import com.digiwin.dap.middleware.gmc.service.goodsalias.GoodsAliasCrudService;
import com.digiwin.dap.middleware.gmc.service.goodscategory.GoodsCategoryCrudService;
import com.digiwin.dap.middleware.gmc.service.multilanguageresource.LanguageService;
import com.digiwin.dap.middleware.gmc.service.multilanguageresource.MultiLanguageResourceCrudService;
import com.digiwin.dap.middleware.gmc.service.multilanguageresource.MultiLanguageResourceQueryService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2"})
public class MultiLanguagesController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiLanguagesController.class);
    @Autowired
    private MultiLanguageTypeRepository multiLanguageTypeRepository;
    @Autowired
    private MultiLanguageResourceRepository multiLanguageResourceRepository;
    @Autowired
    private MultiLanguageResourceCrudService multiLanguageResourceCrudService;
    @Autowired
    private MultiLanguageResourceQueryService multiLanguageResourceQueryService;
    @Autowired
    private LanguageService languageService;
    @Autowired
    private GoodsAliasCrudService goodsAliasCrudService;
    @Autowired
    private GoodsCategoryCrudService goodsCategoryCrudService;
    @Autowired
    private GoodsService goodsService;

    @GetMapping(value={"/multi/languagetype"})
    public ResponseEntity<?> getLanguageTypeList() {
        List multiLanguageTypes = this.multiLanguageTypeRepository.findAll();
        return ResponseEntity.ok((Object)StdData.ok((Object)multiLanguageTypes));
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/multi/language"})
    public StdData<?> saveMultiLanguages(@Validated @RequestBody MultiLanguageResourceVO multiLanguageResourceVO) {
        for (DataVO data : multiLanguageResourceVO.getData()) {
            MultiLanguageResource multiLanguageResource = this.multiLanguageResourceRepository.findByDataSidAndFieldNameAndLanguage(multiLanguageResourceVO.getDataSid(), data.getFieldName(), multiLanguageResourceVO.getLanguage());
            if (multiLanguageResource == null) {
                MultiLanguageResource multiLanguageResource1 = new MultiLanguageResource();
                multiLanguageResource1.setDataSid(multiLanguageResourceVO.getDataSid());
                multiLanguageResource1.setFieldName(data.getFieldName());
                multiLanguageResource1.setLanguage(multiLanguageResourceVO.getLanguage());
                multiLanguageResource1.setContent(data.getContent());
                long l = this.multiLanguageResourceCrudService.create((BaseEntity)multiLanguageResource1);
                continue;
            }
            multiLanguageResource.setContent(data.getContent());
            this.multiLanguageResourceCrudService.update((BaseEntity)multiLanguageResource);
        }
        return StdData.ok((Object)StdData.ok().build());
    }

    @RequestMapping(value={"/multi/language/{dataSid}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getMultiLanguageResource(@PathVariable Long dataSid) {
        MultiLanguageVO multiLanguageVO = this.multiLanguageResourceQueryService.getMultiLanguageVO(dataSid.longValue());
        return ResponseEntity.ok((Object)StdData.ok((Object)multiLanguageVO));
    }

    @RequestMapping(value={"/multi/language/goodscodes/resources"}, method={RequestMethod.POST})
    public ResponseEntity<?> getGoodsMultiLanguageResources(@RequestBody List<String> goodsCodes) {
        if (goodsCodes == null || goodsCodes.size() == 0) {
            return ResponseEntity.ok((Object)StdData.of((int)500, (String)"\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        List goodsMultiLanguages = this.multiLanguageResourceQueryService.getGoodsMultiLanguageResources(goodsCodes);
        for (MultiLanguageQueryVO languageQueryVO : goodsMultiLanguages) {
            ArrayList<DataVO> contents = languageQueryVO.getContents();
            if (!CollectionUtils.isEmpty((Collection)contents)) continue;
            if (contents == null) {
                contents = new ArrayList<DataVO>(2);
            }
            contents.add(new DataVO("goodsName", languageQueryVO.getDisplayName()));
            contents.add(new DataVO("customunit", languageQueryVO.getCustomUnit()));
            languageQueryVO.setContents((List)contents);
        }
        List goodsMultiIds = goodsMultiLanguages.stream().map(MultiLanguageQueryVO::getId).collect(Collectors.toList());
        ArrayList<String> goodsCodesCopy = new ArrayList<String>(goodsCodes);
        goodsCodesCopy.removeAll(goodsMultiIds);
        for (String s : goodsCodesCopy) {
            MultiLanguageQueryVO goodsMultiLanguage = new MultiLanguageQueryVO();
            goodsMultiLanguage.setId(s);
            goodsMultiLanguages.add(goodsMultiLanguage);
        }
        Locale locale = LocaleContextHolder.getLocale();
        CompletableFuture<Object> uCompletableFuture1 = CompletableFuture.supplyAsync(() -> {
            LocaleContextHolder.setLocale((Locale)locale);
            this.goodsAliasCrudService.setGoodsAliasByMultiLanguage(goodsCodes, goodsMultiLanguages);
            return null;
        });
        CompletableFuture<Object> uCompletableFuture2 = CompletableFuture.supplyAsync(() -> {
            this.goodsCategoryCrudService.setGoodsCategoryList4MultiLanguage(goodsCodes, goodsMultiLanguages);
            return null;
        });
        CompletableFuture<Object> uCompletableFuture3 = CompletableFuture.supplyAsync(() -> {
            this.goodsService.setGoodsInfo4MultiLanguage(goodsCodes, goodsMultiLanguages);
            return null;
        });
        try {
            uCompletableFuture1.get();
            uCompletableFuture2.get();
            uCompletableFuture3.get();
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        return ResponseEntity.ok((Object)StdData.ok((Object)goodsMultiLanguages));
    }

    @PostMapping(value={"/goods/language"})
    public StdData<List<GoodsLanguage>> getGoodsLanguage(@RequestBody List<String> goodsCodes) {
        if (goodsCodes == null || goodsCodes.size() == 0) {
            return StdData.of((int)500, (String)"\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List goods = this.languageService.getGoodsByCodes(goodsCodes);
        if (goods.isEmpty()) {
            LOGGER.info("goodsCodes={} \u67e5\u8be2\u5546\u54c1\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u591a\u8bed\u8a00\u8d4b\u503c", goodsCodes);
            return StdData.ok((Object)goods);
        }
        this.languageService.setLanguage(goods, goods.stream().map(GoodsLanguage::getSid).collect(Collectors.toList()), GoodsLanguage.class);
        Locale locale = LocaleContextHolder.getLocale();
        CompletableFuture<Object> uCompletableFuture1 = CompletableFuture.supplyAsync(() -> {
            LocaleContextHolder.setLocale((Locale)locale);
            this.goodsAliasCrudService.setGoodsAliasByGoods(goodsCodes, goods);
            return null;
        });
        CompletableFuture<Object> uCompletableFuture2 = CompletableFuture.supplyAsync(() -> {
            this.goodsCategoryCrudService.setGoodsCategoryList(goodsCodes, goods);
            return null;
        });
        CompletableFuture<Object> uCompletableFuture3 = CompletableFuture.supplyAsync(() -> {
            this.goodsService.setGoodsInfo(goodsCodes, goods);
            return null;
        });
        try {
            uCompletableFuture1.get();
            uCompletableFuture2.get();
            uCompletableFuture3.get();
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        return StdData.ok((Object)goods);
    }
}

