/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.domain.AbstractConverter;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.enums.GoodsPayType;
import com.digiwin.dap.middleware.gmc.domain.pack.ExperiencePackVO;
import com.digiwin.dap.middleware.gmc.domain.pack.PackDetailVO;
import com.digiwin.dap.middleware.gmc.domain.pack.PackGoodsVO;
import com.digiwin.dap.middleware.gmc.domain.pack.PackVO;
import com.digiwin.dap.middleware.gmc.entity.Goods;
import com.digiwin.dap.middleware.gmc.mapper.PackMapper;
import com.digiwin.dap.middleware.gmc.repository.ExperienceGoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.GoodsRepository;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsCrudService;
import com.digiwin.dap.middleware.gmc.service.pack.PackQueryService;
import com.digiwin.dap.middleware.gmc.service.pack.PackService;
import com.github.pagehelper.PageSerializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/pack"})
public class PackController {
    @Autowired
    private PackService packService;
    @Autowired
    private PackMapper packMapper;
    @Autowired
    private PackQueryService packQueryService;
    @Autowired
    private GoodsRepository goodsRepository;
    @Autowired
    private ExperienceGoodsRepository experienceGoodsRepository;
    @Autowired
    private GoodsCrudService goodsCrudService;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={""})
    public StdData savePack(@RequestBody PackVO body) {
        if (GoodsPayType.BNPL.getCode() == body.getPayType().intValue()) {
            if (ObjectUtils.isEmpty((Object)body.getIntellyFormGroupId()) || ObjectUtils.isEmpty((Object)body.getIntellyFormId())) {
                throw new BusinessException("\u9009\u62e9\u5148\u8ba2\u540e\u4ed8\u4e4b\u540e\uff0c\u79df\u6237\u578b\u6001\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)body.getCredentialDescription())) {
                throw new BusinessException("\u9009\u62e9\u5148\u8ba2\u540e\u4ed8\u4e4b\u540e\uff0c\u51ed\u8bc1\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        return StdData.ok((Object)this.packService.savePack(body));
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/{sid}/detail"})
    public StdData savePackDetail(@RequestBody List<PackDetailVO> data, @PathVariable long sid) {
        return StdData.ok((Object)this.packService.savePackDetail(data, Long.valueOf(sid)));
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/{sid}/description"})
    public StdData saveDescription(@PathVariable Long sid, @RequestBody PackVO packVO) {
        Goods goods = (Goods)this.goodsCrudService.findBySid(sid.longValue());
        goods.setDetailDescription(packVO.getDescription());
        this.goodsCrudService.update((BaseEntity)goods);
        return StdData.ok().build();
    }

    @GetMapping(value={"/exists/{code}"})
    public StdData existsPackCode(@PathVariable String code) {
        return StdData.ok((Object)this.goodsRepository.existsByCode(code));
    }

    @GetMapping(value={"/goods"})
    public StdData getPackGoods(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="p.name asc,g.code asc") String orderBy, @RequestParam(name="params", required=false) String params) {
        PackGoodsVO condition = PackGoodsVO.getSelf((String)params);
        List packGoodsVOS = this.packQueryService.getPackGoodsByCondition(condition, pageNum.intValue(), pageSize.intValue(), orderBy);
        return StdData.ok((Object)new PageSerializable(packGoodsVOS));
    }

    @Transactional(rollbackFor={Exception.class})
    @DeleteMapping(value={"/{sid}"})
    public StdData deleteEmp(@PathVariable long sid) {
        return StdData.ok((Object)this.packService.deletePack(Long.valueOf(sid)));
    }

    @GetMapping(value={"/{sid}"})
    public StdData getPackInfo(@PathVariable long sid) {
        return StdData.ok((Object)this.packMapper.findPackVOBySid(sid));
    }

    @GetMapping(value={""})
    public StdData getPackList(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="onsale desc,p.displayname asc") String orderBy, @RequestParam(name="params", required=false) String params) {
        PackVO condition = PackVO.getSelf((String)params);
        List packVOS = this.packQueryService.getPackListByCondition(condition, pageNum.intValue(), pageSize.intValue(), orderBy);
        return StdData.ok((Object)new PageSerializable(packVOS));
    }

    @PostMapping(value={"/experience/save"})
    public StdData saveExperiencePacks(@RequestBody List<ExperiencePackVO> input) {
        List entity = input.stream().map(AbstractConverter::doForward).collect(Collectors.toList());
        this.experienceGoodsRepository.deleteAll();
        this.experienceGoodsRepository.saveAll(entity);
        return StdData.ok().build();
    }

    @GetMapping(value={"/experience/all"})
    public StdData getExperiencePacks() {
        return StdData.ok((Object)this.packMapper.getExperiencePacks());
    }

    @GetMapping(value={"/id"})
    public StdData getPackInfo(@RequestParam String id) {
        return StdData.ok((Object)this.packMapper.findPackDetailById(id));
    }
}

