/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.gmc.entity.PaymentType;
import com.digiwin.dap.middleware.gmc.repository.PaymentTypeRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cloudgoods"})
public class PaymentTypeController {
    @Autowired
    private PaymentTypeRepository paymentTypeRepository;

    @RequestMapping(value={"/paymenttype/{categoryId}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getPaymentTypesByCategoryId(@PathVariable String categoryId) {
        List paymentTypeList = "all".equals(categoryId) ? this.paymentTypeRepository.findAll() : this.paymentTypeRepository.findAllByCategoryId(categoryId);
        return ResponseEntity.ok((Object)paymentTypeList);
    }

    @RequestMapping(value={"/paymenttype/add"}, method={RequestMethod.POST})
    public ResponseEntity<?> addPaymentTypes(@RequestBody PaymentType paymentType) {
        this.paymentTypeRepository.save((Object)paymentType);
        return ResponseEntity.ok((Object)HttpStatus.CREATED);
    }

    @RequestMapping(value={"/paymenttype/update"}, method={RequestMethod.POST})
    public ResponseEntity<?> updatePaymentTypes(@RequestBody PaymentType paymentType) {
        PaymentType paymentType1 = this.paymentTypeRepository.findByCategoryIdAndId(paymentType.getCategoryId(), paymentType.getId().intValue());
        if (paymentType1 != null) {
            paymentType1.setName(paymentType.getName());
            this.paymentTypeRepository.save((Object)paymentType1);
        }
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @RequestMapping(value={"/paymenttype/delete"}, method={RequestMethod.POST})
    public ResponseEntity<?> deletePaymentTypes(@RequestBody PaymentType paymentType) {
        PaymentType paymentType1 = this.paymentTypeRepository.findByCategoryIdAndId(paymentType.getCategoryId(), paymentType.getId().intValue());
        if (paymentType1 != null) {
            this.paymentTypeRepository.delete((Object)paymentType1);
        }
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }
}

