/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.entity.Goods;
import com.digiwin.dap.middleware.gmc.entity.Product;
import com.digiwin.dap.middleware.gmc.repository.GoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.ProductRepository;
import com.digiwin.dap.middleware.gmc.service.goods.ProductService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cloudgoods"})
public class ProductController {
    @Autowired
    private ProductRepository productRepository;
    @Autowired
    private GoodsRepository goodsRepository;
    @Autowired
    private ProductService productService;

    @RequestMapping(value={"/productlist"}, method={RequestMethod.GET})
    public ResponseEntity<?> getProductList() {
        List products = this.productRepository.findAllByOrderByProductCode();
        return ResponseEntity.ok((Object)products);
    }

    @GetMapping(value={"/product/list/policy"})
    public StdData<?> getProductListPolicy() {
        List products = this.productService.listPolicy();
        return StdData.ok((Object)products);
    }

    @RequestMapping(value={"/product/add"}, method={RequestMethod.POST})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<?> addProductInfo(@RequestBody Product product) {
        EntityUtils.setCreateFields((BaseEntity)product);
        this.productRepository.save((Object)product);
        return ResponseEntity.ok((Object)HttpStatus.CREATED);
    }

    @RequestMapping(value={"/product/update"}, method={RequestMethod.POST})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<?> updateProductInfo(@RequestBody Product product) {
        Product product1 = this.productRepository.findByProductCode(product.getProductCode());
        product1.setProductCategory(product.getProductCategory());
        product1.setProductName(product.getProductName());
        product1.setProductType(product.getProductType());
        product1.setRemark(product.getRemark());
        product1.setToStrategy(product.getToStrategy());
        EntityUtils.setModifyFields((BaseEntity)product1);
        this.productRepository.save((Object)product1);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @RequestMapping(value={"/product/delete"}, method={RequestMethod.POST})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<?> deleteProductInfo(@RequestBody Product product) {
        Product product1 = this.productRepository.findByProductCode(product.getProductCode());
        List goods = this.goodsRepository.findByProductCode(product.getProductCode());
        String goodsCodes = goods.stream().map(Goods::getCode).collect(Collectors.joining(","));
        if (!StringUtils.isEmpty((Object)goodsCodes)) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_PRODUCT_DELETE, new Object[]{goodsCodes});
        }
        this.productRepository.delete((Object)product1);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }
}

