/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.coupon.PromotionMixConditionVO;
import com.digiwin.dap.middleware.gmc.domain.coupon.PromotionMixGoodsVO;
import com.digiwin.dap.middleware.gmc.domain.coupon.PromotionMixVO;
import com.digiwin.dap.middleware.gmc.mapper.PromotionMixGoodsMapper;
import com.digiwin.dap.middleware.gmc.mapper.PromotionMixMapper;
import com.digiwin.dap.middleware.gmc.service.coupon.PromotionMixService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.github.pagehelper.PageSerializable;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/promotions"})
public class PromotionMixController {
    @Autowired
    private PromotionMixMapper promotionMixMapper;
    @Autowired
    private PromotionMixService promotionMixService;
    @Autowired
    private PromotionMixGoodsMapper promotionMixGoodsMapper;

    @PostMapping(value={""})
    @Transactional(rollbackFor={Exception.class})
    public StdData save(@Valid @RequestBody PromotionMixVO promotionMixVO) {
        return StdData.ok((Object)this.promotionMixService.save(promotionMixVO));
    }

    @PostMapping(value={"/{promotionSid}"})
    @Transactional(rollbackFor={Exception.class})
    public StdData save(@PathVariable Long promotionSid, @RequestBody PromotionMixVO promotionMixVO) {
        promotionMixVO.setSid(promotionSid);
        return StdData.ok((Object)this.promotionMixService.update(promotionMixVO));
    }

    @GetMapping(value={"/{promotionSid}"})
    public StdData getDetail(@PathVariable Long promotionSid) {
        PromotionMixVO promotionMixVO = this.promotionMixMapper.getDetail(promotionSid.longValue());
        return StdData.ok((Object)promotionMixVO);
    }

    @GetMapping(value={""})
    public StdData getList(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="sid desc") String orderBy, @RequestParam(name="params", required=false) String params) {
        PromotionMixConditionVO conditionVO;
        try {
            conditionVO = StringUtils.isEmpty((Object)params) ? new PromotionMixConditionVO() : (PromotionMixConditionVO)JsonUtils.createObjectMapper().readValue(params, PromotionMixConditionVO.class);
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "params\u89e3\u6790\u5f02\u5e38");
        }
        PageSerializable pageSerializable = this.promotionMixService.getList(conditionVO, pageNum, pageSize, orderBy);
        return StdData.ok((Object)pageSerializable);
    }

    @DeleteMapping(value={"/{promotionSid}"})
    @Transactional(rollbackFor={Exception.class})
    public StdData delete(@PathVariable Long promotionSid) {
        this.promotionMixService.delete(promotionSid.longValue());
        return StdData.ok().build();
    }

    @PostMapping(value={"/{promotionSid}/goods"})
    @Transactional(rollbackFor={Exception.class})
    public StdData updateGoods(@PathVariable Long promotionSid, @RequestBody List<PromotionMixGoodsVO> promotionMixGoodsVOs) {
        this.promotionMixService.updateGoods(promotionSid.longValue(), promotionMixGoodsVOs);
        return StdData.ok().build();
    }

    @GetMapping(value={"/{promotionSid}/goods"})
    public StdData getGoods(@PathVariable Long promotionSid) {
        List promotionMixGoodsVOS = this.promotionMixService.getGoods(promotionSid.longValue());
        return StdData.ok((Object)promotionMixGoodsVOS);
    }

    @GetMapping(value={"/{goodsCode}/promotion"})
    public StdData getPromotionMix(@PathVariable String goodsCode, Long strategySid) {
        PromotionMixVO promotionMixVO = this.promotionMixService.getPromotionMix(goodsCode, strategySid);
        return StdData.ok((Object)promotionMixVO);
    }
}

