/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.recommendactivity.ActivityAndUserVO;
import com.digiwin.dap.middleware.gmc.domain.recommendactivity.QueryParemater;
import com.digiwin.dap.middleware.gmc.domain.recommendactivity.RecommendActivityResultVO;
import com.digiwin.dap.middleware.gmc.domain.recommendactivity.RecommendActivitySearchParamVO;
import com.digiwin.dap.middleware.gmc.domain.recommendactivity.RecommendActivityVO;
import com.digiwin.dap.middleware.gmc.domain.recommenduser.RecommendUserVO;
import com.digiwin.dap.middleware.gmc.service.recommendactivity.RecommendActivityCrudService;
import com.digiwin.dap.middleware.gmc.service.recommendactivity.RecommendActivityDisableService;
import com.digiwin.dap.middleware.gmc.service.recommendactivity.RecommendActivityEnableService;
import com.digiwin.dap.middleware.gmc.service.recommendactivity.RecommendActivityQueryService;
import com.digiwin.dap.middleware.gmc.service.recommendactivity.RecommendActivityService;
import com.digiwin.dap.middleware.gmc.service.recommenduser.RecommendUserCrudService;
import com.digiwin.dap.middleware.gmc.service.recommenduser.RecommendUserService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageSerializable;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/recommendactivity"})
public class RecommendActivityController {
    private static ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    @Autowired
    RecommendActivityQueryService recommendActivityQueryService;
    @Autowired
    RecommendActivityCrudService recommendActivityCrudService;
    @Autowired
    RecommendUserCrudService recommendUserCrudService;
    @Autowired
    RecommendActivityService recommendActivityService;
    @Autowired
    RecommendUserService recommendUserService;
    @Autowired
    RecommendActivityDisableService recommendActivityDisableService;
    @Autowired
    RecommendActivityEnableService recommendActivityEnableService;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={""})
    public ResponseEntity<?> updateRecommendActivity(@RequestBody @Valid ActivityAndUserVO activityAndUserVO) {
        RecommendActivityVO recommendActivityVO = activityAndUserVO.getRecommendActivityVO();
        List recommendUserVOS = activityAndUserVO.getRecommendUserVOS();
        long recommendActivitySid = recommendActivityVO.getSid();
        if (recommendActivitySid == 0L) {
            recommendActivitySid = this.recommendActivityService.addRecommendActivity(recommendActivityVO);
        } else {
            this.recommendActivityService.modifyRecommendActivity(recommendActivityVO);
        }
        if (recommendUserVOS.size() > 0) {
            for (RecommendUserVO recommendUserVO : recommendUserVOS) {
                recommendUserVO.setRecommendActivitySid(recommendActivitySid);
                this.recommendUserService.addRecommendActivity(recommendUserVO);
            }
        }
        return ResponseEntity.ok((Object)recommendActivitySid);
    }

    @GetMapping(value={""})
    public ResponseEntity<?> getRecommendActivityList(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="g.create_date desc") String orderBy, @RequestParam(name="params", required=false) String params) {
        RecommendActivitySearchParamVO recommendActivitySearchParamVO = null;
        if (!StringUtils.isEmpty((Object)params)) {
            try {
                recommendActivitySearchParamVO = (RecommendActivitySearchParamVO)objectMapper.readValue(params, RecommendActivitySearchParamVO.class);
            }
            catch (IOException o) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "params\u89e3\u6790\u9519\u8bef");
            }
        }
        PageSerializable recommendActivityPage = this.recommendActivityQueryService.getRecommendActivityResultVos(recommendActivitySearchParamVO, pageNum.intValue(), pageSize.intValue(), orderBy);
        return ResponseEntity.ok((Object)recommendActivityPage);
    }

    @GetMapping(value={"/noneed/datapolicy"})
    public ResponseEntity<?> getRecommendActivities(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="params", required=false) String params) {
        RecommendActivitySearchParamVO recommendActivitySearchParamVO = null;
        if (!StringUtils.isEmpty((Object)params)) {
            try {
                recommendActivitySearchParamVO = (RecommendActivitySearchParamVO)objectMapper.readValue(params, RecommendActivitySearchParamVO.class);
            }
            catch (IOException o) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "params\u89e3\u6790\u9519\u8bef");
            }
        }
        PageSerializable recommendActivityPage = this.recommendActivityQueryService.getRecommendActivityResultVoList(recommendActivitySearchParamVO, pageNum.intValue(), pageSize.intValue());
        return ResponseEntity.ok((Object)recommendActivityPage);
    }

    @GetMapping(value={"/{sid}"})
    public ResponseEntity<?> getRecommendActivity(@PathVariable(value="sid") long sid) {
        RecommendActivityResultVO recommendActivityResultVO = this.recommendActivityQueryService.getRecommendActivityResultVo(sid);
        return ResponseEntity.ok((Object)recommendActivityResultVO);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/{sid}/enable"})
    public ResponseEntity<?> enableRecommendActivity(@PathVariable long sid) {
        this.recommendActivityEnableService.enable(sid);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/{sid}/disable"})
    public ResponseEntity<?> disableRecommendActivity(@PathVariable long sid) {
        this.recommendActivityDisableService.disable(sid);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/shareachievement"})
    public ResponseEntity<?> updateShareAchievement(@RequestBody QueryParemater queryParemater) {
        this.recommendActivityService.updateShareAchievement(queryParemater);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @DeleteMapping(value={"/{sid}"})
    public ResponseEntity<?> deleteRecommendActivity(@PathVariable long sid) {
        this.recommendActivityService.removeRecommendActivity(sid);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }
}

