/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.gmc.domain.recommenduser.BuildExclusiveReferralCodeVO;
import com.digiwin.dap.middleware.gmc.domain.recommenduser.RecommendUserVO;
import com.digiwin.dap.middleware.gmc.domain.recommenduser.ReferralCodeVO;
import com.digiwin.dap.middleware.gmc.entity.RecommendUser;
import com.digiwin.dap.middleware.gmc.service.recommenduser.CreateExclusiveReferralCodeService;
import com.digiwin.dap.middleware.gmc.service.recommenduser.RecommendUserCrudService;
import com.digiwin.dap.middleware.gmc.service.recommenduser.RecommendUserQueryService;
import com.digiwin.dap.middleware.gmc.service.recommenduser.RecommendUserService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/recommenduser"})
public class RecommendUserController {
    @Autowired
    RecommendUserCrudService recommendUserCrudService;
    @Autowired
    RecommendUserQueryService recommendUserQueryService;
    @Autowired
    RecommendUserService recommendUserService;
    @Autowired
    CreateExclusiveReferralCodeService createExclusiveReferralCodeService;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={""})
    public ResponseEntity<?> updateRecommendUser(@RequestBody RecommendUserVO recommendUserVO) {
        if (recommendUserVO.getSid() == 0L) {
            long sid = this.recommendUserService.addRecommendActivity(recommendUserVO);
            return ResponseEntity.ok((Object)sid);
        }
        this.recommendUserService.modifyRecommendActivity(recommendUserVO);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @GetMapping(value={"/activity/{activitySid}"})
    public ResponseEntity<?> getRecommendUsers(@PathVariable(value="activitySid") long activitySid) {
        List recommendUsers = this.recommendUserQueryService.getRecommendUsers(activitySid);
        return ResponseEntity.ok((Object)recommendUsers);
    }

    @GetMapping(value={"/{sid}"})
    public ResponseEntity<?> getRecommendUser(@PathVariable(value="sid") long sid) {
        RecommendUser recommendUser = (RecommendUser)this.recommendUserCrudService.findBySid(sid);
        return ResponseEntity.ok((Object)recommendUser);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/create/exclusivereferralcode"})
    public ResponseEntity<?> createExclusiveReferralCode(@Validated @RequestBody BuildExclusiveReferralCodeVO buildExclusiveReferralCodeVO) {
        RecommendUser recommendUser = this.createExclusiveReferralCodeService.createExclusiveReferralCode(buildExclusiveReferralCodeVO);
        return ResponseEntity.ok((Object)recommendUser);
    }

    @PostMapping(value={"/validate/referralcodes"})
    public ResponseEntity<?> validateReferralCode(@Validated @RequestBody ReferralCodeVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        return ResponseEntity.ok((Object)this.recommendUserService.validateReferralCode(authoredUser.getTenantSid(), authoredUser.getSid(), body.getCode(), body.getAppId()));
    }
}

