/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.gmc.domain.excel.ImportExcelResultVO;
import com.digiwin.dap.middleware.gmc.domain.release.ReleaseDescriptionAllVO;
import com.digiwin.dap.middleware.gmc.domain.release.ReleaseDescriptionDTO;
import com.digiwin.dap.middleware.gmc.domain.release.ReleaseDescriptionDetailVO;
import com.digiwin.dap.middleware.gmc.domain.release.ReleaseDescriptionRemoteInputVO;
import com.digiwin.dap.middleware.gmc.domain.release.ReleaseDescriptionRemoteLevel1VO;
import com.digiwin.dap.middleware.gmc.domain.release.ReleaseDescriptionVO;
import com.digiwin.dap.middleware.gmc.service.release.ReleaseDescriptionService;
import com.github.pagehelper.PageSerializable;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/release"})
public class ReleaseDescriptionController {
    @Resource
    private ReleaseDescriptionService releaseDescriptionService;

    @PostMapping(value={"/import"})
    public ResponseEntity<ImportExcelResultVO> importUserMapping(@RequestBody ReleaseDescriptionDTO input) {
        return ResponseEntity.ok((Object)this.releaseDescriptionService.importExcel(input.getFileId(), input.getAppId()));
    }

    @PostMapping(value={"/search"})
    public ResponseEntity<PageSerializable<ReleaseDescriptionVO>> search(@RequestBody ReleaseDescriptionDTO input) {
        input.setOrderBy(Optional.ofNullable(input.getOrderBy()).orElse("r.sid desc"));
        return ResponseEntity.ok((Object)this.releaseDescriptionService.search(input));
    }

    @PostMapping(value={"/shelve/{sid}/{status}"})
    public StdData<?> shelve(@PathVariable boolean status, @PathVariable long sid) {
        this.releaseDescriptionService.shelve(status, sid);
        return StdData.ok().build();
    }

    @PostMapping(value={"/del"})
    public StdData<?> delete(@RequestBody ReleaseDescriptionDTO input) {
        this.releaseDescriptionService.delete(input);
        return StdData.ok().build();
    }

    @PostMapping(value={"detail/del"})
    public StdData<?> deleteDetail(@RequestBody ReleaseDescriptionDTO input) {
        this.releaseDescriptionService.deleteDetail(input);
        return StdData.ok().build();
    }

    @PostMapping(value={"detail/mod"})
    public StdData<?> deleteDetail(@RequestBody ReleaseDescriptionDetailVO input) {
        this.releaseDescriptionService.modDetail(input);
        return StdData.ok().build();
    }

    @PostMapping(value={"/find"})
    public StdData<?> find(@RequestBody ReleaseDescriptionDTO input) {
        ReleaseDescriptionAllVO allVO = this.releaseDescriptionService.find(input);
        return StdData.ok((Object)allVO);
    }

    @PostMapping(value={"/query"})
    public StdData<List<ReleaseDescriptionRemoteLevel1VO>> find(@RequestBody ReleaseDescriptionRemoteInputVO input) {
        input.setOrderBy(Optional.ofNullable(input.getOrderBy()).orElse("r.create_date desc"));
        List allVO = this.releaseDescriptionService.remoteQuery(input);
        return StdData.ok((Object)allVO);
    }
}

