/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.gmc.domain.page.Page;
import com.digiwin.dap.middleware.gmc.domain.page.PageData;
import com.digiwin.dap.middleware.gmc.mapper.GoodsMapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2"})
public class SelectController {
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private DictDataService dictDataService;

    @PostMapping(value={"/goods/code/item"})
    public ResponseEntity<?> getGoodsCode(@RequestBody Page data) {
        String code = String.valueOf(data.getFilters().get("code"));
        String servicer = String.valueOf(data.getFilters().get("servicer"));
        PageInfo pageInfo = PageHelper.startPage((int)data.getPageNum(), (int)data.getPageSize()).doSelectPageInfo(() -> this.goodsMapper.findGoodsCodesByPage(code, servicer));
        return ResponseEntity.ok((Object)PageData.get((PageInfo)pageInfo));
    }

    @PostMapping(value={"/product/code/item"})
    public ResponseEntity<?> getProductCode(@RequestBody Page data) {
        String code = String.valueOf(data.getFilters().get("code"));
        PageInfo pageInfo = PageHelper.startPage((int)data.getPageNum(), (int)data.getPageSize()).doSelectPageInfo(() -> this.goodsMapper.findProductCodesByPage(code));
        return ResponseEntity.ok((Object)PageData.get((PageInfo)pageInfo));
    }
}

