/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.GmcConstant;
import com.digiwin.dap.middleware.gmc.constant.I18nCode;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.calculate.OrderDetailItemsVO;
import com.digiwin.dap.middleware.gmc.domain.calculate.PriceParamVO;
import com.digiwin.dap.middleware.gmc.domain.calculate.ShoppingCartVO;
import com.digiwin.dap.middleware.gmc.domain.calculate.TotalPriceVO;
import com.digiwin.dap.middleware.gmc.domain.sellingstrategy.QueryStrategyDTO;
import com.digiwin.dap.middleware.gmc.domain.sellingstrategy.SellingStrategyRequest;
import com.digiwin.dap.middleware.gmc.domain.sellingstrategy.SellingStrategyVO;
import com.digiwin.dap.middleware.gmc.entity.Goods;
import com.digiwin.dap.middleware.gmc.entity.PackDetail;
import com.digiwin.dap.middleware.gmc.entity.SellingStrategy;
import com.digiwin.dap.middleware.gmc.repository.GoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.PackDetailRepository;
import com.digiwin.dap.middleware.gmc.repository.SellingStrategyRepository;
import com.digiwin.dap.middleware.gmc.service.goods.CalculateService;
import com.digiwin.dap.middleware.gmc.service.goods.SellingStrategyCrudService;
import com.digiwin.dap.middleware.gmc.service.goods.SellingStrategyService;
import com.digiwin.dap.middleware.gmc.service.pack.PackService;
import com.digiwin.dap.middleware.gmc.support.helper.CacheHelper;
import com.digiwin.dap.middleware.util.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.poi.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cloudgoods"})
public class SellingStrategyController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SellingStrategyController.class);
    @Autowired
    private SellingStrategyService sellingStrategyService;
    @Autowired
    private SellingStrategyCrudService sellingStrategyCrudService;
    @Autowired
    private SellingStrategyRepository sellingStrategyRepository;
    @Autowired
    private CalculateService calculateService;
    @Autowired
    private PackDetailRepository packDetailRepository;
    @Autowired
    private GoodsRepository goodsRepository;
    @Autowired
    private CacheHelper cacheHelper;
    @Autowired
    private PackService packService;

    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"/{goodsCode}/sellingstrategy"}, method={RequestMethod.POST})
    public StdData<?> saveSellingStrategy(@PathVariable String goodsCode, @Validated @RequestBody SellingStrategyVO sellingStrategyVO) {
        List packDetails;
        this.cacheHelper.delCorrespondingCaches("gmc:/api/cloudgoods/list:");
        if (Boolean.TRUE.equals(sellingStrategyVO.getBnpl())) {
            if (ObjectUtils.isEmpty((Object)sellingStrategyVO.getIntellyFormGroupId()) || ObjectUtils.isEmpty((Object)sellingStrategyVO.getIntellyFormId())) {
                throw new BusinessException("\u9009\u62e9\u5148\u8ba2\u540e\u4ed8\u4e4b\u540e\uff0c\u79df\u6237\u578b\u6001\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)sellingStrategyVO.getCredentialDescription())) {
                throw new BusinessException("\u9009\u62e9\u5148\u8ba2\u540e\u4ed8\u4e4b\u540e\uff0c\u51ed\u8bc1\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (ObjectUtils.nullSafeEquals((Object)Boolean.TRUE, (Object)sellingStrategyVO.getEnableTenancy()) && ObjectUtils.isEmpty((Object)sellingStrategyVO.getTenancyPeriod())) {
            throw new BusinessException("\u542f\u7528\u79df\u671f\u4e4b\u540e\uff0c\u79df\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)sellingStrategyVO.getId()) || sellingStrategyVO.getId() == 0L) {
            if (this.sellingStrategyRepository.existsByCode(sellingStrategyVO.getCode())) {
                return StdData.of((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)"\u9500\u552e\u65b9\u6848id\u5df2\u5b58\u5728");
            }
            long sid = this.sellingStrategyService.create(sellingStrategyVO);
            return StdData.ok(Collections.singletonMap("sid", sid));
        }
        List<Object> goodsNames = new ArrayList();
        SellingStrategy oldSellingStrategy = (SellingStrategy)this.sellingStrategyCrudService.findBySid(sellingStrategyVO.getId().longValue());
        if (Boolean.TRUE.equals(oldSellingStrategy.getEnable()) && Boolean.FALSE.equals(sellingStrategyVO.getEnable()) && !(packDetails = this.packDetailRepository.findByStrategySid(sellingStrategyVO.getId())).isEmpty()) {
            Set sidSet = packDetails.stream().map(PackDetail::getPackSid).collect(Collectors.toSet());
            goodsNames = this.goodsRepository.findAllById(sidSet).stream().filter(goods -> GmcConstant.GoodsStatus.OnSale.ordinal() == goods.getOnSale().intValue()).map(Goods::getDisplayName).collect(Collectors.toList());
        }
        this.sellingStrategyService.update(sellingStrategyVO);
        if (!goodsNames.isEmpty()) {
            return StdData.ok((Object)String.format(I18nCode.SELLING_STRATEGY_DISABLE_PACKAGE_TIPS.getMessage(), StringUtil.join((String)",", (Object[])new Object[]{goodsNames})));
        }
        return StdData.ok(Collections.singletonMap("sid", oldSellingStrategy.getSid()));
    }

    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"/{goodsCode}/sellingstrategys/{sellingStrategyCode}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> deleteSellingStrategy(@PathVariable String goodsCode, @PathVariable String sellingStrategyCode) {
        this.cacheHelper.delCorrespondingCaches("gmc:/api/cloudgoods/list:");
        this.packService.checkDeletableResourceGoodsStrategy(sellingStrategyCode);
        this.sellingStrategyCrudService.deleteByCode(sellingStrategyCode);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @RequestMapping(value={"/{goodsCode}/sellingstrategys/code/{sellingStrategyCode}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getSellingStrategy(@PathVariable String goodsCode, @PathVariable String sellingStrategyCode) {
        SellingStrategyVO sellingStrategyWithGoodsVO = this.sellingStrategyService.getSellingStrategyWithGoodsByCode(goodsCode, sellingStrategyCode);
        return ResponseEntity.ok((Object)sellingStrategyWithGoodsVO);
    }

    @RequestMapping(value={"/sellingstrategys/code/{sellingStrategyCode}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getSellingStrategy(@PathVariable String sellingStrategyCode) {
        SellingStrategyVO sellingStrategyWithGoodsVO = this.sellingStrategyService.getSellingStrategyWithGoodsByCode("", sellingStrategyCode);
        return ResponseEntity.ok((Object)sellingStrategyWithGoodsVO);
    }

    @RequestMapping(value={"/{goodsId}/sellingstrategys/{sellingStrategyId}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getSellingStrategyById(@PathVariable String sellingStrategyId) {
        SellingStrategyVO sellingStrategyWithGoodsVO = this.sellingStrategyService.getSellingStrategyWithGoodsById(sellingStrategyId);
        return ResponseEntity.ok((Object)sellingStrategyWithGoodsVO);
    }

    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"/{goodsCode}/sellingstrategys/{sellingStrategyCode}/ismainpush/{mainPush}"}, method={RequestMethod.POST})
    public ResponseEntity<?> setIsMainPush(@PathVariable String goodsCode, @PathVariable String sellingStrategyCode, @PathVariable boolean mainPush) {
        this.sellingStrategyService.setMainPush(goodsCode, sellingStrategyCode, mainPush);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @RequestMapping(value={"/calculatetotalprice", "/calculatetotalprice/"}, method={RequestMethod.POST})
    public ResponseEntity<?> calculateTotalPrice(@Validated @RequestBody PriceParamVO priceParamVO) {
        if (priceParamVO.getPaymentType() == 1) {
            Assert.notNull((Object)priceParamVO.getUserNumber(), (String)"UserNumber:UserNumber\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            Assert.notNull((Object)priceParamVO.getCacUserNumber(), (String)"CacUserNumber:CacUserNumber\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        AssertUtils.paramHasText((String)priceParamVO.getSellingStrategyId(), (String)"SellingStrategyId(\u9500\u552e\u65b9\u6848ID)");
        TotalPriceVO totalPriceVO = this.calculateService.calculateMonthTotalPrice(priceParamVO);
        return ResponseEntity.ok((Object)totalPriceVO);
    }

    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"/calculatetotalprice/purchaseuser"}, method={RequestMethod.POST})
    public ResponseEntity<?> calculatePurchaseUserPrice(@Validated @RequestBody PriceParamVO priceParamVO) {
        if (priceParamVO.getPaymentType() != 1) {
            return ResponseEntity.ok((Object)HttpStatus.OK);
        }
        Assert.notNull((Object)priceParamVO.getUserNumber(), (String)"UserNumber:UserNumber\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        TotalPriceVO totalPriceVO = this.calculateService.calculatePurchaseUserPrice(priceParamVO);
        return ResponseEntity.ok((Object)totalPriceVO);
    }

    @RequestMapping(value={"/calculatetotalprice/shoppingcart"}, method={RequestMethod.POST})
    public ResponseEntity<?> calculateShoppingCartPrice(@Validated @RequestBody ShoppingCartVO shoppingCartVO) {
        AssertUtils.paramHasText((String)shoppingCartVO.getTenantId(), (String)"tenantId");
        AssertUtils.paramNotNull((Object)shoppingCartVO.getContractTenant(), (String)"contractTenant");
        Assert.notEmpty((Collection)shoppingCartVO.getGoods(), (String)"Goods:\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        return ResponseEntity.ok((Object)this.calculateService.calculateShoppingCartPrice(shoppingCartVO));
    }

    @RequestMapping(value={"/calculateitemprice"}, method={RequestMethod.POST})
    public ResponseEntity<?> calculateItemPrice(@Validated @RequestBody OrderDetailItemsVO orderDetailItemsVO) {
        OrderDetailItemsVO orderItemPrice = this.calculateService.calculateOrderItemPrice(orderDetailItemsVO);
        return ResponseEntity.ok((Object)orderItemPrice);
    }

    @RequestMapping(value={"/calculatetotalprice/dev/shoppingcart"}, method={RequestMethod.POST})
    public ResponseEntity<?> calculateDevShoppingCartPrice(@Validated @RequestBody ShoppingCartVO shoppingCartVO) {
        return ResponseEntity.ok((Object)this.calculateService.calculateDevShoppingCartPrice(shoppingCartVO));
    }

    @PostMapping(value={"/sellingstrategy/list"})
    public StdData<?> getSellingStrategy(@RequestBody QueryStrategyDTO dto) {
        return StdData.ok((Object)this.sellingStrategyService.getSellingStrategy(dto));
    }

    @GetMapping(value={"/sellingstrategy/code/exists"})
    public StdData<?> existByCode(@RequestParam String code, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        return StdData.ok((Object)this.sellingStrategyRepository.existsByCode(code));
    }

    @PostMapping(value={"/sellingstrategy/simple/mod"})
    public StdData<?> updateSellingStrategy(@RequestBody SellingStrategyRequest req, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        AssertUtils.paramNotNull((Object)req.getSid(), (String)"sid");
        SellingStrategy sellingStrategy = (SellingStrategy)this.sellingStrategyCrudService.findBySid(req.getSid().longValue());
        AssertUtils.isTrue((sellingStrategy != null ? 1 : 0) != 0, (ErrorHandler)I18nError.GMC_SELLING_STRATEGY_NOT_EXISTED, (Object[])new Object[]{req.getSid()});
        if (req.getOptionalOrderPeriods() != null) {
            sellingStrategy.setOptionalOrderPeriod(req.getOptionalOrderPeriods().stream().map(String::valueOf).collect(Collectors.joining(",")));
        }
        this.sellingStrategyCrudService.update((BaseEntity)sellingStrategy);
        return StdData.ok(Collections.singletonMap("sid", sellingStrategy.getSid()));
    }
}

