/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.gmc.domain.sellingstrategy.SellingStrategyVO;
import com.digiwin.dap.middleware.gmc.mapper.SellingStrategyMapper;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/sellingstrategy"})
public class SellingStrategyV2Controller {
    @Autowired
    private SellingStrategyMapper sellingStrategyMapper;

    @PostMapping(value={"/list"})
    public ResponseEntity<?> getSellingStrategyListBySids(@RequestBody Map<String, Object> params) {
        List sellingStrategySids = null;
        List sellingStrategyCodes = null;
        if (params.containsKey("sids")) {
            sellingStrategySids = (List)params.get("sids");
        }
        if (params.containsKey("codes")) {
            sellingStrategyCodes = (List)params.get("codes");
        }
        List strategy = this.sellingStrategyMapper.getSellingStrategyBySids(sellingStrategySids, sellingStrategyCodes);
        strategy.forEach(SellingStrategyVO::changeModulesAndCustomAttributeType);
        return ResponseEntity.ok((Object)StdData.ok((Object)strategy));
    }

    @PostMapping(value={"list/bygoodscode"})
    public ResponseEntity<?> getSellingStrategyByGoodsCode(@RequestBody Map<String, Object> mapParams) {
        List goodsCodes = null;
        if (mapParams.containsKey("goodsCodes")) {
            goodsCodes = (List)mapParams.get("goodsCodes");
        }
        int isEnable = 1;
        if (mapParams.containsKey("isEnable")) {
            isEnable = (Integer)mapParams.get("isEnable");
        }
        List strategy = this.sellingStrategyMapper.getSellingStrategyByGoodsCodes(goodsCodes, isEnable);
        strategy.forEach(SellingStrategyVO::changeModulesAndCustomAttributeType);
        return ResponseEntity.ok((Object)StdData.ok((Object)strategy));
    }
}

