/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.domain.tag.TagCategoryVO;
import com.digiwin.dap.middleware.gmc.domain.tag.TagOwnedVO;
import com.digiwin.dap.middleware.gmc.entity.tag.TagOwned;
import com.digiwin.dap.middleware.gmc.service.tag.TagOwnedCrudService;
import com.digiwin.dap.middleware.gmc.service.tag.TagService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v1/tag"})
public class TagController {
    @Resource
    private TagOwnedCrudService tagOwnedCrudService;
    @Resource
    private TagService tagService;

    @PostMapping(value={"/owned/add"})
    public StdData<?> addOwned(@RequestBody TagOwnedVO vo) {
        return StdData.ok((Object)this.tagOwnedCrudService.create((BaseEntity)vo.doForward()));
    }

    @PostMapping(value={"/owned/mod"})
    public StdData<?> modOwned(@RequestBody TagOwnedVO vo) {
        TagOwned bySid = (TagOwned)this.tagOwnedCrudService.findBySid(vo.getSid().longValue());
        if (bySid != null) {
            bySid.setName(vo.getName());
            this.tagOwnedCrudService.update((BaseEntity)bySid);
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/owned/del"})
    public StdData<?> delOwned(@RequestBody TagOwnedVO vo) {
        TagOwned bySid = (TagOwned)this.tagOwnedCrudService.findBySid(vo.getSid().longValue());
        if (bySid != null) {
            this.tagOwnedCrudService.deleteById(vo.getSid().longValue());
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/owned/find"})
    public StdData<?> findOwned(@RequestBody TagOwnedVO vo) {
        List all = this.tagOwnedCrudService.findAll();
        return StdData.ok(all.stream().map(TagOwnedVO::new).collect(Collectors.toList()));
    }

    @PostMapping(value={"/category/save"})
    public StdData<?> addCategory(@RequestBody TagCategoryVO vo) {
        this.tagService.saveCategory(vo);
        return StdData.ok().build();
    }

    @PostMapping(value={"/category/find"})
    public StdData<?> findCategory(@RequestBody TagCategoryVO vo) {
        return StdData.ok((Object)this.tagService.findALlCategory(vo));
    }

    @PostMapping(value={"/category/del"})
    public StdData<?> delCategory(@RequestBody TagCategoryVO vo) {
        this.tagService.delCategory(vo);
        return StdData.ok().build();
    }

    @PostMapping(value={"/category/shelve"})
    public StdData<?> shelveCategory(@RequestBody TagCategoryVO vo) {
        this.tagService.shelveCategory(vo);
        return StdData.ok().build();
    }
}

