/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.gmc.domain.marketing.MarketingConfigDetailVO;
import com.digiwin.dap.middleware.gmc.service.marketing.impl.MarketingConfigCrudServiceImpl;
import com.digiwin.dap.middleware.gmc.support.remote.MailService;
import com.digiwin.dap.middleware.gmc.support.schedule.ScheduleTaskService;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/test"})
public class TestController {
    @Autowired
    MailService mailService;
    @Autowired
    MarketingConfigCrudServiceImpl goodServiceImpl;
    @Autowired
    private ScheduleTaskService scheduleTaskService;

    @GetMapping(value={"/mail/1"})
    public ResponseEntity<?> health1() {
        this.mailService.sendAuthExpireGoods();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(2);
        result.put("note", "25\u53f7\u5230\u671f\u5217\u8868\u6d4b\u8bd5\u63a5\u53e3\u505c\u6b62\u4f7f\u7528");
        result.put("server-time", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now()));
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/mail/2"})
    public ResponseEntity<?> health2() {
        this.mailService.sendGoodsExpire();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(2);
        result.put("note", "\u5230\u671f\u6388\u6743");
        result.put("server-time", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now()));
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/mail/3"})
    public ResponseEntity<?> couponExpired() {
        this.mailService.sendExpiredCoupon();
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @GetMapping(value={"/mail/4"})
    public ResponseEntity<?> sendGoodsExpire() {
        this.mailService.sendGoodsExpire();
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @GetMapping(value={"/csh/4"})
    public ResponseEntity<?> test111() {
        List kcf = this.goodServiceImpl.findPlatformByMainGoodsCodeIn(Arrays.asList("EEAtest"));
        Map goodsOnPlatformMap = kcf.stream().collect(Collectors.groupingBy(MarketingConfigDetailVO::getMainGoodsCode, Collectors.mapping(MarketingConfigDetailVO::getAttachedGoodsCode, Collectors.toList())));
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @GetMapping(value={"/invoke/scheduleTask/{methodName}"})
    public ResponseEntity<?> invokeScheduleTask(@PathVariable String methodName) {
        try {
            Method method = this.scheduleTaskService.getClass().getMethod(methodName, new Class[0]);
            method.invoke((Object)this.scheduleTaskService, new Object[0]);
            return ResponseEntity.ok((Object)"ok");
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("\u8c03\u7528\u5931\u8d25: " + e.getMessage()));
        }
    }
}

