/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.domain.Page;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.domain.unitconversion.request.CreateUnitConversionRequest;
import com.digiwin.dap.middleware.gmc.domain.unitconversion.request.QueryUnitConversionRequest;
import com.digiwin.dap.middleware.gmc.domain.unitconversion.request.UpdateUnitConversionRequest;
import com.digiwin.dap.middleware.gmc.service.goods.UnitConversionService;
import com.github.pagehelper.PageSerializable;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/unit/conversion"})
public class UnitConversionController {
    @Autowired
    private UnitConversionService unitConversionService;

    @PostMapping(value={"/save"})
    public StdData<?> saveUnitConversion(@RequestBody @Valid CreateUnitConversionRequest request, Errors errors) {
        if (errors.hasErrors()) {
            throw new BusinessException(this.validMsg(errors));
        }
        Long sid = this.unitConversionService.createUnitConversion(request.buildCreateUnitConversionDTO());
        return StdData.ok((Object)sid);
    }

    @PostMapping(value={"/update"})
    public StdData<?> updateUnitConversion(@RequestBody @Valid UpdateUnitConversionRequest request, Errors errors) {
        if (errors.hasErrors()) {
            throw new BusinessException(this.validMsg(errors));
        }
        this.unitConversionService.updateUnitConversion(request.buildUpdateUnitConversionDTO());
        return StdData.ok().build();
    }

    @GetMapping(value={"/del"})
    public StdData<?> delUnitConversion(@RequestParam Long sid) {
        this.unitConversionService.deleteUnitConversion(sid);
        return StdData.ok().build();
    }

    @GetMapping(value={"/page/search"})
    public StdData<?> pageUnitConversion(Page page, QueryUnitConversionRequest request) {
        PageSerializable pageInfo = this.unitConversionService.pageUnitConversion(request.buildQueryUnitConversionDTO(), page);
        return StdData.ok((Object)pageInfo);
    }

    private String validMsg(Errors errors) {
        StringBuilder sBuilder = new StringBuilder();
        List list = errors.getAllErrors();
        for (ObjectError error : list) {
            sBuilder.append(error.getDefaultMessage());
        }
        return sBuilder.toString();
    }
}

