/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.support.upgrade.UpgradeDatabase;
import com.digiwin.dap.middleware.util.JdbcUtils;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/upgrade"})
public class UpgradeDatabaseController {
    @Autowired
    UpgradeDatabase upgradeDatabase;
    String oldUrl;
    String oldUsername;
    String oldPassword;

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={""})
    public ResponseEntity<?> upgradeDataBase() throws Exception {
        JdbcUtils jdbcOld = JdbcUtils.create((String)this.oldUrl, (String)this.oldUsername, (String)this.oldPassword);
        try {
            this.upgradeDatabase.upgradeAreaTaxRate(jdbcOld);
            this.upgradeDatabase.upgradeCategory(jdbcOld);
            this.upgradeDatabase.upgradeGoods(jdbcOld);
            this.upgradeDatabase.upgradePaymentType(jdbcOld);
            this.upgradeDatabase.upgradeProduct(jdbcOld);
            this.upgradeDatabase.upgradeSellingStrategy(jdbcOld);
            ResponseEntity responseEntity = ResponseEntity.ok((Object)HttpStatus.OK);
            return responseEntity;
        }
        catch (Exception e) {
            throw new BusinessException("\u6570\u636e\u5e93\u5347\u7ea7\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            jdbcOld.closeConnection();
        }
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/multipleitem"})
    public ResponseEntity<?> upgradeMultipleItem() {
        try {
            this.upgradeDatabase.upgradeMultipleItem();
            return ResponseEntity.ok((Object)HttpStatus.OK);
        }
        catch (Exception e) {
            throw new BusinessException("\u6570\u636e\u5e93\u5347\u7ea7\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/multipleitem/taxrate"})
    public ResponseEntity<?> upgradeMultipleItemTaxRate() {
        try {
            this.upgradeDatabase.upgradeMultipleItemTaxRate();
            return ResponseEntity.ok((Object)HttpStatus.OK);
        }
        catch (Exception e) {
            throw new BusinessException("\u6570\u636e\u5e93\u5347\u7ea7\u5931\u8d25\uff01", (Throwable)e);
        }
    }
}

