/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.constant.enums;

import java.util.Arrays;
import java.util.List;

public enum GoodsCategoryEnum {
    APP,
    SERVICE,
    COURSE,
    PACKAGE,
    PLATFORM,
    DEVICE,
    BUNDLE,
    PACK,
    API,
    RESOURCE;


    public static boolean isApp(String categoryId) {
        return APP.name().equalsIgnoreCase(categoryId) || PLATFORM.name().equalsIgnoreCase(categoryId) || BUNDLE.name().equalsIgnoreCase(categoryId) || API.name().equalsIgnoreCase(categoryId) || RESOURCE.name().equalsIgnoreCase(categoryId);
    }

    public static boolean isResource(String categoryId) {
        return RESOURCE.name().equalsIgnoreCase(categoryId);
    }

    public static boolean isPromotionPrice(String categoryId) {
        return Arrays.asList(SERVICE.name().toLowerCase(), PACKAGE.name().toLowerCase()).contains(categoryId);
    }

    public static List<String> apps() {
        return Arrays.asList(APP.name().toLowerCase(), PLATFORM.name().toLowerCase(), BUNDLE.name().toLowerCase());
    }

    public String id() {
        return this.name().toLowerCase();
    }
}

