/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.domain.remote;

import com.digiwin.dap.middleware.domain.Converter;
import com.digiwin.dap.middleware.gmc.domain.remote.OrderDetail;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import org.springframework.beans.BeanUtils;

public class OrderDetailV1
implements Converter<OrderDetail> {
    private Long id;
    private BigDecimal unitPrice;
    private Integer quantity;
    private String unit;
    private BigDecimal adjustmentTotal;
    private Long goodsId;
    private Long salesProgramId;
    private String goodsCode;
    private String goodsName;
    private String description;
    @JsonProperty(value="org_RTK")
    private String orgRtk;
    private String imageAddress;
    private String remark;

    public OrderDetailV1() {
    }

    public OrderDetailV1(OrderDetail orderDetail) {
        this.doBackward(orderDetail);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getAdjustmentTotal() {
        return this.adjustmentTotal;
    }

    public void setAdjustmentTotal(BigDecimal adjustmentTotal) {
        this.adjustmentTotal = adjustmentTotal;
    }

    public Long getGoodsId() {
        return this.goodsId;
    }

    public void setGoodsId(Long goodsId) {
        this.goodsId = goodsId;
    }

    public Long getSalesProgramId() {
        return this.salesProgramId;
    }

    public void setSalesProgramId(Long salesProgramId) {
        this.salesProgramId = salesProgramId;
    }

    public String getGoodsCode() {
        return this.goodsCode;
    }

    public void setGoodsCode(String goodsCode) {
        this.goodsCode = goodsCode;
    }

    public String getGoodsName() {
        return this.goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOrgRtk() {
        return this.orgRtk;
    }

    public void setOrgRtk(String orgRtk) {
        this.orgRtk = orgRtk;
    }

    public String getImageAddress() {
        return this.imageAddress;
    }

    public void setImageAddress(String imageAddress) {
        this.imageAddress = imageAddress;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public BigDecimal getTotalPrice() {
        BigDecimal de = null;
        if (this.quantity != null && this.unitPrice != null) {
            de = new BigDecimal(this.quantity);
            return de.multiply(this.unitPrice);
        }
        return de;
    }

    public OrderDetail doForward() {
        OrderDetail orderDetail = new OrderDetail();
        BeanUtils.copyProperties((Object)this, (Object)orderDetail);
        orderDetail.setSid(null == this.id ? 0L : this.id);
        orderDetail.setGoodsSid(this.goodsId);
        orderDetail.setStrategySid(this.salesProgramId);
        return orderDetail;
    }

    public void doBackward(OrderDetail orderDetail) {
        BeanUtils.copyProperties((Object)orderDetail, (Object)this);
        this.id = orderDetail.getSid();
        this.goodsId = orderDetail.getGoodsSid();
        this.salesProgramId = orderDetail.getStrategySid();
    }
}

