/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.entity.coupon;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.domain.coupon.CouponCategory;
import com.digiwin.dap.middleware.gmc.entity.coupon.CouponRule;
import com.digiwin.dap.middleware.gmc.entity.coupon.CouponType;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="coupon", uniqueConstraints={@UniqueConstraint(name="uk_coupon_couponnumber", columnNames={"couponNumber"})})
public class Coupon
extends BaseEntity {
    @Column(name="couponNumber", columnDefinition="VARCHAR(50) NULL DEFAULT NULL COMMENT '\u52b5\u7f16\u53f7'")
    private String couponNumber;
    @Column(name="couponTypeSid", columnDefinition="bigint(20) DEFAULT 0 COMMENT '\u52b5\u7c7b\u578bsid'")
    private Long couponTypeSid;
    @Column(name="couponTypeCode", columnDefinition="VARCHAR(50) NULL DEFAULT NULL COMMENT '\u52b5\u7c7b\u578b\u7f16\u7801'")
    private String couponTypeCode;
    @Column(name="couponTypeName", columnDefinition="VARCHAR(100) NULL DEFAULT NULL COMMENT '\u52b5\u7c7b\u578b\u540d\u79f0'")
    private String couponTypeName;
    @Column(name="category", columnDefinition="VARCHAR(50) NULL DEFAULT NULL COMMENT '\u52b5\u7c7b\u578b\u7c7b\u578b \u6298\u6263\u5377/\u73b0\u91d1\u5238'")
    @Enumerated(value=EnumType.STRING)
    private CouponCategory category;
    @Column(name="parValue", columnDefinition="INT(11) NULL DEFAULT NULL COMMENT '\u52b5\u9762\u503c'")
    private Integer parValue;
    @Column(name="availableCondition", columnDefinition="INT(11) NULL DEFAULT NULL COMMENT '\u52b5\u53ef\u4f7f\u7528\u6761\u4ef6 \u6ee1%s\u53ef\u7528'")
    private Integer availableCondition;
    @Column(name="discountRate", columnDefinition="INT(11) NULL DEFAULT NULL COMMENT '\u6298\u6263\u7387'")
    private Integer discountRate;
    @Column(name="limitDiscount", columnDefinition="INT(11) NULL DEFAULT NULL COMMENT '\u6298\u6263\u4e0a\u9650'")
    private Integer limitDiscount;
    @Column(name="couponRuleSid", columnDefinition="bigint(20) DEFAULT 0 COMMENT '\u52b5\u89c4\u5219sid'")
    private Long couponRuleSid;
    @Column(name="couponRuleCode", columnDefinition="VARCHAR(50) NULL DEFAULT NULL COMMENT '\u52b5\u89c4\u5219\u7f16\u7801'")
    private String couponRuleCode;
    @Column(name="couponRuleName", columnDefinition="VARCHAR(100) NULL DEFAULT NULL COMMENT '\u52b5\u89c4\u5219\u540d\u79f0'")
    private String couponRuleName;
    @Column(name="beginDate", columnDefinition="DATETIME NULL DEFAULT NULL COMMENT '\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4'")
    private LocalDateTime beginDate;
    @Column(name="endDate", columnDefinition="DATETIME NULL DEFAULT NULL COMMENT '\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4'")
    private LocalDateTime endDate;
    @Column(name="count", columnDefinition="INT(11) NULL DEFAULT NULL COMMENT '\u52b5\u6570\u91cf'")
    private Integer count;
    @Column(name="effectiveDate", columnDefinition="DATETIME NULL DEFAULT NULL COMMENT '\u751f\u6548\u65e5\u671f'")
    private LocalDateTime effectiveDate;
    @Column(name="expiredDate", columnDefinition="DATETIME NULL DEFAULT NULL COMMENT '\u8fc7\u671f\u65e5\u671f'")
    private LocalDateTime expiredDate;
    @Column(name="exclusiveSid", columnDefinition="bigint(20) DEFAULT 0 COMMENT '\u4e13\u5c5e\u4f18\u60e0sid'")
    private long exclusiveSid;

    public Coupon() {
    }

    public Coupon(CouponType couponType) {
        this.setCategory(couponType.getCategory());
        this.setAvailableCondition(couponType.getAvailableCondition());
        this.setLimitDiscount(couponType.getLimitDiscount());
        this.setParValue(couponType.getParValue());
        this.setDiscountRate(couponType.getDiscountRate());
    }

    public Coupon(CouponType couponType, CouponRule couponRule) {
        this.setCouponTypeSid(Long.valueOf(couponType.getSid()));
        this.setCouponTypeCode(couponType.getCode());
        this.setCouponTypeName(couponType.getName());
        this.setCategory(couponType.getCategory());
        this.setParValue(couponType.getParValue());
        this.setAvailableCondition(couponType.getAvailableCondition());
        this.setDiscountRate(couponType.getDiscountRate());
        this.setLimitDiscount(couponType.getLimitDiscount());
        this.setCouponRuleSid(Long.valueOf(couponRule.getSid()));
        this.setCouponRuleCode(couponRule.getCode());
        this.setCouponRuleName(couponRule.getName());
        this.setBeginDate(couponRule.getBeginDate());
        this.setEndDate(couponRule.getEndDate());
        this.setEffectiveDate(couponRule.getEffectiveDate());
        this.setExpiredDate(couponRule.getExpiredDate());
    }

    public String getCouponNumber() {
        return this.couponNumber;
    }

    public void setCouponNumber(String couponNumber) {
        this.couponNumber = couponNumber;
    }

    public Long getCouponTypeSid() {
        return this.couponTypeSid;
    }

    public void setCouponTypeSid(Long couponTypeSid) {
        this.couponTypeSid = couponTypeSid;
    }

    public String getCouponTypeCode() {
        return this.couponTypeCode;
    }

    public void setCouponTypeCode(String couponTypeCode) {
        this.couponTypeCode = couponTypeCode;
    }

    public String getCouponTypeName() {
        return this.couponTypeName;
    }

    public void setCouponTypeName(String couponTypeName) {
        this.couponTypeName = couponTypeName;
    }

    public CouponCategory getCategory() {
        return this.category;
    }

    public void setCategory(CouponCategory category) {
        this.category = category;
    }

    public Integer getParValue() {
        return this.parValue;
    }

    public void setParValue(Integer parValue) {
        this.parValue = parValue;
    }

    public Integer getAvailableCondition() {
        return this.availableCondition;
    }

    public void setAvailableCondition(Integer availableCondition) {
        this.availableCondition = availableCondition;
    }

    public Integer getDiscountRate() {
        return this.discountRate;
    }

    public void setDiscountRate(Integer discountRate) {
        this.discountRate = discountRate;
    }

    public Integer getLimitDiscount() {
        return this.limitDiscount;
    }

    public void setLimitDiscount(Integer limitDiscount) {
        this.limitDiscount = limitDiscount;
    }

    public Long getCouponRuleSid() {
        return this.couponRuleSid;
    }

    public void setCouponRuleSid(Long couponRuleSid) {
        this.couponRuleSid = couponRuleSid;
    }

    public String getCouponRuleCode() {
        return this.couponRuleCode;
    }

    public void setCouponRuleCode(String couponRuleCode) {
        this.couponRuleCode = couponRuleCode;
    }

    public String getCouponRuleName() {
        return this.couponRuleName;
    }

    public void setCouponRuleName(String couponRuleName) {
        this.couponRuleName = couponRuleName;
    }

    public LocalDateTime getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(LocalDateTime beginDate) {
        this.beginDate = beginDate;
    }

    public LocalDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDateTime endDate) {
        this.endDate = endDate;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public LocalDateTime getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(LocalDateTime effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public LocalDateTime getExpiredDate() {
        return this.expiredDate;
    }

    public void setExpiredDate(LocalDateTime expiredDate) {
        this.expiredDate = expiredDate;
    }

    public long getExclusiveSid() {
        return this.exclusiveSid;
    }

    public void setExclusiveSid(long exclusiveSid) {
        this.exclusiveSid = exclusiveSid;
    }
}

