/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.entity.customform;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.domain.customform.CustomFormContentVO;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="custom_form_content", uniqueConstraints={@UniqueConstraint(name="uk_customformcontent_customformsid_id", columnNames={"custom_form_sid", "id"})})
public class CustomFormContent
extends BaseEntity {
    @Column(name="custom_form_sid", columnDefinition="BIGINT(20) NOT NULL COMMENT '\u8868\u5355sid'")
    private Long customFormSid;
    @Column(name="id", columnDefinition="VARCHAR(50) NOT NULL COMMENT 'id'")
    private String id;
    @Column(name="title", columnDefinition="VARCHAR(200) NULL DEFAULT NULL COMMENT '\u540d\u79f0'")
    private String title;
    @Column(name="type", columnDefinition="INT(1) NULL DEFAULT '0' COMMENT '\u7c7b\u578b\uff080.\u6807\u9898 1.\u95ee\u9898\uff09'")
    private Integer type;
    @Column(name="default_value", columnDefinition="VARCHAR(512) NULL DEFAULT NULL COMMENT '\u9ed8\u8ba4\u503c'")
    private String defaultValue;
    @Column(name="value_type", columnDefinition="VARCHAR(40) NULL DEFAULT 'string' COMMENT '\u503c\u7c7b\u578b'")
    private String valueType;
    @Column(name="value_parameter", columnDefinition="MEDIUMTEXT NULL COMMENT '\u503c\u9009\u62e9\u53c2\u6570'")
    private String valueParameter;
    @Column(name="sort_number", columnDefinition="BIGINT(20) NULL DEFAULT '0' COMMENT '\u6392\u5e8f\u5e8f\u53f7'")
    private Long sortNumber;
    @Column(name="remark", columnDefinition="VARCHAR(500) NULL DEFAULT NULL COMMENT '\u95ee\u9898\u5907\u6ce8'")
    private String remark;
    @Column(name="mandatory", columnDefinition="BIT(1) NULL DEFAULT NULL COMMENT '\u662f\u5426\u5fc5\u586b'")
    private Boolean mandatory;
    private static ObjectMapper objectMapper = JsonUtils.createObjectMapper();

    public CustomFormContent() {
    }

    public CustomFormContent(CustomFormContentVO customFormContentVO, Long customFormSid) {
        this.customFormSid = customFormSid;
        this.id = SnowFlake.getInstance().newId() + "";
        this.title = customFormContentVO.getTitle();
        this.type = customFormContentVO.getType();
        this.defaultValue = customFormContentVO.getDefaultValue();
        this.valueType = customFormContentVO.getValueType();
        try {
            this.valueParameter = objectMapper.writeValueAsString((Object)customFormContentVO.getValueParameter());
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        this.sortNumber = customFormContentVO.getSortNumber();
        this.remark = customFormContentVO.getRemark();
        this.mandatory = customFormContentVO.getMandatory();
    }

    public Long getCustomFormSid() {
        return this.customFormSid;
    }

    public void setCustomFormSid(Long customFormSid) {
        this.customFormSid = customFormSid;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public String getValueParameter() {
        return this.valueParameter;
    }

    public void setValueParameter(String valueParameter) {
        this.valueParameter = valueParameter;
    }

    public Long getSortNumber() {
        return this.sortNumber;
    }

    public void setSortNumber(Long sortNumber) {
        this.sortNumber = sortNumber;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Boolean getMandatory() {
        return this.mandatory;
    }

    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }
}

