/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.entity.release;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.domain.excel.ReleaseHeadExcelVO;
import com.digiwin.dap.middleware.gmc.domain.release.ReleaseDescriptionVO;
import com.digiwin.dmc.sdk.config.ServerSetting;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

@Entity
@Table(name="release_description")
public class ReleaseDescription
extends BaseEntity {
    @Column(name="app_id")
    private String appId;
    @Column(name="version")
    private String version;
    @Column(name="important")
    private Boolean important;
    @Column(name="shelve")
    private Boolean shelve;
    @Column(name="url")
    private String url;
    @Column(name="file_name")
    private String fileName;
    @Column(name="shelve_time")
    private LocalDateTime shelveTime;
    @Column(name="off_shelve_time")
    private LocalDateTime offShelveTime;

    public ReleaseDescription() {
    }

    public ReleaseDescription(ReleaseHeadExcelVO head, String fileId) {
        BeanUtils.copyProperties((Object)head, (Object)this);
        this.url = String.format("%s/api/dmc/v2/file/digiwincloud/preview/%s", ServerSetting.getServiceUrl(), fileId);
        this.shelve = false;
        if (!StringUtils.isEmpty((Object)head.getImportant())) {
            String trim = head.getImportant().trim();
            this.important = "\u662f".equals(trim) || "y".compareToIgnoreCase(trim) == 0;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Boolean getImportant() {
        return this.important;
    }

    public void setImportant(Boolean important) {
        this.important = important;
    }

    public Boolean getShelve() {
        return this.shelve;
    }

    public void setShelve(Boolean shelve) {
        this.shelve = shelve;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public LocalDateTime getShelveTime() {
        return this.shelveTime;
    }

    public void setShelveTime(LocalDateTime shelveTime) {
        this.shelveTime = shelveTime;
    }

    public LocalDateTime getOffShelveTime() {
        return this.offShelveTime;
    }

    public void setOffShelveTime(LocalDateTime offShelveTime) {
        this.offShelveTime = offShelveTime;
    }

    public ReleaseDescriptionVO toVO() {
        ReleaseDescriptionVO result = new ReleaseDescriptionVO();
        BeanUtils.copyProperties((Object)this, (Object)result);
        return result;
    }
}

