/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.accessory.impl;

import com.digiwin.dap.middleware.domain.AbstractConverter;
import com.digiwin.dap.middleware.gmc.domain.accessory.AccessoryGoodsSaveVO;
import com.digiwin.dap.middleware.gmc.domain.accessory.AccessoryGoodsVO;
import com.digiwin.dap.middleware.gmc.mapper.AccessoryGoodsMapper;
import com.digiwin.dap.middleware.gmc.repository.AccessoryGoodsRepository;
import com.digiwin.dap.middleware.gmc.service.accessory.AccessoryGoodsCrudService;
import com.digiwin.dap.middleware.gmc.service.accessory.AccessoryService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccessoryServiceImpl
implements AccessoryService {
    @Autowired
    private AccessoryGoodsMapper accessoryGoodsMapper;
    @Autowired
    private AccessoryGoodsRepository accessoryGoodsRepository;
    @Autowired
    private AccessoryGoodsCrudService accessoryGoodsCrudService;

    public List<AccessoryGoodsVO> findList(AccessoryGoodsVO input) {
        return this.accessoryGoodsMapper.findListByStrategySid(input);
    }

    @Transactional
    public void save(AccessoryGoodsSaveVO input) {
        Long strategySid = input.getStrategySid();
        input.getAccessories().forEach(a -> a.setStrategySid(strategySid));
        List exist = this.accessoryGoodsRepository.findByStrategySidAndType(strategySid, input.getType());
        this.accessoryGoodsRepository.deleteAll((Iterable)exist);
        this.accessoryGoodsCrudService.saveAll((Iterable)input.getAccessories().stream().map(AbstractConverter::doForward).collect(Collectors.toList()));
    }
}

