/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.authoritysummary.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.Page;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.authoritysummary.AuthoritySummaryCondition;
import com.digiwin.dap.middleware.gmc.domain.authoritysummary.AuthoritySummaryVO;
import com.digiwin.dap.middleware.gmc.entity.AuthoritySummary;
import com.digiwin.dap.middleware.gmc.mapper.AuthoritySummaryMapper;
import com.digiwin.dap.middleware.gmc.service.authoritysummary.AuthoritySummaryCrudService;
import com.digiwin.dap.middleware.gmc.service.authoritysummary.AuthoritySummaryService;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageSerializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AuthoritySummaryServiceImpl
implements AuthoritySummaryService {
    @Autowired
    private AuthoritySummaryMapper authoritySummaryMapper;
    @Autowired
    private AuthoritySummaryCrudService authoritySummaryCrudService;

    @Transactional
    public void saveAuthoritySummary(String goodsCode, List<String> childGoodsCodeList) {
        List childList;
        AuthoritySummary parent = this.authoritySummaryCrudService.findParent(goodsCode);
        if (CollectionUtils.isEmpty(childGoodsCodeList)) {
            if (parent != null) {
                this.authoritySummaryCrudService.deleteById(parent.getSid());
            }
        } else if (parent == null) {
            parent = new AuthoritySummary();
            parent.setGoodsCode(goodsCode);
            parent.setLevel(Integer.valueOf(0));
            parent.setCreatorId(UserUtils.getUserId());
            parent.setModifierId(UserUtils.getUserId());
            this.authoritySummaryCrudService.create((BaseEntity)parent);
        } else {
            parent.setModifierId(UserUtils.getUserId());
            this.authoritySummaryCrudService.update((BaseEntity)parent);
        }
        if (!CollectionUtils.isEmpty((Collection)(childList = this.authoritySummaryCrudService.findChildren(goodsCode)))) {
            childList.stream().filter(e -> !childGoodsCodeList.contains(e.getGoodsCode())).forEach(e -> this.authoritySummaryCrudService.deleteById(e.getSid()));
        }
        if (!CollectionUtils.isEmpty(childGoodsCodeList)) {
            List childListGoodsCode = childList.stream().map(AuthoritySummary::getGoodsCode).collect(Collectors.toList());
            childGoodsCodeList.stream().filter(e -> !childListGoodsCode.contains(e)).forEach(e -> {
                AuthoritySummary child = new AuthoritySummary();
                child.setGoodsCode(e);
                child.setLevel(Integer.valueOf(1));
                child.setParentGoodsCode(goodsCode);
                child.setCreatorId(UserUtils.getUserId());
                child.setModifierId(UserUtils.getUserId());
                this.authoritySummaryCrudService.create((BaseEntity)child);
            });
        }
    }

    public void checkChildGoods(String goodsCode) {
        List list = this.authoritySummaryMapper.findListByChildGoodsCode(goodsCode);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            String mainGoodsInfo = String.join((CharSequence)",", (CharSequence[])list.stream().map(e -> String.format("%s(%s)", e.getParentGoodsName(), e.getParentGoodsCode())).toArray(String[]::new));
            throw new BusinessException((ErrorHandler)I18nError.CURRENT_GOODS_IS_OTHER_CHILD, new Object[]{mainGoodsInfo});
        }
    }

    public PageSerializable<AuthoritySummaryVO> searchMainGoodsByCondition(Page page, AuthoritySummaryCondition authoritySummaryCondition) {
        PageHelper.startPage((int)page.getPageNum(), (int)page.getPageSize());
        List list = this.authoritySummaryMapper.searchMainGoodsByCondition(authoritySummaryCondition);
        return PageSerializable.of((List)list);
    }

    public List<AuthoritySummaryVO> getChildGoodsInfo(String goodsCode) {
        return this.authoritySummaryMapper.findChildGoodsInfo(goodsCode);
    }
}

