/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.authorization.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.dealerauthorization.AuthorizationGoodsVO;
import com.digiwin.dap.middleware.gmc.entity.AuthorizationGoods;
import com.digiwin.dap.middleware.gmc.service.authorization.AuthorizationGoodsCrudService;
import com.digiwin.dap.middleware.gmc.service.authorization.AuthorizationGoodsService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthorizationGoodsServiceImpl
implements AuthorizationGoodsService {
    @Autowired
    private AuthorizationGoodsCrudService authorizationGoodsCrudService;

    public void save(List<AuthorizationGoodsVO> authorizationGoods, long authorizationSid) {
        authorizationGoods.forEach(authorizationGood -> {
            AuthorizationGoods authorizationGoodsDO = authorizationGood.generateAuthorizationGoodsDO();
            authorizationGoodsDO.setAuthorizationSid(Long.valueOf(authorizationSid));
            List existedGoodsVOs = authorizationGoods.stream().filter(goods -> goods.getGoodsSid().equals(authorizationGood.getGoodsSid())).collect(Collectors.toList());
            if (existedGoodsVOs.stream().count() > 1L) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u5546\u54c1%s\u9009\u62e9\u4e86\u591a\u4e2a\u9500\u552e\u65b9\u6848", authorizationGood.getGoodsSid()));
            }
            if (authorizationGood.getSid() == 0L) {
                if (this.authorizationGoodsCrudService.existsByUnionKey(new Object[]{authorizationSid, authorizationGood.getGoodsSid(), authorizationGood.getStrategySid()})) {
                    throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u7ecf\u9500\u5546\u54c1%s\u7684\u9500\u552e\u65b9\u6848%s\u5df2\u7ecf\u5b58\u5728", authorizationGood.getGoodsSid(), authorizationGood.getSid()));
                }
                this.authorizationGoodsCrudService.create((BaseEntity)authorizationGoodsDO);
            } else {
                this.authorizationGoodsCrudService.update((BaseEntity)authorizationGoodsDO);
            }
        });
    }

    public void deleteBySid(List<Long> sids) {
        if (sids != null) {
            sids.forEach(sid -> this.authorizationGoodsCrudService.deleteById(sid.longValue()));
        }
    }
}

