/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.authorization.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.domain.dealerauthorization.AuthorizationSearchParamVO;
import com.digiwin.dap.middleware.gmc.domain.dealerauthorization.AuthorizationVO;
import com.digiwin.dap.middleware.gmc.entity.Authorization;
import com.digiwin.dap.middleware.gmc.mapper.AuthorizationMapper;
import com.digiwin.dap.middleware.gmc.repository.AuthorizationGoodsRepository;
import com.digiwin.dap.middleware.gmc.service.authorization.AuthorizationCrudService;
import com.digiwin.dap.middleware.gmc.service.authorization.AuthorizationGoodsService;
import com.digiwin.dap.middleware.gmc.service.authorization.AuthorizationService;
import com.github.pagehelper.PageSerializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthorizationServiceImpl
implements AuthorizationService {
    @Autowired
    private AuthorizationCrudService authorizationCrudService;
    @Autowired
    private AuthorizationGoodsService authorizationGoodsService;
    @Autowired
    private AuthorizationMapper authorizationMapper;
    @Autowired
    private AuthorizationGoodsRepository authorizationGoodsRepository;

    public PageSerializable getAuthorizationList(AuthorizationSearchParamVO authorizationSearchParamVO, int pageNum, int pageSize, String orderBy) {
        List authorizationVOS = this.authorizationMapper.findAuthorizationVOs(authorizationSearchParamVO, pageNum, pageSize, orderBy);
        List sids = authorizationVOS.stream().map(AuthorizationVO::getSid).collect(Collectors.toList());
        if (sids != null && sids.size() > 0) {
            List authorizationGoodsVOS = this.authorizationMapper.findAuthorizationGoods(sids);
            authorizationVOS.forEach(authorizationVO -> authorizationGoodsVOS.forEach(authorizationGoodsVO -> {
                if (authorizationGoodsVO.getAuthorizationSid().equals(authorizationVO.getSid())) {
                    authorizationVO.getAuthorizationGoods().add(authorizationGoodsVO);
                }
            }));
        }
        PageSerializable pageSerializable = new PageSerializable(authorizationVOS);
        return pageSerializable;
    }

    public AuthorizationVO getAuthorizationInfo(long sid) {
        return this.authorizationMapper.findAuthorizationInfo(sid);
    }

    public long create(AuthorizationVO authorizationVO) {
        long authorizationSid = this.authorizationCrudService.create((BaseEntity)authorizationVO.generateAuthorization());
        List authorizationGoods = authorizationVO.getAuthorizationGoods();
        this.authorizationGoodsService.save(authorizationGoods, authorizationSid);
        return authorizationSid;
    }

    public void update(AuthorizationVO authorizationVO) {
        this.authorizationCrudService.update((BaseEntity)authorizationVO.generateAuthorization());
        this.authorizationGoodsService.deleteBySid(authorizationVO.getDeleteAuthorizationGoodsSid());
        this.authorizationGoodsService.save(authorizationVO.getAuthorizationGoods(), authorizationVO.getSid().longValue());
    }

    public void remove(long sid) {
        this.authorizationCrudService.deleteById(sid);
        this.authorizationGoodsRepository.deleteByAuthorizationSid(sid);
    }

    public Map<String, Integer> getAuthorizationRemainingCount(long sid) {
        Authorization authorization = (Authorization)this.authorizationCrudService.findBySid(sid);
        int remainingCount = 0;
        int openCount = 0;
        if (authorization != null) {
            remainingCount = authorization.getCount() - authorization.getAuthCount();
            openCount = authorization.getOpenCount();
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("remainingCount", remainingCount);
        map.put("openCount", openCount);
        return map;
    }
}

