/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.authorizationdata.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.dealerauthorization.GenerateAuthorizationDataVO;
import com.digiwin.dap.middleware.gmc.entity.Authorization;
import com.digiwin.dap.middleware.gmc.entity.AuthorizationData;
import com.digiwin.dap.middleware.gmc.service.authorization.AuthorizationCrudService;
import com.digiwin.dap.middleware.gmc.service.authorizationdata.AuthorizationDataCrudService;
import com.digiwin.dap.middleware.gmc.service.authorizationdata.AuthorizationDataService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.UUID;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthorizationDataServiceImpl
implements AuthorizationDataService {
    @Autowired
    private AuthorizationDataCrudService authorizationDataCrudService;
    @Autowired
    private AuthorizationCrudService authorizationCrudService;

    public void generateAuthorizationData(GenerateAuthorizationDataVO generateAuthorizationDataVO) {
        Authorization authorization = (Authorization)this.authorizationCrudService.findBySid(generateAuthorizationDataVO.getAuthorizationSid().longValue());
        if (authorization == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u6ca1\u6709\u6b64\u6388\u6743\u8d44\u6599[%s]", generateAuthorizationDataVO.getAuthorizationSid()));
        }
        int count = generateAuthorizationDataVO.getCount();
        if (count == 0) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u6388\u6743\u5957\u6570count\u4e0d\u80fd\u4e3a0");
        }
        int authCount = count + authorization.getAuthCount();
        if (authorization.getContractEndDate().isBefore(LocalDateTime.now()) || authorization.getCount() < authCount) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u5957\u6578\u5df2\u6388\u6b0a\u5b8c\u7562\u6216\u7d93\u92b7\u5408\u540c\u5df2\u5230\u671f");
        }
        if (generateAuthorizationDataVO.getBatch().booleanValue()) {
            AuthorizationData authorizationData = new AuthorizationData();
            BeanUtils.copyProperties((Object)generateAuthorizationDataVO, (Object)authorizationData);
            String code = String.valueOf(UUID.randomUUID());
            authorizationData.setCode(code);
            this.authorizationDataCrudService.create((BaseEntity)authorizationData);
        } else {
            ArrayList<AuthorizationData> authorizationDataList = new ArrayList<AuthorizationData>();
            for (int i = 0; i < count; ++i) {
                AuthorizationData authorizationData = new AuthorizationData();
                BeanUtils.copyProperties((Object)generateAuthorizationDataVO, (Object)authorizationData);
                authorizationData.setCount(Integer.valueOf(1));
                String code = String.valueOf(UUID.randomUUID());
                authorizationData.setCode(code);
                authorizationDataList.add(authorizationData);
            }
            this.authorizationDataCrudService.saveAll(authorizationDataList);
        }
        authorization.setAuthCount(Integer.valueOf(authCount));
        this.authorizationCrudService.update((BaseEntity)authorization);
    }

    public void abolishAuthorizationData(long sid) {
        AuthorizationData authorizationData = (AuthorizationData)this.authorizationDataCrudService.findBySid(sid);
        if (authorizationData == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u6ca1\u6709\u6b64\u6388\u6743\u7801[%s]", sid));
        }
        Authorization authorization = (Authorization)this.authorizationCrudService.findBySid(authorizationData.getAuthorizationSid());
        if (authorization == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u6388\u6743\u7801[%s]\u4e0d\u5b58\u5728\u6388\u6743\u8d44\u6599", sid));
        }
        authorizationData.setStatus(Integer.valueOf(2));
        this.authorizationDataCrudService.update((BaseEntity)authorizationData);
        int abolishAuthCount = authorizationData.getCount();
        if (abolishAuthCount > authorization.getAuthCount()) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u4f5c\u5e9f\u5957\u6570\u5927\u4e8e\u5df2\u6388\u6743\u5957\u6570");
        }
        int authCount = authorization.getAuthCount() - abolishAuthCount;
        authorization.setAuthCount(Integer.valueOf(authCount));
        this.authorizationCrudService.update((BaseEntity)authorization);
    }
}

