/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.bundle.impl;

import com.digiwin.dap.middleware.gmc.domain.bundle.BundleGoodsSaveVO;
import com.digiwin.dap.middleware.gmc.domain.bundle.BundleGoodsVO;
import com.digiwin.dap.middleware.gmc.entity.BundleRelation;
import com.digiwin.dap.middleware.gmc.mapper.BundleGoodsMapper;
import com.digiwin.dap.middleware.gmc.repository.BundleGoodsRepository;
import com.digiwin.dap.middleware.gmc.service.bundle.BundleGoodsCrudService;
import com.digiwin.dap.middleware.gmc.service.bundle.BundleService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BundleServiceImpl
implements BundleService {
    @Autowired
    private BundleGoodsRepository bundleGoodsRepository;
    @Autowired
    private BundleGoodsCrudService bundleGoodsCrudService;
    @Autowired
    private BundleGoodsMapper bundleGoodsMapper;

    public List<BundleGoodsVO> findList(BundleGoodsVO input) {
        return this.bundleGoodsMapper.findListByStrategySid(input);
    }

    public List<BundleGoodsVO> findListReverse(BundleGoodsVO input) {
        return this.bundleGoodsMapper.findListReverse(input);
    }

    @Transactional
    public void save(BundleGoodsSaveVO input) {
        Long strategySid = input.getStrategySid();
        List toAdd = input.getBundleStrategySids().stream().map(a -> {
            BundleRelation bundleRelation = new BundleRelation();
            bundleRelation.setStrategySid(strategySid);
            bundleRelation.setChildStrategySid(a);
            return bundleRelation;
        }).collect(Collectors.toList());
        List exist = this.bundleGoodsRepository.findByStrategySid(strategySid);
        this.bundleGoodsRepository.deleteAll((Iterable)exist);
        this.bundleGoodsCrudService.saveAll(toAdd);
    }
}

