/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.copy.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.GmcConstant;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.copy.GoodsCopyRequestVO;
import com.digiwin.dap.middleware.gmc.domain.copy.GoodsCopyVO;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsVO;
import com.digiwin.dap.middleware.gmc.domain.goodsalias.GoodsAliasDTO;
import com.digiwin.dap.middleware.gmc.domain.multilanguage.MultiLanguageResourceCopyVO;
import com.digiwin.dap.middleware.gmc.domain.sellingstrategy.SellingStrategyVO;
import com.digiwin.dap.middleware.gmc.entity.Goods;
import com.digiwin.dap.middleware.gmc.entity.GoodsAlias;
import com.digiwin.dap.middleware.gmc.entity.MultiLanguageResource;
import com.digiwin.dap.middleware.gmc.mapper.GoodsOnPlatformMapper;
import com.digiwin.dap.middleware.gmc.repository.GoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.MultiLanguageResourceRepository;
import com.digiwin.dap.middleware.gmc.repository.SellingStrategyRepository;
import com.digiwin.dap.middleware.gmc.service.copy.GoodsCopyService;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsCrudService;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsMappingService;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsOnPlatformService;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsService;
import com.digiwin.dap.middleware.gmc.service.goods.SellingStrategyService;
import com.digiwin.dap.middleware.gmc.service.goodsalias.GoodsAliasCrudService;
import com.digiwin.dap.middleware.gmc.service.multilanguageresource.MultiLanguageResourceCrudService;
import com.digiwin.dap.middleware.gmc.support.aspect.FieldValue;
import com.digiwin.dap.middleware.gmc.support.remote.IamService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class GoodsCopyServiceImpl
implements GoodsCopyService {
    @Resource
    private GoodsService goodsService;
    @Resource
    private GoodsAliasCrudService goodsAliasCrudService;
    @Resource
    private MultiLanguageResourceRepository multiLanguageResourceRepository;
    @Resource
    private MultiLanguageResourceCrudService multiLanguageResourceCrudService;
    @Resource
    private GoodsOnPlatformMapper goodsOnPlatformMapper;
    @Resource
    private GoodsRepository goodsRepository;
    @Resource
    private GoodsCrudService goodsCrudService;
    @Resource
    private SellingStrategyRepository sellingStrategyRepository;
    @Resource
    private SellingStrategyService sellingStrategyService;
    @Resource
    private GoodsOnPlatformService goodsOnPlatformService;
    @Resource
    private GoodsMappingService goodsMappingService;
    @Resource
    private IamService iamService;

    public GoodsCopyVO exportGoods(GoodsCopyRequestVO request) {
        String goodsCode = request.getGoodsCode();
        GoodsCopyVO result = new GoodsCopyVO();
        GoodsVO goodsVO = this.goodsService.getGoodsDetailByCode(goodsCode, true, UserUtils.getAuthoredUser());
        if (goodsVO == null || GmcConstant.GoodsStatus.OnSale.ordinal() != goodsVO.getOnSale().intValue() || !this.hasPermission(request, goodsVO)) {
            return result;
        }
        result.setGoods(goodsVO);
        result.setAlias(this.getGoodAlias(goodsCode));
        result.setMultiLanguages(this.multiLanguageResourceRepository.findByDataSid(goodsVO.getId()).stream().map(MultiLanguageResourceCopyVO::new).collect(Collectors.toList()));
        result.setStrategyMultiLanguages(this.getSellingStrategyMultiLanguage(goodsVO));
        result.setPlatforms(this.goodsOnPlatformMapper.getPlatformCodeByGoodsCode(goodsCode));
        result.setMappings(this.goodsMappingService.getMappings(request.getGoodsCode()));
        result.setSysNotice(this.iamService.getSysNotice(goodsCode));
        return result;
    }

    private boolean hasPermission(GoodsCopyRequestVO request, GoodsVO goodsVO) {
        String productCode = goodsVO.getProductCode();
        Map rowPermission = this.iamService.getRowPermission(UserUtils.getToken(), request.getUserId());
        if (rowPermission == null) {
            return false;
        }
        boolean superadmin = Boolean.valueOf(rowPermission.get("superadmin").toString());
        if (superadmin) {
            return true;
        }
        Map rowMap = (Map)rowPermission.get("rowPermission");
        if (rowMap.isEmpty()) {
            return false;
        }
        FieldValue fieldValue = new FieldValue((Map)rowPermission.get("rowPermission"));
        List productCodes = this.resolveProductCodes(fieldValue);
        return productCodes.contains(productCode);
    }

    private List<String> resolveProductCodes(FieldValue fieldValue) {
        ArrayList<String> result = new ArrayList<String>();
        if (FieldValue.OPERATOR.contains(fieldValue.getFilterType())) {
            for (Object o : (List)fieldValue.getFilterValue()) {
                result.addAll(this.resolveProductCodes(new FieldValue((Map)o)));
            }
            if (!result.isEmpty()) {
                return result;
            }
        } else if ("productCode".equals(fieldValue.getFilterField()) && fieldValue.getFilterValue() instanceof List) {
            return (List)fieldValue.getFilterValue();
        }
        return result;
    }

    private List<GoodsAliasDTO> getGoodAlias(String goodsCode) {
        GoodsAliasDTO goodsAliasDTO = new GoodsAliasDTO();
        goodsAliasDTO.setGoodsCode(goodsCode);
        List aliasList = this.goodsAliasCrudService.findGoodsAliasList(goodsAliasDTO);
        return aliasList.stream().map(GoodsAliasDTO::new).collect(Collectors.toList());
    }

    private List<MultiLanguageResourceCopyVO> getSellingStrategyMultiLanguage(GoodsVO goodsVO) {
        List sellingStrategies = goodsVO.getSellingStrategys();
        ArrayList<MultiLanguageResourceCopyVO> sellingStrategyML = new ArrayList<MultiLanguageResourceCopyVO>();
        if (!CollectionUtils.isEmpty((Collection)sellingStrategies)) {
            for (SellingStrategyVO sellingStrategy : sellingStrategies) {
                sellingStrategyML.addAll(this.multiLanguageResourceRepository.findByDataSid(sellingStrategy.getId()).stream().map(MultiLanguageResourceCopyVO::new).collect(Collectors.toList()));
            }
        }
        return sellingStrategyML;
    }

    @Transactional(rollbackFor={Exception.class})
    public void importGoods(GoodsCopyVO request) {
        GoodsVO goodsVO = request.getGoods();
        if (this.goodsRepository.existsByCode(goodsVO.getCode())) {
            throw new BusinessException((ErrorHandler)I18nError.GOODS_ID_EXIST);
        }
        Goods goods = goodsVO.generateGoods(true);
        goods.setSid(0L);
        long sid = this.goodsCrudService.create((BaseEntity)goods);
        this.saveMultiLanguage(request.getMultiLanguages(), sid);
        List sellingStrategys = goodsVO.getSellingStrategys();
        for (SellingStrategyVO sellingStrategy : sellingStrategys) {
            if (this.sellingStrategyRepository.existsByCode(sellingStrategy.getCode())) {
                throw new BusinessException((ErrorHandler)I18nError.STRATEGY_ID_EXIST);
            }
            sellingStrategy.getMultipleItems().forEach(a -> a.setSid(Long.valueOf(0L)));
            sellingStrategy.setId(Long.valueOf(0L));
            long strategySid = this.sellingStrategyService.create(sellingStrategy);
            this.saveMultiLanguage(request.getStrategyMultiLanguages().stream().filter(a -> a.getDataSid() == sellingStrategy.getId().longValue()).collect(Collectors.toList()), strategySid);
        }
        this.goodsAliasCrudService.saveAll((Iterable)request.getAlias().stream().map(GoodsAlias::new).collect(Collectors.toList()));
        this.goodsOnPlatformService.save(goodsVO.getCode(), request.getPlatforms());
        List mappings = request.getMappings();
        mappings.forEach(a -> this.goodsMappingService.saveGoodsMappings(goodsVO.getCode(), a.getPlatform(), a.getDatas()));
    }

    private void saveMultiLanguage(List<MultiLanguageResourceCopyVO> multiLanguageVOS, long dataSid) {
        if (CollectionUtils.isEmpty(multiLanguageVOS)) {
            return;
        }
        List<MultiLanguageResource> multiLanguages = multiLanguageVOS.stream().map(MultiLanguageResource::new).collect(Collectors.toList());
        multiLanguages.forEach(a -> a.setDataSid(dataSid));
        this.multiLanguageResourceCrudService.saveAll(multiLanguages);
    }
}

