/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.coupon.impl;

import com.digiwin.dap.middleware.gmc.domain.coupon.CouponInfoVO;
import com.digiwin.dap.middleware.gmc.domain.coupon.UseStatus;
import com.digiwin.dap.middleware.gmc.entity.coupon.CouponExclusive;
import com.digiwin.dap.middleware.gmc.mapper.CouponMapper;
import com.digiwin.dap.middleware.gmc.repository.CouponExclusiveRepository;
import com.digiwin.dap.middleware.gmc.repository.CouponRepository;
import com.digiwin.dap.middleware.gmc.repository.MyCouponRepository;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponExclusiveCrudService;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CouponExclusiveCrudServiceImpl
extends BaseEntityManagerService<CouponExclusive>
implements CouponExclusiveCrudService {
    @Autowired
    private CouponExclusiveRepository couponExclusiveRepository;
    @Autowired
    private CouponMapper couponMapper;
    @Autowired
    private CouponRepository couponRepository;
    @Autowired
    private MyCouponRepository myCouponRepository;

    protected JpaRepository getRepository() {
        return this.couponExclusiveRepository;
    }

    public void deleteExclusiveCoupon(long exclusiveSid) {
        CouponExclusive couponExclusive = (CouponExclusive)this.findBySid(exclusiveSid);
        List couponInfoVOS = this.couponMapper.queryCouponByExclusiceSid(exclusiveSid);
        long usedCount = couponInfoVOS.stream().filter(c -> UseStatus.USED.equals((Object)c.getUseStatus())).count();
        if (StringUtils.isEmpty((Object)couponExclusive.getEmailTime()) || usedCount <= 0L) {
            this.deleteById(exclusiveSid);
            this.couponRepository.deleteByExclusiveSid(exclusiveSid);
            List couponSids = couponInfoVOS.stream().map(CouponInfoVO::getSid).collect(Collectors.toList());
            this.myCouponRepository.deleteByCouponSidIn(couponSids);
        }
    }
}

