/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.coupon.impl;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.coupon.CouponExclusiveEmailVO;
import com.digiwin.dap.middleware.gmc.domain.coupon.CouponExclusiveVO;
import com.digiwin.dap.middleware.gmc.domain.coupon.UseStatus;
import com.digiwin.dap.middleware.gmc.entity.coupon.Coupon;
import com.digiwin.dap.middleware.gmc.entity.coupon.CouponExclusive;
import com.digiwin.dap.middleware.gmc.entity.coupon.CouponRule;
import com.digiwin.dap.middleware.gmc.entity.coupon.CouponType;
import com.digiwin.dap.middleware.gmc.entity.coupon.MyCoupon;
import com.digiwin.dap.middleware.gmc.repository.CouponRepository;
import com.digiwin.dap.middleware.gmc.repository.CouponRuleSuitableGoodsRepository;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponCrudService;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponExclusiveCrudService;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponExclusiveService;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponTypeCrudService;
import com.digiwin.dap.middleware.gmc.service.coupon.MyCouponCrudService;
import com.digiwin.dap.middleware.gmc.support.cache.RedisCache;
import com.digiwin.dap.middleware.gmc.support.stream.PutawayMessageService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponExclusiveServiceImpl
implements CouponExclusiveService {
    @Autowired
    private CouponExclusiveCrudService couponExclusiveCrudService;
    @Autowired
    private CouponTypeCrudService couponTypeCrudService;
    @Autowired
    private CouponCrudService couponCrudService;
    @Autowired
    private CouponRepository couponRepository;
    @Autowired
    private MyCouponCrudService myCouponCrudService;
    @Autowired
    private CouponRuleSuitableGoodsRepository couponRuleSuitableGoodsRepository;
    @Autowired
    private PutawayMessageService messageService;
    @Autowired
    private RedisCache redisCache;
    public static final String FORMAT_YYYY_MM_DD = "yyyyMMdd";

    public void create(List<CouponExclusiveVO> couponExclusiveVOS, CouponRule couponRule) {
        int sum = couponExclusiveVOS.stream().map(CouponExclusiveVO::getCount).mapToInt(count -> count).sum();
        if (sum > couponRule.getCount()) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u8d85\u51fa\u52b5\u603b\u6570\u91cf\uff01");
        }
        couponExclusiveVOS.forEach(couponExclusiveVO -> {
            if (couponExclusiveVO.getSid() != 0L) {
                return;
            }
            couponExclusiveVO.setCouponRuleSid(Long.valueOf(couponRule.getSid()));
            long exclusiveSid = this.couponExclusiveCrudService.create((BaseEntity)couponExclusiveVO.generateCouponExclusive());
            CouponType couponType = (CouponType)this.couponTypeCrudService.findBySid(couponRule.getCouponTypeSid().longValue());
            Coupon coupon = new Coupon(couponType, couponRule);
            coupon.setExclusiveSid(exclusiveSid);
            couponExclusiveVO.getCoupons().forEach(couponInfoVO -> {
                coupon.setCouponNumber(couponRule.getCode() + "-" + this.getCouponNum());
                coupon.setSid(couponInfoVO.getSid().longValue());
                coupon.setEffectiveDate(couponInfoVO.getEffectiveDate());
                coupon.setExpiredDate(couponInfoVO.getExpiredDate());
                long couponSid = this.couponCrudService.create((BaseEntity)coupon);
                MyCoupon myCoupon = new MyCoupon();
                myCoupon.setTenantSid(couponExclusiveVO.getTenantSid());
                myCoupon.setUserSid(couponExclusiveVO.getUserSid());
                myCoupon.setCouponRuleSid(Long.valueOf(couponRule.getSid()));
                myCoupon.setCouponSid(Long.valueOf(couponSid));
                myCoupon.setUseStatus(UseStatus.UNUSED);
                myCoupon.setUsedDate(null);
                this.myCouponCrudService.create((BaseEntity)myCoupon);
            });
        });
    }

    public Map<String, String> sendExclusiveCouponEmail(long sid, AuthoredUser authoredUser) {
        List coupons = this.couponRepository.findByExclusiveSid(sid);
        if (coupons.size() > 0) {
            Coupon coupon = (Coupon)coupons.get(0);
            CouponExclusiveEmailVO couponExclusiveEmailVO = new CouponExclusiveEmailVO(coupon);
            couponExclusiveEmailVO.setName(coupon.getCouponRuleName());
            CouponExclusive couponExclusive = (CouponExclusive)this.couponExclusiveCrudService.findBySid(sid);
            BeanUtils.copyProperties((Object)couponExclusive, (Object)couponExclusiveEmailVO);
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            couponExclusiveEmailVO.setEffectiveDate(df.format(couponExclusive.getEffectiveDate()));
            couponExclusiveEmailVO.setExpiredDate(df.format(couponExclusive.getExpiredDate()));
            StringBuffer stringBuffer = new StringBuffer();
            List suitableGoods = this.couponRuleSuitableGoodsRepository.findByCouponRuleSid(couponExclusive.getCouponRuleSid().longValue());
            suitableGoods.forEach(couponRuleSuitableGoods -> stringBuffer.append(couponRuleSuitableGoods.getGoodsName() + "/"));
            couponExclusiveEmailVO.setSuitableGoods(stringBuffer.toString().substring(0, stringBuffer.toString().length() - 1));
            try {
                this.messageService.send(couponExclusiveEmailVO);
                couponExclusive.setEmailTime(LocalDateTime.now());
                couponExclusive.setSendUserId(authoredUser.getUserId());
                couponExclusive.setSendUserName(authoredUser.getUserName());
                this.couponExclusiveCrudService.update((BaseEntity)couponExclusive);
                HashMap<String, String> emailMap = new HashMap<String, String>();
                df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                emailMap.put("emailTime", df.format(couponExclusive.getEmailTime()));
                emailMap.put("sendUserId", authoredUser.getUserId());
                emailMap.put("sendUserName", authoredUser.getUserName());
                return emailMap;
            }
            catch (Exception e) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u90ae\u4ef6\u53d1\u9001\u5f02\u5e38" + e.getMessage());
            }
        }
        return new HashMap<String, String>();
    }

    private String getCouponNum() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(FORMAT_YYYY_MM_DD);
        String dateStr = dtf.format(now);
        StringBuilder sb = new StringBuilder();
        sb.append(dateStr);
        long sequence = this.redisCache.increment(sb.toString(), 1L);
        sb.append(String.format("%06d", sequence));
        return sb.toString();
    }
}

