/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.coupon.impl;

import com.digiwin.dap.middleware.gmc.domain.coupon.GoodsCanUseCouponVO;
import com.digiwin.dap.middleware.gmc.domain.coupon.UseStatus;
import com.digiwin.dap.middleware.gmc.mapper.CouponRuleMapper;
import com.digiwin.dap.middleware.gmc.mapper.CouponRuleSuitableGoodsMapper;
import com.digiwin.dap.middleware.gmc.repository.CouponRepository;
import com.digiwin.dap.middleware.gmc.repository.CouponRuleSuitableGoodsRepository;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponQueryService;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponRuleCrudService;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponTypeCrudService;
import com.digiwin.dap.middleware.gmc.service.coupon.MyCouponCrudService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CouponQueryServiceImpl
implements CouponQueryService {
    @Autowired
    private CouponRuleSuitableGoodsMapper couponRuleSuitableGoodsMapper;
    @Autowired
    private CouponRuleCrudService couponRuleCrudService;
    @Autowired
    private CouponTypeCrudService couponTypeCrudService;
    @Autowired
    CouponRuleSuitableGoodsRepository couponRuleSuitableGoodsRepository;
    @Autowired
    private MyCouponCrudService myCouponCrudService;
    @Autowired
    private CouponRuleMapper couponRuleMapper;
    @Autowired
    private CouponRepository couponRepository;

    public List<GoodsCanUseCouponVO> getGoodsCanUseCoupon(long tenantSid, long userSid, String categoryId, String goodsCode) {
        List<GoodsCanUseCouponVO> goodsCanUseCouponVOS = new ArrayList();
        if (tenantSid == 0L || userSid == 0L) {
            goodsCanUseCouponVOS = this.couponRuleSuitableGoodsMapper.getGoodsCanUseCoupon(goodsCode, categoryId);
        } else {
            goodsCanUseCouponVOS = this.couponRuleSuitableGoodsMapper.getUserHaveGoodsCanUseCoupon(tenantSid, userSid, goodsCode, categoryId);
            List ExclusiveCoupons = this.couponRuleSuitableGoodsMapper.getUserCanUseExclusiveCoupon(tenantSid, userSid, goodsCode, categoryId);
            goodsCanUseCouponVOS.addAll(ExclusiveCoupons);
        }
        for (GoodsCanUseCouponVO goodsCanUseCouponVO : goodsCanUseCouponVOS) {
            if (StringUtils.isEmpty((Object)goodsCanUseCouponVO.getUsestatus())) {
                goodsCanUseCouponVO.setHold(Boolean.valueOf(false));
                goodsCanUseCouponVO.setUsed(Boolean.valueOf(false));
            } else {
                goodsCanUseCouponVO.setHold(Boolean.valueOf(true));
                if (UseStatus.USED.name().equals(goodsCanUseCouponVO.getUsestatus())) {
                    goodsCanUseCouponVO.setUsed(Boolean.valueOf(true));
                } else {
                    goodsCanUseCouponVO.setUsed(Boolean.valueOf(false));
                }
            }
            if (goodsCanUseCouponVO.getExclusiveSid() != null) {
                goodsCanUseCouponVO.setExclusive(Boolean.valueOf(true));
            }
            List ruleSuitableGoods = this.couponRuleSuitableGoodsRepository.findByCouponRuleSid(goodsCanUseCouponVO.getCouponRuleSid().longValue());
            int count = this.couponRepository.getCouponCount(goodsCanUseCouponVO.getCouponRuleSid().longValue());
            if (count < goodsCanUseCouponVO.getCount()) {
                goodsCanUseCouponVO.setUpperLimit(Boolean.valueOf(false));
            } else {
                goodsCanUseCouponVO.setUpperLimit(Boolean.valueOf(true));
            }
            goodsCanUseCouponVO.setSuitableGoods(ruleSuitableGoods);
        }
        return goodsCanUseCouponVOS;
    }
}

