/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.coupon.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.coupon.CouponRuleType;
import com.digiwin.dap.middleware.gmc.domain.coupon.CouponRuleVO;
import com.digiwin.dap.middleware.gmc.domain.coupon.CouponSearchParamVO;
import com.digiwin.dap.middleware.gmc.entity.coupon.CouponRule;
import com.digiwin.dap.middleware.gmc.mapper.CouponExclusiveMapper;
import com.digiwin.dap.middleware.gmc.mapper.CouponMapper;
import com.digiwin.dap.middleware.gmc.mapper.CouponRuleMapper;
import com.digiwin.dap.middleware.gmc.repository.CouponRepository;
import com.digiwin.dap.middleware.gmc.repository.CouponRuleSuitableGoodsRepository;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponExclusiveService;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponRuleCrudService;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponRuleService;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponRuleSuitableGoodsService;
import com.github.pagehelper.PageSerializable;
import java.util.List;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponRuleImpl
implements CouponRuleService {
    @Autowired
    private CouponRuleMapper couponRuleMapper;
    @Autowired
    private CouponRuleCrudService couponRuleCrudService;
    @Autowired
    private CouponRuleSuitableGoodsService couponRuleSuitableGoodsService;
    @Autowired
    private CouponRuleSuitableGoodsRepository couponRuleSuitableGoodsRepository;
    @Autowired
    private CouponExclusiveService couponExclusiveService;
    @Autowired
    private CouponExclusiveMapper couponExclusiveMapper;
    @Autowired
    private CouponRepository couponRepository;
    @Autowired
    private CouponMapper couponMapper;

    public PageSerializable getCouponRuleList(CouponSearchParamVO couponSearchParamVO, int pageNum, int pageSize, String orderBy) {
        List couponRules = this.couponRuleMapper.findCouponRules(couponSearchParamVO, pageNum, pageSize, orderBy);
        couponRules.forEach(couponRuleVO -> {
            List couponRuleSuitableGoods = this.couponRuleSuitableGoodsRepository.findByCouponRuleSid(couponRuleVO.getSid());
            couponRuleVO.setSuitableGoods(couponRuleSuitableGoods);
        });
        return new PageSerializable(couponRules);
    }

    public CouponRuleVO getCouponRuleInfo(long sid) {
        CouponRuleVO couponRuleVO = this.couponRuleMapper.findCouponRuleInfo(sid);
        if (couponRuleVO != null) {
            List couponRuleSuitableGoods = this.couponRuleSuitableGoodsRepository.findByCouponRuleSid(couponRuleVO.getSid());
            couponRuleVO.setSuitableGoods(couponRuleSuitableGoods);
            List couponExclusiveVOS = this.couponExclusiveMapper.selectCouponExclusiveByRuleId(sid);
            couponExclusiveVOS.forEach(couponExclusiveVO -> {
                List couponInfoVOS = this.couponMapper.queryCouponByExclusiceSid(couponExclusiveVO.getSid());
                couponExclusiveVO.setCoupons(couponInfoVOS);
            });
            couponRuleVO.setExclusiveCoupons(couponExclusiveVOS);
        }
        return couponRuleVO;
    }

    public void create(CouponRuleVO couponRuleVO) {
        CouponRule couponRule = couponRuleVO.generateCouponRule();
        long couponRuleSid = this.couponRuleCrudService.create((BaseEntity)couponRule);
        List couponRuleSuitableGoods = couponRuleVO.getSuitableGoods();
        this.couponRuleSuitableGoodsService.save(couponRuleSuitableGoods, couponRuleSid);
        if (CouponRuleType.EXCLUSIVE.equals((Object)couponRuleVO.getCouponRuleType())) {
            couponRule.setSid(couponRuleSid);
            this.couponExclusiveService.create(couponRuleVO.getExclusiveCoupons(), couponRule);
        }
    }

    public void update(CouponRuleVO couponRuleVO) {
        CouponRule couponRule = couponRuleVO.generateCouponRule();
        this.couponRuleCrudService.update((BaseEntity)couponRule, true);
        this.couponRuleSuitableGoodsService.deleteBySid(couponRuleVO.getDeletedSuitableGoodsSid());
        this.couponRuleSuitableGoodsRepository.flush();
        this.couponRuleSuitableGoodsService.save(couponRuleVO.getSuitableGoods(), couponRuleVO.getSid());
        if (CouponRuleType.EXCLUSIVE.equals((Object)couponRuleVO.getCouponRuleType())) {
            this.couponExclusiveService.create(couponRuleVO.getExclusiveCoupons(), couponRule);
        }
    }

    public void remove(long sid) {
        int couponCount;
        CouponRule couponRule = (CouponRule)this.couponRuleCrudService.findBySid(sid);
        if (couponRule == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u6ca1\u6709\u6b64\u5238\u89c4\u5219[%s]", sid));
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (couponRule.getStatus().booleanValue()) {
            stringBuilder.append(String.format("\u5238\u89c4\u5219[%s]\u4e3a\u5f00\u542f\u72b6\u6001,", sid));
        }
        if ((couponCount = this.couponRepository.getCouponCount(sid)) > 0) {
            stringBuilder.append(String.format("\u6b64\u5238\u89c4\u5219[%s]\u5df2\u88ab\u9886\u53d6\u8fc7,", sid));
        }
        if (!Strings.isBlank((String)stringBuilder.toString())) {
            stringBuilder.append("\u4e0d\u53ef\u5220\u9664\uff01");
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, stringBuilder.toString());
        }
        this.couponRuleCrudService.deleteById(sid);
    }
}

