/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.coupon.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.coupon.CouponSearchParamVO;
import com.digiwin.dap.middleware.gmc.entity.coupon.CouponType;
import com.digiwin.dap.middleware.gmc.mapper.CouponTypeMapper;
import com.digiwin.dap.middleware.gmc.repository.CouponRuleRepository;
import com.digiwin.dap.middleware.gmc.repository.CouponTypeRepository;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponTypeCrudService;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponTypeService;
import com.digiwin.dap.middleware.gmc.support.cache.RedisCache;
import com.github.pagehelper.PageSerializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CouponTypeImpl
implements CouponTypeService {
    @Autowired
    private CouponTypeMapper couponTypeMapper;
    @Autowired
    private CouponTypeRepository couponTypeRepository;
    @Autowired
    private CouponTypeCrudService couponTypeCrudService;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private CouponRuleRepository couponRuleRepository;

    public PageSerializable getCouponTypeList(CouponSearchParamVO couponSearchParamVO, int pageNum, int pageSize, String orderBy) {
        List couponTypes = this.couponTypeMapper.findCouponTypes(couponSearchParamVO, pageNum, pageSize, orderBy);
        return new PageSerializable(couponTypes);
    }

    public void updateCouponTypeStatus(long couponTypeSid, Boolean status) {
        this.couponTypeRepository.updateCouponTypeStatus(couponTypeSid, status);
    }

    public void save(CouponType couponType) {
        if (StringUtils.isEmpty((Object)couponType.getSid()) || couponType.getSid() == 0L) {
            couponType.setSid(this.getCouponTypeSid());
            this.couponTypeCrudService.create((BaseEntity)couponType);
        } else {
            this.couponTypeCrudService.update((BaseEntity)couponType, true);
        }
    }

    public void remove(long sid) {
        int couponRuleCount;
        CouponType couponType = (CouponType)this.couponTypeCrudService.findBySid(sid);
        if (couponType == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u6ca1\u6709\u6b64\u5238\u7c7b\u578b[%s]", sid));
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (couponType.getStatus().booleanValue()) {
            stringBuilder.append(String.format("\u5238\u7c7b\u578b[%s]\u4e3a\u5f00\u542f\u72b6\u6001,", sid));
        }
        if ((couponRuleCount = this.couponRuleRepository.countCouponRuleByCouponTypeSid(sid)) > 0) {
            stringBuilder.append(String.format("\u5238\u7c7b\u578b[%s]\u5b58\u5728\u5238\u89c4\u5219,", sid));
        }
        if (!Strings.isBlank((String)stringBuilder.toString())) {
            stringBuilder.append("\u4e0d\u53ef\u5220\u9664\uff01");
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, stringBuilder.toString());
        }
        this.couponTypeCrudService.deleteById(sid);
    }

    private long getCouponTypeSid() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
        String dateStr = dtf.format(now);
        StringBuilder sb = new StringBuilder();
        sb.append(dateStr);
        long sequence = this.redisCache.increment(sb.toString(), 1L);
        sb.append(String.format("%06d", sequence));
        return Long.parseLong(sb.toString());
    }
}

