/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.coupon.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.coupon.PromotionMixConditionVO;
import com.digiwin.dap.middleware.gmc.domain.coupon.PromotionMixGoodsVO;
import com.digiwin.dap.middleware.gmc.domain.coupon.PromotionMixVO;
import com.digiwin.dap.middleware.gmc.entity.PromotionMix;
import com.digiwin.dap.middleware.gmc.entity.PromotionMixGoods;
import com.digiwin.dap.middleware.gmc.mapper.PromotionMixGoodsMapper;
import com.digiwin.dap.middleware.gmc.mapper.PromotionMixMapper;
import com.digiwin.dap.middleware.gmc.repository.PromotionMixGoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.PromotionMixRepository;
import com.digiwin.dap.middleware.gmc.service.coupon.PromotionMixGoodsCrudService;
import com.digiwin.dap.middleware.gmc.service.coupon.PromotionMixService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.github.pagehelper.PageSerializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PromotionMixServiceImpl
implements PromotionMixService {
    @Autowired
    private PromotionMixRepository promotionMixRepository;
    @Autowired
    private PromotionMixGoodsRepository promotionMixGoodsRepository;
    @Autowired
    private PromotionMixGoodsMapper promotionMixGoodsMapper;
    @Autowired
    private PromotionMixMapper promotionMixMapper;
    @Autowired
    private PromotionMixGoodsCrudService promotionMixGoodsCrudService;

    public long save(PromotionMixVO promotionVO) {
        if (this.promotionMixRepository.existsById(promotionVO.getId())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u4fc3\u9500\u7ec4\u5408%s\u5df2\u7ecf\u5b58\u5728", promotionVO.getId()));
        }
        PromotionMix promotionMix = new PromotionMix();
        promotionVO.generateDO(promotionMix);
        EntityUtils.setCreateFields((BaseEntity)promotionMix);
        promotionMix = (PromotionMix)this.promotionMixRepository.save((Object)promotionMix);
        ArrayList<PromotionMixGoods> promotionMixGoods = new ArrayList<PromotionMixGoods>();
        for (PromotionMixGoodsVO goodsVO : promotionVO.getGoods()) {
            PromotionMixGoods goods = goodsVO.generateDO();
            goods.setPromotionMixSid(promotionMix.getSid());
            EntityUtils.setCreateFields((BaseEntity)goods);
            promotionMixGoods.add(goods);
        }
        this.promotionMixGoodsRepository.saveAll(promotionMixGoods);
        return promotionMix.getSid();
    }

    public long update(PromotionMixVO promotionMixVO) {
        PromotionMix promotionMix = this.promotionMixRepository.findBySid(promotionMixVO.getSid().longValue());
        if (promotionMix == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u4fc3\u9500\u7ec4\u5408\u4e0d\u5b58\u5728");
        }
        promotionMixVO.generateDO(promotionMix);
        EntityUtils.setModifyFields((BaseEntity)promotionMix);
        this.promotionMixRepository.save((Object)promotionMix);
        this.updateGoods(promotionMixVO.getSid().longValue(), promotionMixVO.getGoods());
        return promotionMixVO.getSid();
    }

    public void updateGoods(long promotionMixSid, List<PromotionMixGoodsVO> promotionMixGoodsVOs) {
        ArrayList deleteSids = new ArrayList();
        ArrayList promotionMixGoods = new ArrayList();
        PromotionMix promotionMix = this.promotionMixRepository.findBySid(promotionMixSid);
        if ("QUANTITY_DISCOUNT".equals(promotionMix.getType())) {
            List existedPromotionMixGoods = this.promotionMixGoodsRepository.findByPromotionMixSid(promotionMixSid).stream().map(PromotionMixGoods::getGoodsCode).collect(Collectors.toList());
            promotionMixGoodsVOs.forEach(goodsVO -> {
                if (1 == goodsVO.getStatus()) {
                    deleteSids.add(goodsVO.getSid());
                } else if (!existedPromotionMixGoods.contains(goodsVO.getGoodsCode())) {
                    PromotionMixGoods goods = goodsVO.generateDO();
                    goods.setPromotionMixSid(promotionMixSid);
                    promotionMixGoods.add(goods);
                }
            });
            if (deleteSids.size() > 0) {
                this.promotionMixGoodsMapper.deleteBySids(deleteSids);
            }
            this.promotionMixGoodsRepository.saveAll(promotionMixGoods);
        } else if ("QUANTITY_PREFERENTIAL".equals(promotionMix.getType())) {
            promotionMixGoodsVOs.forEach(goodsVO -> {
                if (1 == goodsVO.getStatus()) {
                    this.promotionMixGoodsRepository.deleteBySid(goodsVO.getSid().longValue());
                }
            });
            this.promotionMixGoodsRepository.flush();
            promotionMixGoodsVOs.forEach(goodsVO -> {
                PromotionMixGoods goods = goodsVO.generateDO();
                goods.setPromotionMixSid(promotionMixSid);
                if (0 == goodsVO.getStatus()) {
                    this.promotionMixGoodsCrudService.create((BaseEntity)goods);
                } else if (2 == goodsVO.getStatus()) {
                    goods.setSid(goodsVO.getSid().longValue());
                    this.promotionMixGoodsCrudService.update((BaseEntity)goods);
                }
            });
        } else {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("%s\u4fc3\u9500\u7ec4\u5408\u7684\u4fc3\u9500\u7ec4\u5408\u7c7b\u578b\u4e0d\u5b58\u5728", promotionMixSid));
        }
    }

    public PageSerializable getList(PromotionMixConditionVO promotionMixConditionVO, Integer pageNum, Integer pageSize, String orderBy) {
        List promotionMixVOS = this.promotionMixMapper.getList(pageNum, pageSize, orderBy, promotionMixConditionVO);
        List promotionMixSids = promotionMixVOS.stream().map(PromotionMixVO::getSid).collect(Collectors.toList());
        if (promotionMixSids.size() > 0) {
            List promotionMixGoodsVOS = this.promotionMixGoodsMapper.getList(promotionMixSids);
            promotionMixGoodsVOS.forEach(goodsVO -> promotionMixVOS.forEach(promotionMixVO -> {
                if (goodsVO.getPromotionMixSid().equals(promotionMixVO.getSid())) {
                    promotionMixVO.getGoods().add(goodsVO);
                    return;
                }
            }));
        }
        PageSerializable pageResult = new PageSerializable(promotionMixVOS);
        return pageResult;
    }

    public void delete(long deleteSid) {
        if (!this.promotionMixRepository.existsBySid(deleteSid)) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u4fc3\u9500\u7ec4\u5408\u4e0d\u5b58\u5728");
        }
        this.promotionMixRepository.deleteBySid(deleteSid);
        this.promotionMixGoodsRepository.deleteByPromotionMixSid(deleteSid);
    }

    public List<PromotionMixGoodsVO> getGoods(long promotionMixSid) {
        if (!this.promotionMixRepository.existsBySid(promotionMixSid)) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u4fc3\u9500\u7ec4\u5408\u4e0d\u5b58\u5728");
        }
        List promotionMixGoodsVOS = this.promotionMixGoodsMapper.getGoods(promotionMixSid);
        return promotionMixGoodsVOS;
    }

    public PromotionMixVO getPromotionMix(String goodsCode, Long strategySid) {
        PromotionMixVO promotionMixVO = this.promotionMixMapper.getByGoodsCode(goodsCode, strategySid);
        return promotionMixVO;
    }
}

