/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.coupon.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.coupon.UseStatus;
import com.digiwin.dap.middleware.gmc.entity.coupon.Coupon;
import com.digiwin.dap.middleware.gmc.entity.coupon.CouponRule;
import com.digiwin.dap.middleware.gmc.entity.coupon.CouponType;
import com.digiwin.dap.middleware.gmc.entity.coupon.MyCoupon;
import com.digiwin.dap.middleware.gmc.repository.CouponRepository;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponCrudService;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponRuleCrudService;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponTypeCrudService;
import com.digiwin.dap.middleware.gmc.service.coupon.MyCouponCrudService;
import com.digiwin.dap.middleware.gmc.service.coupon.ReceiveCouponService;
import com.digiwin.dap.middleware.gmc.support.cache.RedisCache;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReceiveCouponServiceImpl
implements ReceiveCouponService {
    @Autowired
    CouponRuleCrudService couponRuleCrudService;
    @Autowired
    CouponTypeCrudService couponTypeCrudService;
    @Autowired
    CouponCrudService couponCrudService;
    @Autowired
    MyCouponCrudService myCouponCrudService;
    @Autowired
    RedisCache redisCache;
    @Autowired
    CouponRepository couponRepository;
    public static final String FORMAT_YYYY_MM_DD = "yyyyMMdd";

    public Map<String, Long> receiveCoupon(long tenantSid, long userSid, long couponRuleSid) {
        if (tenantSid == 0L) {
            throw new IllegalArgumentException("tenantSid is 0");
        }
        if (userSid == 0L) {
            throw new IllegalArgumentException("userSid is 0");
        }
        if (couponRuleSid == 0L) {
            throw new IllegalArgumentException("couponRuleSid is 0");
        }
        MyCoupon oldMyCoupon = (MyCoupon)this.myCouponCrudService.findByUnionKey(new Object[]{tenantSid, userSid, couponRuleSid});
        if (oldMyCoupon != null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u79df\u6237" + tenantSid + "\u4e0b\u7528\u6237" + userSid + "\u5df2\u9886\u7528\u8fc7\u6b64\u4f18\u60e0\u5238");
        }
        CouponRule couponRule = (CouponRule)this.couponRuleCrudService.findBySid(couponRuleSid);
        if (couponRule == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u6ca1\u6709\u6b64\u5238\u89c4\u5219:" + couponRuleSid);
        }
        if (couponRule.getEndDate().isBefore(LocalDateTime.now())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u6b64\u5238\u89c4\u5219:" + couponRuleSid + "\u5df2\u8fc7\u9886\u7528\u671f");
        }
        CouponType couponType = (CouponType)this.couponTypeCrudService.findBySid(couponRule.getCouponTypeSid().longValue());
        if (couponType == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, couponRule.getName() + "\u5238\u89c4\u5219\u7684\u5238\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        int count = this.couponRepository.getCouponCount(couponRuleSid);
        if (count < couponRule.getCount()) {
            Coupon coupon = new Coupon();
            String newCode = this.getCouponNum();
            String couponNumber = couponRule.getCode() + "-" + newCode;
            coupon.setCouponNumber(couponNumber);
            coupon.setCouponTypeSid(Long.valueOf(couponType.getSid()));
            coupon.setCouponTypeCode(couponType.getCode());
            coupon.setCouponTypeName(couponType.getName());
            coupon.setCategory(couponType.getCategory());
            coupon.setParValue(couponType.getParValue());
            coupon.setAvailableCondition(couponType.getAvailableCondition());
            coupon.setDiscountRate(couponType.getDiscountRate());
            coupon.setLimitDiscount(couponType.getLimitDiscount());
            coupon.setCouponRuleSid(Long.valueOf(couponRule.getSid()));
            coupon.setCouponRuleCode(couponRule.getCode());
            coupon.setCouponRuleName(couponRule.getName());
            coupon.setBeginDate(couponRule.getBeginDate());
            coupon.setEndDate(couponRule.getEndDate());
            coupon.setEffectiveDate(couponRule.getEffectiveDate());
            coupon.setExpiredDate(couponRule.getExpiredDate());
            long couponSid = this.couponCrudService.create((BaseEntity)coupon);
            MyCoupon myCoupon = new MyCoupon();
            myCoupon.setTenantSid(Long.valueOf(tenantSid));
            myCoupon.setUserSid(Long.valueOf(userSid));
            myCoupon.setCouponRuleSid(Long.valueOf(couponRuleSid));
            myCoupon.setCouponSid(Long.valueOf(couponSid));
            myCoupon.setUseStatus(UseStatus.UNUSED);
            myCoupon.setUsedDate(null);
            long myCouponSid = this.myCouponCrudService.create((BaseEntity)myCoupon);
            HashMap<String, Long> resultMap = new HashMap<String, Long>(2);
            resultMap.put("couponSid", couponSid);
            resultMap.put("myCouponSid", myCouponSid);
            return resultMap;
        }
        throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "COUPON_UPPERLIMIT");
    }

    private String getCouponNum() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(FORMAT_YYYY_MM_DD);
        String dateStr = dtf.format(now);
        StringBuilder sb = new StringBuilder();
        sb.append(dateStr);
        long sequence = this.redisCache.increment(sb.toString(), 1L);
        sb.append(String.format("%06d", sequence));
        return sb.toString();
    }
}

