/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.customform.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.customform.CustomFormGoodsVO;
import com.digiwin.dap.middleware.gmc.entity.customform.CustomForm;
import com.digiwin.dap.middleware.gmc.entity.customform.CustomFormGoods;
import com.digiwin.dap.middleware.gmc.mapper.CustomFormGoodsMapper;
import com.digiwin.dap.middleware.gmc.repository.CustomFormGoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.CustomFormRepository;
import com.digiwin.dap.middleware.gmc.service.customform.CustomFormGoodsService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomFormGoodsServiceImpl
implements CustomFormGoodsService {
    @Autowired
    private CustomFormRepository customFormRepository;
    @Autowired
    private CustomFormGoodsRepository customFormGoodsRepository;
    @Autowired
    private CustomFormGoodsMapper customFormGoodsMapper;

    public Long update(Long sid, List<CustomFormGoodsVO> goods) {
        CustomForm customForm = this.customFormRepository.findBySid(sid.longValue());
        if (null == customForm) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_CUSTOM_FORM_NOT_EXISTED, new Object[]{sid});
        }
        ArrayList customFormGoodsList = new ArrayList();
        List existedCustomFormGoods = this.customFormGoodsRepository.findByCustomFormSid(sid.longValue()).stream().map(CustomFormGoods::getGoodsCode).collect(Collectors.toList());
        goods.forEach(goodsVO -> {
            if (1 == goodsVO.getStatus()) {
                this.customFormGoodsRepository.deleteByCustomFormSidAndGoodsCode(sid.longValue(), goodsVO.getId());
            } else {
                CustomFormGoods existCustomFormGoods = this.customFormGoodsRepository.findByGoodsCode(goodsVO.getId());
                if (null != existCustomFormGoods && !existCustomFormGoods.getCustomFormSid().equals(sid)) {
                    throw new BusinessException((ErrorHandler)I18nError.ERROR_CUSTOM_FORM_GOODS_EXISTED, new Object[]{goodsVO.getId()});
                }
                if (!existedCustomFormGoods.contains(goodsVO.getId())) {
                    CustomFormGoods customFormGoods = new CustomFormGoods();
                    customFormGoods.setCustomFormSid(sid);
                    customFormGoods.setGoodsCode(goodsVO.getId());
                    EntityUtils.setCreateFields((BaseEntity)customFormGoods);
                    customFormGoodsList.add(customFormGoods);
                }
            }
        });
        this.customFormGoodsRepository.saveAll(customFormGoodsList);
        return sid;
    }

    public List<CustomFormGoodsVO> getCustomFormGoodsList() {
        return this.customFormGoodsMapper.selectCustomFormGoodsList();
    }
}

