/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.customform.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.customform.CustomFormContentVO;
import com.digiwin.dap.middleware.gmc.domain.customform.CustomFormVO;
import com.digiwin.dap.middleware.gmc.entity.customform.CustomForm;
import com.digiwin.dap.middleware.gmc.entity.customform.CustomFormContent;
import com.digiwin.dap.middleware.gmc.mapper.CustomFormGoodsMapper;
import com.digiwin.dap.middleware.gmc.mapper.CustomFormMapper;
import com.digiwin.dap.middleware.gmc.repository.CustomFormContentRepository;
import com.digiwin.dap.middleware.gmc.repository.CustomFormGoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.CustomFormRepository;
import com.digiwin.dap.middleware.gmc.service.customform.CustomFormService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomFormServiceImpl
implements CustomFormService {
    @Autowired
    private CustomFormRepository customFormRepository;
    @Autowired
    private CustomFormContentRepository customFormContentRepository;
    @Autowired
    private CustomFormMapper customFormMapper;
    @Autowired
    private CustomFormGoodsRepository customFormGoodsRepository;
    @Autowired
    private CustomFormGoodsMapper customFormGoodsMapper;
    private static ObjectMapper objectMapper = JsonUtils.createObjectMapper();

    public Long save(CustomFormVO customFormVO) {
        if (this.customFormRepository.existsByName(customFormVO.getName())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_CUSTOM_FORM_EXISTED, new Object[]{customFormVO.getName()});
        }
        CustomForm customForm = new CustomForm(customFormVO.getName());
        EntityUtils.setCreateFields((BaseEntity)customForm);
        long sid = ((CustomForm)this.customFormRepository.save((Object)customForm)).getSid();
        List content = customFormVO.getContent();
        for (CustomFormContentVO customFormContentVO : content) {
            CustomFormContent customFormContent = new CustomFormContent(customFormContentVO, Long.valueOf(sid));
            EntityUtils.setCreateFields((BaseEntity)customFormContent);
            this.customFormContentRepository.save((Object)customFormContent);
        }
        return sid;
    }

    public Long update(CustomFormVO customFormVO) {
        CustomForm customForm = this.customFormRepository.findBySid(customFormVO.getSid().longValue());
        if (null == customForm) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_CUSTOM_FORM_NOT_EXISTED, new Object[]{customFormVO.getSid()});
        }
        CustomForm existCustomForm = this.customFormRepository.findByName(customFormVO.getName());
        if (null != existCustomForm && existCustomForm.getSid() != customFormVO.getSid().longValue()) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_CUSTOM_FORM_EXISTED, new Object[]{customFormVO.getName()});
        }
        customForm.setName(customFormVO.getName());
        EntityUtils.setModifyFields((BaseEntity)customForm);
        this.customFormRepository.save((Object)customForm);
        List content = customFormVO.getContent();
        this.customFormContentRepository.deleteByCustomFormSid(customFormVO.getSid().longValue());
        for (CustomFormContentVO customFormContentVO : content) {
            CustomFormContent customFormContent = new CustomFormContent(customFormContentVO, customFormVO.getSid());
            EntityUtils.setCreateFields((BaseEntity)customFormContent);
            this.customFormContentRepository.save((Object)customFormContent);
        }
        return customFormVO.getSid();
    }

    public Long delete(Long sid) {
        this.customFormContentRepository.deleteByCustomFormSid(sid.longValue());
        this.customFormGoodsRepository.deleteByCustomFormSid(sid.longValue());
        return this.customFormRepository.deleteBySid(sid.longValue());
    }

    public List<CustomFormVO> getCustomFormList(CustomFormVO condition, int pageNum, int pageSize, String orderBy) {
        List customFormVOList = this.customFormMapper.findCustomForms(condition, pageNum, pageSize, orderBy);
        customFormVOList.forEach(o -> {
            List customFormGoodsVOList = this.customFormGoodsMapper.selectCustomFormGoods(o.getSid());
            o.setCustomFormGoodsVOS(customFormGoodsVOList);
        });
        return customFormVOList;
    }

    public CustomFormVO getCustomForm(long customFormSid) {
        CustomFormVO customFormVO = this.customFormMapper.findCustomFormBySid(customFormSid);
        if (null != customFormVO) {
            try {
                for (CustomFormContentVO contentVO : customFormVO.getContent()) {
                    contentVO.setValueParameter((List)objectMapper.readValue(contentVO.getValueParameterStr(), List.class));
                }
            }
            catch (IOException e) {
                throw new BusinessException((Throwable)e);
            }
        }
        return customFormVO;
    }

    public CustomFormVO getCustomFormByGoodsCode(String goodsCode) {
        CustomFormVO customFormVO = this.customFormMapper.findCustomFormByGoodsCode(goodsCode);
        if (null != customFormVO) {
            try {
                for (CustomFormContentVO contentVO : customFormVO.getContent()) {
                    contentVO.setValueParameter((List)objectMapper.readValue(contentVO.getValueParameterStr(), List.class));
                }
            }
            catch (IOException e) {
                throw new BusinessException((Throwable)e);
            }
        }
        return customFormVO;
    }
}

