/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.goods.impl;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.GmcConstant;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.gmc.domain.EnvProperties;
import com.digiwin.dap.middleware.gmc.domain.calculate.OrderDetailItemsVO;
import com.digiwin.dap.middleware.gmc.domain.calculate.PackCalculateVO;
import com.digiwin.dap.middleware.gmc.domain.calculate.PackGoodVO;
import com.digiwin.dap.middleware.gmc.domain.calculate.PackPriceVO;
import com.digiwin.dap.middleware.gmc.domain.calculate.PriceParamVO;
import com.digiwin.dap.middleware.gmc.domain.calculate.ShoppingCartPriceVO;
import com.digiwin.dap.middleware.gmc.domain.calculate.ShoppingCartVO;
import com.digiwin.dap.middleware.gmc.domain.calculate.TotalPriceVO;
import com.digiwin.dap.middleware.gmc.domain.coupon.CouponCategory;
import com.digiwin.dap.middleware.gmc.domain.coupon.UseStatus;
import com.digiwin.dap.middleware.gmc.domain.pack.PackInfoVO;
import com.digiwin.dap.middleware.gmc.domain.remote.AuthorizationVO;
import com.digiwin.dap.middleware.gmc.domain.sellingstrategy.ApportionType;
import com.digiwin.dap.middleware.gmc.entity.Goods;
import com.digiwin.dap.middleware.gmc.entity.MultipleItem;
import com.digiwin.dap.middleware.gmc.entity.PromotionMix;
import com.digiwin.dap.middleware.gmc.entity.PromotionMixGoods;
import com.digiwin.dap.middleware.gmc.entity.SellingStrategy;
import com.digiwin.dap.middleware.gmc.entity.coupon.Coupon;
import com.digiwin.dap.middleware.gmc.entity.coupon.CouponType;
import com.digiwin.dap.middleware.gmc.entity.coupon.MyCoupon;
import com.digiwin.dap.middleware.gmc.mapper.PackMapper;
import com.digiwin.dap.middleware.gmc.repository.CouponRuleSuitableGoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.GoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.ItemTaxRateRepository;
import com.digiwin.dap.middleware.gmc.repository.MultipleItemRepository;
import com.digiwin.dap.middleware.gmc.repository.PromotionMixGoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.PromotionMixRepository;
import com.digiwin.dap.middleware.gmc.service.CyberSecurityService;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponCrudService;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponTypeCrudService;
import com.digiwin.dap.middleware.gmc.service.coupon.MyCouponCrudService;
import com.digiwin.dap.middleware.gmc.service.goods.CalculateService;
import com.digiwin.dap.middleware.gmc.service.goods.ItemTaxRateService;
import com.digiwin.dap.middleware.gmc.service.goods.SellingStrategyCrudService;
import com.digiwin.dap.middleware.gmc.support.remote.CacService;
import com.digiwin.dap.middleware.gmc.support.remote.OrderService;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.digiwin.dap.middleware.util.UserUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class CalculateServiceImpl
implements CalculateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalculateServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private GoodsRepository goodsRepository;
    @Autowired
    private CacService cacService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private MultipleItemRepository multipleItemRepository;
    @Autowired
    private ItemTaxRateService itemTaxRateService;
    @Autowired
    private ItemTaxRateRepository itemTaxRateRepository;
    @Autowired
    private SellingStrategyCrudService sellingStrategyCrudService;
    @Autowired
    private CouponCrudService couponCrudService;
    @Autowired
    private MyCouponCrudService myCouponCrudService;
    @Autowired
    private CouponTypeCrudService couponTypeCrudService;
    @Autowired
    private PromotionMixRepository promotionMixRepository;
    @Autowired
    private PromotionMixGoodsRepository promotionMixGoodsRepository;
    @Autowired
    private PackMapper packMapper;
    @Autowired
    private CouponRuleSuitableGoodsRepository couponRuleSuitableGoodsRepository;
    @Autowired
    private CyberSecurityService cyberSecurityService;

    public TotalPriceVO calculateMonthTotalPrice(PriceParamVO priceParamVO) {
        BigDecimal totalPrice;
        long tenantSid = UserUtils.getTenantSid();
        long userSid = UserUtils.getUserSid();
        TotalPriceVO totalPriceVO = new TotalPriceVO();
        totalPriceVO.setOrderNumber(priceParamVO.getOrderNumber());
        SellingStrategy sellingStrategy = (SellingStrategy)this.sellingStrategyCrudService.findBySid(Long.parseLong(priceParamVO.getSellingStrategyId()));
        if (sellingStrategy == null) {
            throw new BusinessException(String.format("\u9500\u552e\u65b9\u6848[%s]\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4!", priceParamVO.getSellingStrategyId()));
        }
        List multipleItems = this.multipleItemRepository.findAllBySellingStrategySid(Long.parseLong(priceParamVO.getSellingStrategyId()));
        if (multipleItems.isEmpty()) {
            throw new BusinessException(String.format("\u9500\u552e\u65b9\u6848[%s]\u7684\u54c1\u53f7\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4!", priceParamVO.getSellingStrategyId()));
        }
        Goods goods = this.goodsRepository.findBySid(Long.parseLong(priceParamVO.getGoodsId()));
        if (goods == null) {
            throw new BusinessException(String.format("\u5546\u54c1[%s]\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4!", priceParamVO.getGoodsId()));
        }
        if (!Objects.equals(sellingStrategy.getGoodsCode(), goods.getCode())) {
            this.cyberSecurityService.logSecurityError((Object)priceParamVO);
            throw new BusinessException(String.format("\u9500\u552e\u65b9\u6848[%s]\u7684\u5546\u54c1\u7f16\u7801\u4e0e\u5546\u54c1[%s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u786e\u8ba4!", priceParamVO.getSellingStrategyId(), priceParamVO.getGoodsId()));
        }
        List multipleItemsVariable = multipleItems.stream().filter(m -> m.getApportionType().equals((Object)ApportionType.VARIABLECOST)).collect(Collectors.toList());
        BigDecimal sellingStrategyPrice = multipleItemsVariable.stream().map(MultipleItem::getStandardPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        List multipleItemsFixed = multipleItems.stream().filter(m -> m.getApportionType().equals((Object)ApportionType.FIXEDCOST)).collect(Collectors.toList());
        BigDecimal fixedPrice = multipleItemsFixed.stream().map(MultipleItem::getStandardPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (priceParamVO.isContractTenant().booleanValue()) {
            sellingStrategyPrice = multipleItemsVariable.stream().map(MultipleItem::getContractPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            fixedPrice = multipleItemsFixed.stream().map(MultipleItem::getContractPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        Coupon coupon = null;
        PromotionMix promotionMix = null;
        if (priceParamVO.getCouponSid() != null && (coupon = (Coupon)this.couponCrudService.findBySid(priceParamVO.getCouponSid().longValue())) != null) {
            this.checkCoupon(coupon, tenantSid, userSid, goods.getCode(), (Object)priceParamVO);
        }
        if (priceParamVO.getCouponTypeSid() != null) {
            CouponType couponType = (CouponType)this.couponTypeCrudService.findBySid(priceParamVO.getCouponTypeSid().longValue());
            if (couponType != null) {
                coupon = new Coupon(couponType);
            }
        } else if (priceParamVO.getPromotionMixSid() != null) {
            promotionMix = this.promotionMixRepository.findBySid(priceParamVO.getPromotionMixSid().longValue());
        }
        if (priceParamVO.getPaymentType() == 1 && GoodsCategoryEnum.APP.id().equals(goods.getCategoryId())) {
            int tenancyPeriod = sellingStrategy.getTenancyPeriod().intValue();
            int userCount = sellingStrategy.getUsersNumber().intValue();
            BigDecimal purchasePrice = goods.getPurchasePrice();
            BigDecimal sellingStrategyTotalPrice = sellingStrategyPrice.multiply(new BigDecimal(priceParamVO.getOrderNumber()));
            BigDecimal purchaseTotalPrice = purchasePrice.multiply(new BigDecimal(tenancyPeriod * priceParamVO.getOrderNumber() * (priceParamVO.getUserNumber() - userCount)));
            totalPriceVO.setSellingStrategyTotalPrice(sellingStrategy.getUsersNumber() + "U," + tenancyPeriod * priceParamVO.getOrderNumber() + "\u6708:" + sellingStrategyPrice + "*" + priceParamVO.getOrderNumber() + "=" + sellingStrategyTotalPrice);
            totalPriceVO.setPurchaseTotalPrice(priceParamVO.getUserNumber() - userCount + "U," + tenancyPeriod * priceParamVO.getOrderNumber() + "\u6708:" + (priceParamVO.getUserNumber() - userCount) + "*" + tenancyPeriod * priceParamVO.getOrderNumber() + "*" + purchasePrice + "=" + purchaseTotalPrice);
            BigDecimal priceSpread = BigDecimal.ZERO;
            if (priceParamVO.getUserNumber() > priceParamVO.getCacUserNumber()) {
                priceSpread = this.calculatePriceSpread(priceParamVO, goods.getCode(), purchasePrice, totalPriceVO);
            } else {
                totalPriceVO.setPriceSpread("0");
            }
            totalPrice = sellingStrategyTotalPrice.add(purchaseTotalPrice).add(priceSpread).add(fixedPrice);
            totalPriceVO.setFixedPrice("\u56fa\u5b9a\u8d39\u7528\uff1a" + fixedPrice);
            totalPriceVO.setMemo("\u91d1\u984d=" + sellingStrategyTotalPrice + "+" + purchaseTotalPrice + "+" + priceSpread + "+" + fixedPrice + "=" + totalPrice);
            if (purchaseTotalPrice.compareTo(BigDecimal.ZERO) > 0 || priceSpread.compareTo(BigDecimal.ZERO) > 0) {
                multipleItems.add(this.addMultipleItem(goods.getDisplayName(), goods.getUserNumberCode(), purchaseTotalPrice.add(priceSpread)));
            }
        } else if (priceParamVO.getPaymentType() == 2 && GoodsCategoryEnum.APP.id().equals(goods.getCategoryId())) {
            PackCalculateVO packCalculateVO = new PackCalculateVO();
            packCalculateVO.setPack(Boolean.valueOf(false));
            packCalculateVO.setTenantId(priceParamVO.getTenantId());
            packCalculateVO.setFixedPrice(fixedPrice);
            packCalculateVO.setGoodsCode(goods.getCode());
            packCalculateVO.setOrderNumber(priceParamVO.getOrderNumber());
            packCalculateVO.setOverlayTenancyPeriod(goods.getOverlayTenancyPeriod());
            packCalculateVO.setSellingStrategyPrice(sellingStrategyPrice);
            packCalculateVO.setSellingPurchasePrice(sellingStrategy.getPurchasePrice());
            totalPrice = this.calculateCustomerUnitPrice(packCalculateVO);
        } else {
            totalPrice = sellingStrategyPrice.multiply(new BigDecimal(priceParamVO.getOrderNumber())).add(fixedPrice);
        }
        totalPriceVO.setTotalPrice(totalPrice);
        totalPriceVO.setOriginalPrice(totalPrice);
        totalPriceVO.setDiscountPrice(BigDecimal.ZERO);
        if (coupon != null) {
            this.calculateDiscountPrice(coupon, totalPriceVO);
            totalPriceVO.setDiscountInfo("\u6298\u6263\u91d1\u989d:" + totalPriceVO.getDiscountPrice());
        } else if (promotionMix != null) {
            this.calculateDiscountPrice(promotionMix, priceParamVO.getGoodsId(), 0L, totalPriceVO, priceParamVO.getOrderNumber());
            totalPriceVO.setDiscountInfo("\u6298\u6263\u91d1\u989d:" + totalPriceVO.getDiscountPrice());
        }
        this.calculateItemTaxRate(totalPriceVO, goods.getWhetherTax().booleanValue(), multipleItems, priceParamVO.isContractTenant().booleanValue(), priceParamVO.getOrderNumber().intValue());
        return totalPriceVO;
    }

    public TotalPriceVO calculatePurchaseUserPrice(PriceParamVO priceParamVO) {
        TotalPriceVO totalPriceVO = new TotalPriceVO();
        totalPriceVO.setOrderNumber(priceParamVO.getOrderNumber());
        Goods goods = this.goodsRepository.findBySid(Long.parseLong(priceParamVO.getGoodsId()));
        if (goods == null) {
            throw new RuntimeException("\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4!");
        }
        ArrayList<MultipleItem> multipleItems = new ArrayList<MultipleItem>();
        BigDecimal purchasePrice = goods.getPurchasePrice();
        AuthorizationVO authorizationVO = this.cacService.getExpiredDateTime(priceParamVO.getTenantId(), goods.getCode());
        if (authorizationVO != null) {
            BigDecimal totalPrice = this.calculatePriceSpread(authorizationVO.getExpiredTime(), purchasePrice, priceParamVO.getUserNumber().intValue(), totalPriceVO);
            totalPriceVO.setTotalPrice(totalPrice);
            if (totalPrice.compareTo(BigDecimal.ZERO) > 0) {
                multipleItems.add(this.addMultipleItem(goods.getDisplayName(), goods.getUserNumberCode(), totalPrice));
            }
            totalPriceVO.setOriginalPrice(totalPrice);
            totalPriceVO.setDiscountPrice(BigDecimal.ZERO);
            this.calculateItemTaxRate(totalPriceVO, goods.getWhetherTax().booleanValue(), multipleItems, priceParamVO.isContractTenant().booleanValue(), priceParamVO.getOrderNumber().intValue());
        }
        return totalPriceVO;
    }

    public OrderDetailItemsVO calculateOrderItemPrice(OrderDetailItemsVO orderDetailItemsVO) {
        OrderDetailItemsVO detailItemsVO = new OrderDetailItemsVO();
        BigDecimal itemPrice = orderDetailItemsVO.getTotalPrice();
        if ("CN".equals(this.envProperties.getArea())) {
            int rate = this.itemTaxRateService.getItemTaxRate(orderDetailItemsVO.getItemCode(), null);
            BigDecimal tariff = new BigDecimal(100 + rate);
            this.calculateItemPrice(detailItemsVO, itemPrice, true, tariff, 4);
        } else {
            BigDecimal tariff = new BigDecimal(100 + GmcConstant.RATE_TW);
            this.calculateItemPrice(detailItemsVO, itemPrice, true, tariff, 0);
        }
        return detailItemsVO;
    }

    public ShoppingCartPriceVO calculateShoppingCartPrice(ShoppingCartVO shoppingCartVO) {
        ShoppingCartPriceVO shoppingCartPriceVO = new ShoppingCartPriceVO();
        ArrayList goodsPriceDetails = new ArrayList();
        shoppingCartVO.getGoods().forEach(goodsInfo -> {
            Goods goods = this.goodsRepository.findBySid(goodsInfo.getGoodsSid());
            if (goods == null) {
                throw new BusinessException(String.format("\u5546\u54c1[%s]\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4!", goodsInfo.getGoodsSid()));
            }
            ShoppingCartPriceVO.GoodsPriceDetail goodsPriceDetail = new ShoppingCartPriceVO.GoodsPriceDetail();
            ArrayList sellingStrategyPrices = new ArrayList();
            goodsInfo.getSellingStrategys().forEach(sellingStrategyInfo -> {
                PromotionMix promotionMix;
                SellingStrategy sellingStrategy = (SellingStrategy)this.sellingStrategyCrudService.findBySid(sellingStrategyInfo.getSellingStrategySid());
                if (sellingStrategy == null) {
                    throw new BusinessException(String.format("\u9500\u552e\u65b9\u6848[%s]\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4!", sellingStrategyInfo.getSellingStrategySid()));
                }
                if (!Objects.equals(sellingStrategy.getGoodsCode(), goods.getCode())) {
                    this.cyberSecurityService.logSecurityError((Object)shoppingCartVO);
                    throw new BusinessException(String.format("\u9500\u552e\u65b9\u6848[%s]\u7684\u5546\u54c1\u7f16\u7801\u4e0e\u5546\u54c1[%s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u786e\u8ba4!", sellingStrategyInfo.getSellingStrategySid(), goodsInfo.getGoodsSid()));
                }
                TotalPriceVO sellingStrategyPriceDetail = new TotalPriceVO();
                sellingStrategyPriceDetail.setOrderNumber(sellingStrategyInfo.getOrderNumber());
                List multipleItems = this.multipleItemRepository.findAllBySellingStrategySid(sellingStrategyInfo.getSellingStrategySid());
                if (multipleItems.isEmpty()) {
                    throw new BusinessException(String.format("\u9500\u552e\u65b9\u6848[%s]\u7684\u54c1\u53f7\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4!", sellingStrategyInfo.getSellingStrategySid()));
                }
                List multipleItemsVariable = multipleItems.stream().filter(m -> m.getApportionType().equals((Object)ApportionType.VARIABLECOST)).collect(Collectors.toList());
                BigDecimal sellingStrategyPrice = multipleItemsVariable.stream().map(MultipleItem::getStandardPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                List multipleItemsFixed = multipleItems.stream().filter(m -> m.getApportionType().equals((Object)ApportionType.FIXEDCOST)).collect(Collectors.toList());
                BigDecimal fixedPrice = multipleItemsFixed.stream().map(MultipleItem::getStandardPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (shoppingCartVO.getContractTenant().booleanValue() && GoodsCategoryEnum.isPromotionPrice((String)goods.getCategoryId())) {
                    sellingStrategyPrice = multipleItemsVariable.stream().map(MultipleItem::getContractPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    fixedPrice = multipleItemsFixed.stream().map(MultipleItem::getContractPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                sellingStrategyPriceDetail.setSellingStrategySid(sellingStrategyInfo.getSellingStrategySid());
                sellingStrategyPriceDetail.setTotalPrice(sellingStrategyPrice.multiply(new BigDecimal(sellingStrategyInfo.getOrderNumber())).add(fixedPrice));
                if (GoodsCategoryEnum.APP.id().equals(goods.getCategoryId()) || GoodsCategoryEnum.PLATFORM.id().equals(goods.getCategoryId())) {
                    PackCalculateVO packCalculateVO;
                    if (1 == goods.getPaymentType()) {
                        if (ObjectUtils.isEmpty((Object)goodsInfo.getUserNumber())) {
                            throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR, new Object[]{"UserNumber"});
                        }
                        if (ObjectUtils.isEmpty((Object)goodsInfo.getCacUserNumber())) {
                            throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR, new Object[]{"CacUserNumber"});
                        }
                        packCalculateVO = new PackCalculateVO(fixedPrice, shoppingCartVO.getTenantId(), sellingStrategyInfo.getOrderNumber().intValue(), goodsInfo.getUserNumber().intValue(), goodsInfo.getCacUserNumber().intValue(), goods, sellingStrategy);
                        sellingStrategyPriceDetail.setTotalPrice(this.calculatePersonMonthPrice(packCalculateVO, sellingStrategyPriceDetail, multipleItems));
                    } else if (2 == goods.getPaymentType()) {
                        packCalculateVO = new PackCalculateVO(fixedPrice, shoppingCartVO.getTenantId(), sellingStrategyInfo.getOrderNumber().intValue(), sellingStrategyPrice, sellingStrategy.getPurchasePrice(), goods);
                        sellingStrategyPriceDetail.setTotalPrice(this.calculateCustomerUnitPrice(packCalculateVO));
                    }
                }
                Coupon coupon = this.getCouponInfo(sellingStrategyInfo.getCouponSid(), sellingStrategyInfo.getCouponTypeSid(), goods.getCode(), (Object)shoppingCartVO);
                sellingStrategyPriceDetail.setOriginalPrice(sellingStrategyPriceDetail.getTotalPrice());
                sellingStrategyPriceDetail.setDiscountPrice(BigDecimal.ZERO);
                if (coupon != null) {
                    this.calculateDiscountPrice(coupon, sellingStrategyPriceDetail);
                    sellingStrategyPriceDetail.setDiscountInfo("\u6298\u6263\u91d1\u989d:" + sellingStrategyPriceDetail.getDiscountPrice());
                } else if (sellingStrategyInfo.getPromotionMixSid() != null && (promotionMix = this.promotionMixRepository.findBySid(sellingStrategyInfo.getPromotionMixSid().longValue())) != null) {
                    this.calculateDiscountPrice(promotionMix, goods.getCode(), sellingStrategyInfo.getSellingStrategySid(), sellingStrategyPriceDetail, sellingStrategyInfo.getOrderNumber());
                }
                this.calculateItemTaxRate(sellingStrategyPriceDetail, goods.getWhetherTax().booleanValue(), multipleItems, shoppingCartVO.getContractTenant().booleanValue(), sellingStrategyInfo.getOrderNumber().intValue());
                sellingStrategyPrices.add(sellingStrategyPriceDetail);
            });
            goodsPriceDetail.setGoodsSid(goodsInfo.getGoodsSid());
            goodsPriceDetail.setSellingStrategyPrice(sellingStrategyPrices);
            goodsPriceDetail.setTotalPrice(sellingStrategyPrices.stream().map(TotalPriceVO::getOriginalPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
            goodsPriceDetail.setDiscountPrice(sellingStrategyPrices.stream().map(TotalPriceVO::getDiscountPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
            goodsPriceDetail.setPayPrice(sellingStrategyPrices.stream().map(TotalPriceVO::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
            goodsPriceDetails.add(goodsPriceDetail);
        });
        shoppingCartPriceVO.setGoodsPriceDetail(goodsPriceDetails);
        shoppingCartPriceVO.setTotalPrice(goodsPriceDetails.stream().map(ShoppingCartPriceVO.GoodsPriceDetail::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        shoppingCartPriceVO.setDiscountPrice(goodsPriceDetails.stream().map(ShoppingCartPriceVO.GoodsPriceDetail::getDiscountPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        shoppingCartPriceVO.setPayPrice(goodsPriceDetails.stream().map(ShoppingCartPriceVO.GoodsPriceDetail::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        return shoppingCartPriceVO;
    }

    public PackPriceVO calculatePackPrice(PackGoodVO packGoodVO) {
        PackPriceVO packPriceVO = new PackPriceVO();
        packPriceVO.setUserCount(packGoodVO.getUserCount());
        packPriceVO.setOrderNumber(packGoodVO.getOrderNumber());
        ArrayList totalPriceVOS = new ArrayList();
        packGoodVO.getGoods().forEach(packGood -> {
            BigDecimal totalPrice;
            TotalPriceVO totalPriceVO = new TotalPriceVO();
            totalPriceVO.setOrderNumber(packGoodVO.getOrderNumber());
            PackInfoVO packInfoVO = this.packMapper.findPackInfo(packGoodVO.getPackSid().longValue(), packGood.getGoodsSid(), packGood.getSellingStrategySid());
            if (packInfoVO == null) {
                throw new BusinessException(String.format("\u7ec4\u5408\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\uff01packSid=%s, goodsSid=%s, sellingStrategySid=%s", packGoodVO.getPackSid(), packGood.getGoodsSid(), packGood.getSellingStrategySid()));
            }
            List multipleItems = this.multipleItemRepository.findAllBySellingStrategySid(packGood.getSellingStrategySid());
            PackCalculateVO packCalculateVO = new PackCalculateVO(packInfoVO, packGoodVO.getTenantId(), packGoodVO.getOrderNumber().intValue(), Boolean.valueOf(true));
            if (packInfoVO.getPaymentType() == 1 && GoodsCategoryEnum.APP.id().equals(packInfoVO.getCategoryId())) {
                packCalculateVO.setUserNumber(packGoodVO.getUserCount());
                packCalculateVO.setUserNumberCode(packInfoVO.getUserNumberCode());
                packCalculateVO.setPurchasePrice(packInfoVO.getPurchasePrice());
                packCalculateVO.setTenancyPeriod(packInfoVO.getTenancyPeriod());
                packCalculateVO.setUserCount(packInfoVO.getUserCount());
                packCalculateVO.setCacUserNumber(Integer.valueOf(0));
                AuthorizationVO authorizationVO = this.cacService.getExpiredDateTime(packCalculateVO.getTenantId(), packCalculateVO.getGoodsCode());
                if (authorizationVO != null) {
                    packCalculateVO.setCacUserNumber(Integer.valueOf(authorizationVO.getTotalCount()));
                }
                totalPrice = this.calculatePersonMonthPrice(packCalculateVO, totalPriceVO, multipleItems);
            } else if (packInfoVO.getPaymentType() == 2 && GoodsCategoryEnum.APP.id().equals(packInfoVO.getCategoryId())) {
                packCalculateVO.setSellingPurchasePrice(packInfoVO.getSellingPurchasePrice());
                packCalculateVO.setOverlayTenancyPeriod(packInfoVO.getOverlayTenancyPeriod());
                totalPrice = this.calculateCustomerUnitPrice(packCalculateVO);
            } else {
                totalPrice = packInfoVO.getPackPrice().multiply(new BigDecimal(packInfoVO.getCount() * packGoodVO.getOrderNumber()));
            }
            totalPriceVO.setTotalPrice(totalPrice);
            totalPriceVO.setOriginalPrice(totalPrice);
            totalPriceVO.setDiscountPrice(BigDecimal.ZERO);
            totalPriceVO.setSellingStrategySid(packGood.getSellingStrategySid());
            this.calculatePackItemTaxRate(totalPriceVO, multipleItems, packCalculateVO);
            totalPriceVOS.add(totalPriceVO);
        });
        packPriceVO.setPayPrice(totalPriceVOS.stream().map(TotalPriceVO::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        packPriceVO.setGoodPrice(totalPriceVOS);
        return packPriceVO;
    }

    private BigDecimal calculatePersonMonthPrice(PackCalculateVO packCalculateVO, TotalPriceVO totalPriceVO, List<MultipleItem> multipleItems) {
        BigDecimal sellingStrategyTotalPrice = packCalculateVO.getPack() != false ? packCalculateVO.getPackPrice().multiply(new BigDecimal(packCalculateVO.getOrderNumber() * packCalculateVO.getPackCount())) : packCalculateVO.getSellingStrategyPrice().multiply(new BigDecimal(packCalculateVO.getOrderNumber()));
        BigDecimal purchaseTotalPrice = packCalculateVO.getPurchasePrice().multiply(new BigDecimal(packCalculateVO.getTenancyPeriod() * packCalculateVO.getOrderNumber() * (packCalculateVO.getUserNumber() - packCalculateVO.getUserCount())));
        totalPriceVO.setSellingStrategyTotalPrice(packCalculateVO.getUserCount() + "U," + packCalculateVO.getTenancyPeriod() * packCalculateVO.getOrderNumber() + "\u6708:" + packCalculateVO.getSellingStrategyPrice() + "*" + packCalculateVO.getOrderNumber() + "=" + sellingStrategyTotalPrice);
        totalPriceVO.setPurchaseTotalPrice(packCalculateVO.getUserNumber() - packCalculateVO.getUserCount() + "U," + packCalculateVO.getTenancyPeriod() * packCalculateVO.getOrderNumber() + "\u6708:" + (packCalculateVO.getUserNumber() - packCalculateVO.getUserCount()) + "*" + packCalculateVO.getTenancyPeriod() * packCalculateVO.getOrderNumber() + "*" + packCalculateVO.getPurchasePrice() + "=" + purchaseTotalPrice);
        BigDecimal priceSpread = BigDecimal.ZERO;
        if (packCalculateVO.getUserNumber() > packCalculateVO.getCacUserNumber()) {
            PriceParamVO priceParamVO = new PriceParamVO(packCalculateVO.getTenantId(), packCalculateVO.getUserNumber(), packCalculateVO.getCacUserNumber());
            priceSpread = this.calculatePriceSpread(priceParamVO, packCalculateVO.getGoodsCode(), packCalculateVO.getPurchasePrice(), totalPriceVO);
        } else {
            totalPriceVO.setPriceSpread("0");
        }
        BigDecimal price = sellingStrategyTotalPrice.add(purchaseTotalPrice).add(priceSpread);
        packCalculateVO.setUserPrice(purchaseTotalPrice.add(priceSpread));
        BigDecimal totalPrice = packCalculateVO.getPack() != false ? price : price.add(packCalculateVO.getFixedPrice());
        if (packCalculateVO.getPack().booleanValue()) {
            totalPriceVO.setMemo("\u91d1\u984d=" + sellingStrategyTotalPrice + "+" + purchaseTotalPrice + "+" + priceSpread + "=" + totalPrice);
        } else {
            totalPriceVO.setFixedPrice("\u56fa\u5b9a\u8d39\u7528\uff1a" + packCalculateVO.getFixedPrice());
            totalPriceVO.setMemo("\u91d1\u984d=" + sellingStrategyTotalPrice + "+" + purchaseTotalPrice + "+" + priceSpread + "+" + packCalculateVO.getFixedPrice() + "=" + totalPrice);
        }
        if (purchaseTotalPrice.compareTo(BigDecimal.ZERO) > 0 || priceSpread.compareTo(BigDecimal.ZERO) > 0) {
            multipleItems.add(this.addMultipleItem(packCalculateVO.getDisplayName(), packCalculateVO.getUserNumberCode(), purchaseTotalPrice.add(priceSpread)));
        }
        return totalPrice;
    }

    private BigDecimal calculateCustomerUnitPrice(PackCalculateVO packCalculateVO) {
        BigDecimal totalPrice = BigDecimal.ZERO;
        if (packCalculateVO.getOverlayTenancyPeriod().booleanValue()) {
            totalPrice = packCalculateVO.getPack().booleanValue() ? packCalculateVO.getPackPrice().multiply(new BigDecimal(packCalculateVO.getPackCount() * packCalculateVO.getOrderNumber())) : packCalculateVO.getSellingStrategyPrice().multiply(new BigDecimal(packCalculateVO.getOrderNumber())).add(packCalculateVO.getFixedPrice());
        } else {
            AuthorizationVO authorizationVO = this.cacService.getExpiredDateTime(packCalculateVO.getTenantId(), packCalculateVO.getGoodsCode());
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            if (authorizationVO == null || LocalDate.now().isAfter(LocalDate.parse(authorizationVO.getExpiredTime(), df))) {
                totalPrice = packCalculateVO.getPack().booleanValue() ? packCalculateVO.getPackPrice().multiply(new BigDecimal(packCalculateVO.getPackCount() * packCalculateVO.getOrderNumber())) : packCalculateVO.getSellingStrategyPrice().multiply(new BigDecimal(packCalculateVO.getOrderNumber())).add(packCalculateVO.getFixedPrice());
            } else {
                LocalDate expiredTime = LocalDate.parse(authorizationVO.getExpiredTime(), df);
                Period period = Period.between(LocalDate.now(), expiredTime);
                if (period.getYears() >= 0 && period.getMonths() >= 0 && period.getDays() >= 0) {
                    BigDecimal sellingPurchasePrice = packCalculateVO.getSellingPurchasePrice();
                    BigDecimal priceSpreadMonth = sellingPurchasePrice.multiply(new BigDecimal(packCalculateVO.getOrderNumber() * (period.getYears() * 12 + period.getMonths())));
                    BigDecimal dayUnitPrice = sellingPurchasePrice.divide(new BigDecimal(30), 4, 4);
                    BigDecimal priceSpreadDay = dayUnitPrice.multiply(new BigDecimal(period.getDays() * packCalculateVO.getOrderNumber()));
                    priceSpreadDay = priceSpreadDay.setScale(0, 4);
                    totalPrice = priceSpreadMonth.add(priceSpreadDay);
                }
            }
        }
        return totalPrice;
    }

    private BigDecimal calculatePriceSpread(PriceParamVO priceParamVO, String goodsCode, BigDecimal purchasePrice, TotalPriceVO totalPriceVO) {
        BigDecimal priceSpread = BigDecimal.ZERO;
        AuthorizationVO authorizationVO = this.cacService.getExpiredDateTime(priceParamVO.getTenantId(), goodsCode);
        if (authorizationVO != null) {
            if (this.isCalculatePriceSpread(authorizationVO.getLastStrategyId())) {
                int userNumber = priceParamVO.getUserNumber() - priceParamVO.getCacUserNumber();
                priceSpread = this.calculatePriceSpread(authorizationVO.getExpiredTime(), purchasePrice, userNumber, totalPriceVO);
            } else {
                totalPriceVO.setPriceSpread("\u4f53\u9a8c\u65b9\u6848\u65e0\u9700\u8865U\u6570\u5dee\u4ef7");
            }
        } else {
            totalPriceVO.setPriceSpread("0");
        }
        return priceSpread;
    }

    private BigDecimal calculatePriceSpread(String expiredTime, BigDecimal purchasePrice, int userNumber, TotalPriceVO totalPriceVO) {
        BigDecimal priceSpread = new BigDecimal(0);
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDate dateTime = LocalDate.parse(expiredTime, df);
        Period period = Period.between(LocalDate.now(), dateTime);
        if (period.getYears() >= 0 && period.getMonths() >= 0 && period.getDays() >= 0) {
            BigDecimal priceSpreadMonth = purchasePrice.multiply(new BigDecimal(userNumber * (period.getYears() * 12 + period.getMonths())));
            BigDecimal dayUnitPrice = purchasePrice.divide(new BigDecimal(30), 4, 4);
            BigDecimal priceSpreadDay = dayUnitPrice.multiply(new BigDecimal(period.getDays() * userNumber));
            priceSpreadDay = priceSpreadDay.setScale(0, 4);
            priceSpread = priceSpreadMonth.add(priceSpreadDay);
            totalPriceVO.setPriceSpread(userNumber + "U," + period.getYears() + "\u5e74," + period.getMonths() + "\u6708," + period.getDays() + "\u5929\uff1a" + userNumber + "*((" + period.getYears() + "*12+" + period.getMonths() + ")*" + purchasePrice + "+" + period.getDays() + "*" + purchasePrice.intValue() + "/ 30.0" + ")=" + priceSpread);
        } else {
            totalPriceVO.setPriceSpread("0");
        }
        return priceSpread;
    }

    private boolean isCalculatePriceSpread(Long lastStrategyId) {
        boolean isCalculatePriceSpread = true;
        SellingStrategy bySid = (SellingStrategy)this.sellingStrategyCrudService.findBySid(lastStrategyId.longValue());
        if (bySid != null) {
            isCalculatePriceSpread = Boolean.FALSE.equals(bySid.getExperienceScheme());
        }
        return isCalculatePriceSpread;
    }

    private MultipleItem addMultipleItem(String displayName, String userNumberCode, BigDecimal totalPrice) {
        MultipleItem multipleItem = new MultipleItem();
        multipleItem.setApportionType(ApportionType.FIXEDCOST);
        multipleItem.setSid(SnowFlake.getInstance().newId());
        multipleItem.setItemCode(userNumberCode);
        multipleItem.setItemName(displayName);
        multipleItem.setUnit("\u5355\u4f4d");
        multipleItem.setQuantity(Integer.valueOf(1));
        multipleItem.setStandardPrice(totalPrice);
        multipleItem.setContractPrice(totalPrice);
        return multipleItem;
    }

    private void calculatePackItemTaxRate(TotalPriceVO totalPriceVO, List<MultipleItem> multipleItems, PackCalculateVO packCalculateVO) {
        List itemTaxRates = this.itemTaxRateRepository.findAll();
        ArrayList<OrderDetailItemsVO> orderDetailItemsVOS = new ArrayList<OrderDetailItemsVO>();
        for (int i = 0; i < multipleItems.size(); ++i) {
            BigDecimal packItemPrice;
            MultipleItem multipleItem = multipleItems.get(i);
            OrderDetailItemsVO orderDetailItemsVO = this.getOrderDetailItemsVO(multipleItem);
            BigDecimal itemPrice = multipleItem.getStandardPrice();
            orderDetailItemsVO.setUnitPrice(itemPrice);
            BigDecimal totalItemPrice = totalPriceVO.getTotalPrice();
            if (packCalculateVO.getUserPrice() != null) {
                BigDecimal bigDecimal = totalItemPrice = packCalculateVO.getUserPrice().compareTo(BigDecimal.ZERO) > 0 ? totalPriceVO.getTotalPrice().subtract(packCalculateVO.getUserPrice()) : totalItemPrice;
            }
            if ("CN".equals(this.envProperties.getArea())) {
                BigDecimal bigDecimal = packItemPrice = packCalculateVO.getSellingStrategyPrice().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : totalItemPrice.multiply(itemPrice).divide(packCalculateVO.getSellingStrategyPrice(), 4, 4);
                if (i == multipleItems.size() - 1) {
                    BigDecimal itemTotalPayPrice = orderDetailItemsVOS.stream().map(OrderDetailItemsVO::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    packItemPrice = totalPriceVO.getTotalPrice().subtract(itemTotalPayPrice);
                }
                int rate = this.itemTaxRateService.getItemTaxRate(multipleItem.getItemCode(), itemTaxRates);
                orderDetailItemsVO.setTaxRate(Integer.valueOf(rate));
                orderDetailItemsVO.setTotalPrice(packItemPrice);
                BigDecimal tariff = new BigDecimal(100 + rate);
                this.calculateItemPrice(orderDetailItemsVO, packItemPrice, packCalculateVO.getWhetherTax().booleanValue(), tariff, 4);
            } else {
                BigDecimal bigDecimal = packItemPrice = packCalculateVO.getSellingStrategyPrice().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : totalItemPrice.multiply(itemPrice).divide(packCalculateVO.getSellingStrategyPrice(), 0, 4);
                if (i == multipleItems.size() - 1) {
                    BigDecimal itemTotalPayPrice = orderDetailItemsVOS.stream().map(OrderDetailItemsVO::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    packItemPrice = totalPriceVO.getTotalPrice().subtract(itemTotalPayPrice);
                }
                orderDetailItemsVO.setTaxRate(GmcConstant.RATE_TW);
                orderDetailItemsVO.setTotalPrice(packItemPrice);
                BigDecimal tariff = new BigDecimal(100 + GmcConstant.RATE_TW);
                this.calculateItemPrice(orderDetailItemsVO, packItemPrice, packCalculateVO.getWhetherTax().booleanValue(), tariff, 0);
            }
            orderDetailItemsVOS.add(orderDetailItemsVO);
        }
        totalPriceVO.setItems(orderDetailItemsVOS);
        BigDecimal taxPrice = totalPriceVO.getItems().stream().map(OrderDetailItemsVO::getTaxPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        totalPriceVO.setTaxPrice(taxPrice);
        BigDecimal noTaxPrice = totalPriceVO.getItems().stream().map(OrderDetailItemsVO::getNoTaxPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        totalPriceVO.setNoTaxPrice(noTaxPrice);
        BigDecimal containTaxPrice = totalPriceVO.getItems().stream().map(OrderDetailItemsVO::getContainTaxPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        totalPriceVO.setContainTaxPrice(containTaxPrice);
    }

    private void calculateItemTaxRate(TotalPriceVO totalPriceVO, boolean whetherTax, List<MultipleItem> multipleItems, boolean isContractTenant, int orderNumber) {
        List itemTaxRates = this.itemTaxRateRepository.findAll();
        ArrayList<OrderDetailItemsVO> orderDetailItemsVOS = new ArrayList<OrderDetailItemsVO>();
        for (int i = 0; i < multipleItems.size(); ++i) {
            BigDecimal payPrice;
            BigDecimal itemDiscountPrice;
            MultipleItem multipleItem = multipleItems.get(i);
            OrderDetailItemsVO orderDetailItemsVO = this.getOrderDetailItemsVO(multipleItem);
            BigDecimal itemPrice = multipleItem.getStandardPrice();
            if (isContractTenant) {
                itemPrice = multipleItem.getContractPrice();
            }
            orderDetailItemsVO.setUnitPrice(itemPrice);
            if (ApportionType.VARIABLECOST.equals((Object)multipleItem.getApportionType())) {
                itemPrice = itemPrice.multiply(new BigDecimal(orderNumber));
            }
            if ("CN".equals(this.envProperties.getArea())) {
                itemDiscountPrice = totalPriceVO.getOriginalPrice().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : totalPriceVO.getDiscountPrice().multiply(itemPrice).divide(totalPriceVO.getOriginalPrice(), 4, 4);
                payPrice = itemPrice.subtract(itemDiscountPrice);
                if (i == multipleItems.size() - 1) {
                    BigDecimal itemTotalDistinctPrice = orderDetailItemsVOS.stream().map(OrderDetailItemsVO::getDiscountPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    itemDiscountPrice = totalPriceVO.getDiscountPrice().subtract(itemTotalDistinctPrice);
                    payPrice = itemPrice.subtract(itemDiscountPrice);
                }
                int rate = this.itemTaxRateService.getItemTaxRate(multipleItem.getItemCode(), itemTaxRates);
                orderDetailItemsVO.setTaxRate(Integer.valueOf(rate));
                orderDetailItemsVO.setDiscountPrice(itemDiscountPrice);
                orderDetailItemsVO.setTotalPrice(itemPrice);
                BigDecimal tariff = new BigDecimal(100 + rate);
                this.calculateItemPrice(orderDetailItemsVO, payPrice, whetherTax, tariff, 4);
            } else {
                itemDiscountPrice = totalPriceVO.getOriginalPrice().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : totalPriceVO.getDiscountPrice().multiply(itemPrice).divide(totalPriceVO.getOriginalPrice(), 0, 4);
                payPrice = itemPrice.subtract(itemDiscountPrice);
                if (i == multipleItems.size() - 1) {
                    BigDecimal itemTotalDistinctPrice = orderDetailItemsVOS.stream().map(OrderDetailItemsVO::getDiscountPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    itemDiscountPrice = totalPriceVO.getDiscountPrice().subtract(itemTotalDistinctPrice);
                }
                orderDetailItemsVO.setTaxRate(GmcConstant.RATE_TW);
                orderDetailItemsVO.setDiscountPrice(itemDiscountPrice);
                orderDetailItemsVO.setTotalPrice(itemPrice);
                BigDecimal tariff = new BigDecimal(100 + GmcConstant.RATE_TW);
                this.calculateItemPrice(orderDetailItemsVO, payPrice, whetherTax, tariff, 0);
            }
            orderDetailItemsVOS.add(orderDetailItemsVO);
        }
        totalPriceVO.setItems(orderDetailItemsVOS);
        BigDecimal taxPrice = totalPriceVO.getItems().stream().map(OrderDetailItemsVO::getTaxPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        totalPriceVO.setTaxPrice(taxPrice);
        BigDecimal noTaxPrice = totalPriceVO.getItems().stream().map(OrderDetailItemsVO::getNoTaxPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        totalPriceVO.setNoTaxPrice(noTaxPrice);
        BigDecimal containTaxPrice = totalPriceVO.getItems().stream().map(OrderDetailItemsVO::getContainTaxPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        totalPriceVO.setContainTaxPrice(containTaxPrice);
    }

    private OrderDetailItemsVO getOrderDetailItemsVO(MultipleItem multipleItem) {
        OrderDetailItemsVO orderDetailItemsVO = new OrderDetailItemsVO();
        orderDetailItemsVO.setApportionType(multipleItem.getApportionType().name());
        orderDetailItemsVO.setItemCode(multipleItem.getItemCode());
        orderDetailItemsVO.setItemName(multipleItem.getItemName());
        orderDetailItemsVO.setItemSid(Long.valueOf(multipleItem.getSid()));
        orderDetailItemsVO.setQuantity(multipleItem.getQuantity());
        orderDetailItemsVO.setUnit(multipleItem.getUnit());
        return orderDetailItemsVO;
    }

    private void calculateItemPrice(OrderDetailItemsVO orderDetailItemsVO, BigDecimal payPrice, boolean whetherTax, BigDecimal rate, int scale) {
        BigDecimal v1 = new BigDecimal(100);
        if (whetherTax) {
            orderDetailItemsVO.setPayPrice(payPrice);
            BigDecimal noTaxPrice = payPrice.multiply(v1).divide(rate, scale, 4);
            orderDetailItemsVO.setNoTaxPrice(noTaxPrice);
            orderDetailItemsVO.setTaxPrice(payPrice.subtract(noTaxPrice));
            orderDetailItemsVO.setContainTaxPrice(payPrice);
        } else {
            BigDecimal containTaxPrice = payPrice.multiply(rate).divide(v1, scale, 4);
            orderDetailItemsVO.setPayPrice(containTaxPrice);
            orderDetailItemsVO.setNoTaxPrice(payPrice);
            orderDetailItemsVO.setTaxPrice(containTaxPrice.subtract(payPrice));
            orderDetailItemsVO.setContainTaxPrice(containTaxPrice);
        }
    }

    private TotalPriceVO calculateDiscountPrice(Coupon coupon, TotalPriceVO totalPriceVO) {
        if (new BigDecimal(coupon.getAvailableCondition()).compareTo(totalPriceVO.getTotalPrice()) > 0) {
            return totalPriceVO;
        }
        if (coupon.getCategory().equals((Object)CouponCategory.CASHCOUPON)) {
            if (totalPriceVO.getOriginalPrice().compareTo(new BigDecimal(coupon.getParValue())) < 0) {
                totalPriceVO.setTotalPrice(BigDecimal.ZERO);
                totalPriceVO.setDiscountPrice(totalPriceVO.getOriginalPrice());
            } else {
                totalPriceVO.setTotalPrice(totalPriceVO.getOriginalPrice().subtract(new BigDecimal(coupon.getParValue())));
                totalPriceVO.setDiscountPrice(new BigDecimal(coupon.getParValue()));
            }
        }
        if (coupon.getCategory().equals((Object)CouponCategory.DISCOUNTCOUPON)) {
            BigDecimal payPrice = totalPriceVO.getOriginalPrice().multiply(new BigDecimal(coupon.getDiscountRate()).divide(new BigDecimal(100), 4, 4));
            BigDecimal discountPrice = totalPriceVO.getOriginalPrice().subtract(payPrice);
            if (discountPrice.compareTo(new BigDecimal(coupon.getLimitDiscount())) > 0) {
                discountPrice = new BigDecimal(coupon.getLimitDiscount());
                payPrice = totalPriceVO.getOriginalPrice().subtract(discountPrice);
            }
            if ("CN".equals(this.envProperties.getArea())) {
                totalPriceVO.setTotalPrice(payPrice.setScale(4, 4));
                totalPriceVO.setDiscountPrice(totalPriceVO.getOriginalPrice().subtract(totalPriceVO.getTotalPrice()));
            } else {
                totalPriceVO.setTotalPrice(payPrice.setScale(0, 4));
                totalPriceVO.setDiscountPrice(totalPriceVO.getOriginalPrice().subtract(totalPriceVO.getTotalPrice()));
            }
        }
        return totalPriceVO;
    }

    private TotalPriceVO calculateDiscountPrice(PromotionMix promotionMix, String goodsCode, long sellingStrategySid, TotalPriceVO totalPriceVO, Integer orderNumber) {
        Optional<PromotionMixGoods> promotionMixGoods;
        List promotionMixGoodsList = this.promotionMixGoodsRepository.findByPromotionMixSid(promotionMix.getSid());
        if (promotionMix.getType().equals(CouponCategory.QUANTITY_DISCOUNT.toString())) {
            if (promotionMixGoodsList.stream().filter(p -> goodsCode.equals(p.getGoodsCode())).findFirst().orElse(null) != null && LocalDateTime.now().isAfter(promotionMix.getBeginDate()) && LocalDateTime.now().isBefore(promotionMix.getEndDate())) {
                BigDecimal payPrice = totalPriceVO.getOriginalPrice().multiply(new BigDecimal(promotionMix.getDiscountRate()).divide(new BigDecimal(100), 4, 4));
                if ("CN".equals(this.envProperties.getArea())) {
                    totalPriceVO.setTotalPrice(payPrice.setScale(4, 4));
                    totalPriceVO.setDiscountPrice(totalPriceVO.getOriginalPrice().subtract(totalPriceVO.getTotalPrice()));
                } else {
                    totalPriceVO.setTotalPrice(payPrice.setScale(0, 4));
                    totalPriceVO.setDiscountPrice(totalPriceVO.getOriginalPrice().subtract(totalPriceVO.getTotalPrice()));
                }
                totalPriceVO.setDiscountInfo("\u6298\u6263\u91d1\u989d:" + totalPriceVO.getDiscountPrice());
            }
        } else if (promotionMix.getType().equals(CouponCategory.QUANTITY_PREFERENTIAL.toString()) && (promotionMixGoods = promotionMixGoodsList.stream().filter(p -> sellingStrategySid == p.getStrategySid()).findFirst()).isPresent() && LocalDateTime.now().isAfter(promotionMix.getBeginDate()) && LocalDateTime.now().isBefore(promotionMix.getEndDate())) {
            BigDecimal payPrice = promotionMixGoods.get().getPreferentialPrice().multiply(new BigDecimal(orderNumber));
            if ("CN".equals(this.envProperties.getArea())) {
                BigDecimal totalPrice = payPrice.compareTo(totalPriceVO.getOriginalPrice()) > 0 ? totalPriceVO.getOriginalPrice() : payPrice;
                totalPriceVO.setTotalPrice(totalPrice.setScale(4, 4));
                BigDecimal discountPrice = totalPriceVO.getOriginalPrice().compareTo(payPrice) > 0 ? totalPriceVO.getOriginalPrice().subtract(totalPriceVO.getTotalPrice()) : BigDecimal.ZERO;
                totalPriceVO.setDiscountPrice(discountPrice);
            } else {
                BigDecimal totalPrice = payPrice.compareTo(totalPriceVO.getOriginalPrice()) > 0 ? totalPriceVO.getOriginalPrice() : payPrice;
                totalPriceVO.setTotalPrice(totalPrice.setScale(0, 4));
                BigDecimal discountPrice = totalPriceVO.getOriginalPrice().compareTo(payPrice) > 0 ? totalPriceVO.getOriginalPrice().subtract(totalPriceVO.getTotalPrice()) : BigDecimal.ZERO;
                totalPriceVO.setDiscountPrice(discountPrice);
            }
            totalPriceVO.setDiscountInfo("\u6298\u6263\u91d1\u989d:" + totalPriceVO.getDiscountPrice());
        }
        return totalPriceVO;
    }

    public ShoppingCartPriceVO calculateDevShoppingCartPrice(ShoppingCartVO shoppingCartVO) {
        ShoppingCartPriceVO shoppingCartPriceVO = new ShoppingCartPriceVO();
        ArrayList goodsPriceDetails = new ArrayList();
        shoppingCartVO.getGoods().forEach(goodsInfo -> {
            Goods goods = this.goodsRepository.findBySid(goodsInfo.getGoodsSid());
            if (goods == null) {
                throw new BusinessException(String.format("\u5546\u54c1[%s]\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4!", goodsInfo.getGoodsSid()));
            }
            ShoppingCartPriceVO.GoodsPriceDetail goodsPriceDetail = new ShoppingCartPriceVO.GoodsPriceDetail();
            ArrayList sellingStrategyPrices = new ArrayList();
            goodsInfo.getSellingStrategys().forEach(sellingStrategyInfo -> {
                SellingStrategy sellingStrategy = (SellingStrategy)this.sellingStrategyCrudService.findBySid(sellingStrategyInfo.getSellingStrategySid());
                if (sellingStrategy == null) {
                    throw new BusinessException(String.format("\u9500\u552e\u65b9\u6848[%s]\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4!", sellingStrategyInfo.getSellingStrategySid()));
                }
                if (!Objects.equals(sellingStrategy.getGoodsCode(), goods.getCode())) {
                    this.cyberSecurityService.logSecurityError((Object)shoppingCartVO);
                    throw new BusinessException(String.format("\u9500\u552e\u65b9\u6848[%s]\u7684\u5546\u54c1\u7f16\u7801\u4e0e\u5546\u54c1[%s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u786e\u8ba4!", sellingStrategyInfo.getSellingStrategySid(), goodsInfo.getGoodsSid()));
                }
                TotalPriceVO sellingStrategyPriceDetail = new TotalPriceVO();
                List multipleItems = this.multipleItemRepository.findAllBySellingStrategySid(sellingStrategyInfo.getSellingStrategySid());
                if (multipleItems.isEmpty()) {
                    throw new BusinessException(String.format("\u9500\u552e\u65b9\u6848[%s]\u7684\u54c1\u53f7\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4!", sellingStrategyInfo.getSellingStrategySid()));
                }
                List multipleItemsVariable = multipleItems.stream().filter(m -> m.getApportionType().equals((Object)ApportionType.VARIABLECOST)).collect(Collectors.toList());
                BigDecimal sellingStrategyPrice = multipleItemsVariable.stream().map(MultipleItem::getStandardPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                List multipleItemsFixed = multipleItems.stream().filter(m -> m.getApportionType().equals((Object)ApportionType.FIXEDCOST)).collect(Collectors.toList());
                BigDecimal fixedPrice = multipleItemsFixed.stream().map(MultipleItem::getStandardPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (shoppingCartVO.getContractTenant().booleanValue() && GoodsCategoryEnum.isPromotionPrice((String)goods.getCategoryId())) {
                    sellingStrategyPrice = multipleItemsVariable.stream().map(MultipleItem::getContractPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    fixedPrice = multipleItemsFixed.stream().map(MultipleItem::getContractPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                BigDecimal totalPrice = null;
                if (goods.getPaymentType() == 1 && GoodsCategoryEnum.APP.id().equals(goods.getCategoryId())) {
                    PromotionMix promotionMix;
                    PackCalculateVO packCalculateVO;
                    if (goods.getPaymentType() == 1) {
                        packCalculateVO = new PackCalculateVO(fixedPrice, shoppingCartVO.getTenantId(), sellingStrategyInfo.getOrderNumber().intValue(), goodsInfo.getUserNumber().intValue(), goodsInfo.getCacUserNumber().intValue(), goods, sellingStrategy);
                        totalPrice = this.calculatePersonMonthPrice(packCalculateVO, sellingStrategyPriceDetail, multipleItems);
                    } else if (goods.getPaymentType() == 2 && GoodsCategoryEnum.APP.id().equals(goods.getCategoryId())) {
                        packCalculateVO = new PackCalculateVO(fixedPrice, shoppingCartVO.getTenantId(), sellingStrategyInfo.getOrderNumber().intValue(), sellingStrategyPrice, sellingStrategy.getPurchasePrice(), goods);
                        totalPrice = this.calculateCustomerUnitPrice(packCalculateVO);
                    } else {
                        totalPrice = sellingStrategyPrice.multiply(new BigDecimal(sellingStrategyInfo.getOrderNumber())).add(fixedPrice);
                    }
                    Coupon coupon = this.getCouponInfo(sellingStrategyInfo.getCouponSid(), sellingStrategyInfo.getCouponTypeSid(), goods.getCode(), (Object)shoppingCartVO);
                    sellingStrategyPriceDetail.setOriginalPrice(sellingStrategyPriceDetail.getTotalPrice());
                    sellingStrategyPriceDetail.setDiscountPrice(BigDecimal.ZERO);
                    sellingStrategyPriceDetail.setTotalPrice(totalPrice);
                    sellingStrategyPriceDetail.setOriginalPrice(totalPrice);
                    sellingStrategyPriceDetail.setDiscountPrice(BigDecimal.ZERO);
                    sellingStrategyPriceDetail.setSellingStrategySid(sellingStrategyInfo.getSellingStrategySid());
                    if (coupon != null) {
                        this.calculateDiscountPrice(coupon, sellingStrategyPriceDetail);
                        sellingStrategyPriceDetail.setDiscountInfo("\u6298\u6263\u91d1\u989d:" + sellingStrategyPriceDetail.getDiscountPrice());
                    } else if (sellingStrategyInfo.getPromotionMixSid() != null && (promotionMix = this.promotionMixRepository.findBySid(sellingStrategyInfo.getPromotionMixSid().longValue())) != null) {
                        this.calculateDiscountPrice(promotionMix, goods.getCode(), sellingStrategyInfo.getSellingStrategySid(), sellingStrategyPriceDetail, sellingStrategyInfo.getOrderNumber());
                    }
                    this.calculateItemTaxRate(sellingStrategyPriceDetail, goods.getWhetherTax().booleanValue(), multipleItems, shoppingCartVO.getContractTenant().booleanValue(), sellingStrategyInfo.getOrderNumber().intValue());
                    sellingStrategyPrices.add(sellingStrategyPriceDetail);
                } else {
                    PromotionMix promotionMix;
                    sellingStrategyPriceDetail.setSellingStrategySid(sellingStrategyInfo.getSellingStrategySid());
                    sellingStrategyPriceDetail.setTotalPrice(sellingStrategyPrice.multiply(new BigDecimal(sellingStrategyInfo.getOrderNumber())).add(fixedPrice));
                    Coupon coupon = this.getCouponInfo(sellingStrategyInfo.getCouponSid(), sellingStrategyInfo.getCouponTypeSid(), goods.getCode(), (Object)shoppingCartVO);
                    sellingStrategyPriceDetail.setOriginalPrice(sellingStrategyPriceDetail.getTotalPrice());
                    sellingStrategyPriceDetail.setDiscountPrice(BigDecimal.ZERO);
                    if (coupon != null) {
                        this.calculateDiscountPrice(coupon, sellingStrategyPriceDetail);
                        sellingStrategyPriceDetail.setDiscountInfo("\u6298\u6263\u91d1\u989d:" + sellingStrategyPriceDetail.getDiscountPrice());
                    } else if (sellingStrategyInfo.getPromotionMixSid() != null && (promotionMix = this.promotionMixRepository.findBySid(sellingStrategyInfo.getPromotionMixSid().longValue())) != null) {
                        this.calculateDiscountPrice(promotionMix, goods.getCode(), sellingStrategyInfo.getSellingStrategySid(), sellingStrategyPriceDetail, sellingStrategyInfo.getOrderNumber());
                    }
                    this.calculateItemTaxRate(sellingStrategyPriceDetail, goods.getWhetherTax().booleanValue(), multipleItems, shoppingCartVO.getContractTenant().booleanValue(), sellingStrategyInfo.getOrderNumber().intValue());
                    sellingStrategyPrices.add(sellingStrategyPriceDetail);
                }
            });
            goodsPriceDetail.setGoodsSid(goodsInfo.getGoodsSid());
            goodsPriceDetail.setSellingStrategyPrice(sellingStrategyPrices);
            goodsPriceDetail.setTotalPrice(sellingStrategyPrices.stream().map(TotalPriceVO::getOriginalPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
            goodsPriceDetail.setDiscountPrice(sellingStrategyPrices.stream().map(TotalPriceVO::getDiscountPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
            goodsPriceDetail.setPayPrice(sellingStrategyPrices.stream().map(TotalPriceVO::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
            goodsPriceDetails.add(goodsPriceDetail);
        });
        shoppingCartPriceVO.setGoodsPriceDetail(goodsPriceDetails);
        shoppingCartPriceVO.setTotalPrice(goodsPriceDetails.stream().map(ShoppingCartPriceVO.GoodsPriceDetail::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        shoppingCartPriceVO.setDiscountPrice(goodsPriceDetails.stream().map(ShoppingCartPriceVO.GoodsPriceDetail::getDiscountPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        shoppingCartPriceVO.setPayPrice(goodsPriceDetails.stream().map(ShoppingCartPriceVO.GoodsPriceDetail::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        return shoppingCartPriceVO;
    }

    private Coupon getCouponInfo(Long couponSid, Long couponTypeSid, String goodsCode, Object reqData) {
        CouponType couponType;
        if (null != couponSid) {
            Coupon coupon = (Coupon)this.couponCrudService.findBySid(couponSid.longValue());
            if (coupon != null) {
                this.checkCoupon(coupon, UserUtils.getTenantSid(), UserUtils.getUserSid(), goodsCode, reqData);
            }
            return coupon;
        }
        if (null != couponTypeSid && (couponType = (CouponType)this.couponTypeCrudService.findBySid(couponTypeSid.longValue())) != null) {
            return new Coupon(couponType);
        }
        return null;
    }

    private void checkCoupon(Coupon coupon, long tenantSid, long userSid, String goodsCode, Object reqData) {
        MyCoupon myCoupon = this.myCouponCrudService.findByTenantSidAndUserSidAndCouponSid(tenantSid, userSid, coupon.getSid());
        if (myCoupon == null) {
            this.cyberSecurityService.logSecurityError(reqData);
            throw new BusinessException(String.format("\u5f53\u524d\u79df\u6237[%s]\u4e0b\u7528\u6237[%s]\u672a\u9886\u53d6\u4f18\u60e0\u5238[%s]", tenantSid, userSid, coupon.getSid()));
        }
        if (!Objects.equals(UseStatus.UNUSED, myCoupon.getUseStatus())) {
            throw new BusinessException(String.format("\u5f53\u524d\u4f18\u60e0\u5238[%s]\u5df2\u4f7f\u7528", coupon.getSid()));
        }
        if (LocalDateTime.now().isBefore(coupon.getEffectiveDate())) {
            throw new BusinessException(String.format("\u5f53\u524d\u4f18\u60e0\u5238[%s]\u672a\u751f\u6548\uff0c\u751f\u6548\u65f6\u95f4\uff1a%s", coupon.getSid(), LocalDateTimeUtil.formatNormal((LocalDateTime)coupon.getEffectiveDate())));
        }
        if (LocalDateTime.now().isAfter(coupon.getExpiredDate())) {
            throw new BusinessException(String.format("\u5f53\u524d\u4f18\u60e0\u5238[%s]\u5df2\u8fc7\u671f\uff0c\u8fc7\u671f\u65f6\u95f4\uff1a%s", coupon.getSid(), LocalDateTimeUtil.formatNormal((LocalDateTime)coupon.getExpiredDate())));
        }
        List suitableGoods = this.couponRuleSuitableGoodsRepository.findByCouponRuleSid(coupon.getCouponRuleSid().longValue());
        boolean anyMatch = suitableGoods.stream().anyMatch(x -> "*".equals(x.getGoodsCode()));
        if (!anyMatch && suitableGoods.stream().noneMatch(x -> goodsCode.equals(x.getGoodsCode()))) {
            this.cyberSecurityService.logSecurityError(reqData);
            throw new BusinessException(String.format("\u5546\u54c1[%s]\u4e0d\u9002\u7528\u5f53\u524d\u4f18\u60e0\u5238[%s]", goodsCode, coupon.getSid()));
        }
    }
}

