/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.goods.impl;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.GmcConstant;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.gmc.constant.enums.GoodsTrialTypeEnum;
import com.digiwin.dap.middleware.gmc.constant.enums.MarketingConfigTypeEnum;
import com.digiwin.dap.middleware.gmc.constant.enums.NoticeTypeEnum;
import com.digiwin.dap.middleware.gmc.domain.CommonVO;
import com.digiwin.dap.middleware.gmc.domain.EnvProperties;
import com.digiwin.dap.middleware.gmc.domain.bundle.BundleGoodsVO;
import com.digiwin.dap.middleware.gmc.domain.goods.AthenaUrlSettingDTO;
import com.digiwin.dap.middleware.gmc.domain.goods.DeletePurchase;
import com.digiwin.dap.middleware.gmc.domain.goods.DeployGoodsInfo;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsAndLanguageVO;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsAttributes;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsBackUriVO;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsCloudWebsiteVO;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsLanguage;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsTrialTypeDTO;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsTrialTypeVO;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsVO;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsVO2;
import com.digiwin.dap.middleware.gmc.domain.goods.IndexGoodsVO;
import com.digiwin.dap.middleware.gmc.domain.goods.IndexSearchVO;
import com.digiwin.dap.middleware.gmc.domain.goods.SearchParamVO;
import com.digiwin.dap.middleware.gmc.domain.marketing.MarketingConfigDetailVO;
import com.digiwin.dap.middleware.gmc.domain.multilanguage.MultiLanguageQueryVO;
import com.digiwin.dap.middleware.gmc.domain.pack.ExperiencePackVO;
import com.digiwin.dap.middleware.gmc.domain.remote.AuthorizationVO;
import com.digiwin.dap.middleware.gmc.domain.remote.DevAction;
import com.digiwin.dap.middleware.gmc.domain.remote.DevActionVO;
import com.digiwin.dap.middleware.gmc.domain.remote.DevCondition;
import com.digiwin.dap.middleware.gmc.domain.remote.DevConditionVO;
import com.digiwin.dap.middleware.gmc.domain.remote.DevModule;
import com.digiwin.dap.middleware.gmc.domain.remote.DevModuleVO;
import com.digiwin.dap.middleware.gmc.domain.remote.DevSys;
import com.digiwin.dap.middleware.gmc.domain.remote.DevSysVO;
import com.digiwin.dap.middleware.gmc.domain.remote.PurchaseDetailVO;
import com.digiwin.dap.middleware.gmc.domain.remote.SysCascadeVO;
import com.digiwin.dap.middleware.gmc.domain.remote.SysFullInfoVO;
import com.digiwin.dap.middleware.gmc.domain.remote.UserVO;
import com.digiwin.dap.middleware.gmc.domain.sellingstrategy.ApportionType;
import com.digiwin.dap.middleware.gmc.domain.sellingstrategy.CustomAttributeVO;
import com.digiwin.dap.middleware.gmc.domain.sellingstrategy.SellingStrategyVO;
import com.digiwin.dap.middleware.gmc.entity.CloudMappingData;
import com.digiwin.dap.middleware.gmc.entity.ExperienceGoods;
import com.digiwin.dap.middleware.gmc.entity.Goods;
import com.digiwin.dap.middleware.gmc.entity.GoodsExtra;
import com.digiwin.dap.middleware.gmc.entity.MarketingConfig;
import com.digiwin.dap.middleware.gmc.entity.MultiLanguageResource;
import com.digiwin.dap.middleware.gmc.entity.MultipleItem;
import com.digiwin.dap.middleware.gmc.entity.Product;
import com.digiwin.dap.middleware.gmc.entity.SellingStrategy;
import com.digiwin.dap.middleware.gmc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.gmc.mapper.OrderMapper;
import com.digiwin.dap.middleware.gmc.mapper.SellingStrategyMapper;
import com.digiwin.dap.middleware.gmc.repository.CloudMappingRepository;
import com.digiwin.dap.middleware.gmc.repository.ExperienceGoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.GoodsCloudWebsiteRepository;
import com.digiwin.dap.middleware.gmc.repository.GoodsOnPlatformRepository;
import com.digiwin.dap.middleware.gmc.repository.GoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.MarketingConfigRepository;
import com.digiwin.dap.middleware.gmc.repository.MultiLanguageResourceRepository;
import com.digiwin.dap.middleware.gmc.repository.MultipleItemRepository;
import com.digiwin.dap.middleware.gmc.repository.PackDetailRepository;
import com.digiwin.dap.middleware.gmc.repository.ProductRepository;
import com.digiwin.dap.middleware.gmc.repository.SellingStrategyRepository;
import com.digiwin.dap.middleware.gmc.service.bundle.BundleService;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponQueryService;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsCrudService;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsMappingService;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsOnPlatformService;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsService;
import com.digiwin.dap.middleware.gmc.service.goods.SellingStrategyCrudService;
import com.digiwin.dap.middleware.gmc.service.goods.SellingStrategyService;
import com.digiwin.dap.middleware.gmc.service.goods.impl.GoodServiceImpl;
import com.digiwin.dap.middleware.gmc.service.goodsalias.GoodsAliasCrudService;
import com.digiwin.dap.middleware.gmc.service.goodsextra.GoodsExtraCrudService;
import com.digiwin.dap.middleware.gmc.service.marketing.MarketingConfigCrudService;
import com.digiwin.dap.middleware.gmc.service.multilanguageresource.LanguageService;
import com.digiwin.dap.middleware.gmc.service.multilanguageresource.MultiLanguageResourceQueryService;
import com.digiwin.dap.middleware.gmc.service.pack.ExperienceGoodsCrudService;
import com.digiwin.dap.middleware.gmc.service.pack.PackService;
import com.digiwin.dap.middleware.gmc.support.remote.CacService;
import com.digiwin.dap.middleware.gmc.support.remote.GmcService;
import com.digiwin.dap.middleware.gmc.support.remote.IamService;
import com.digiwin.dap.middleware.gmc.support.remote.MailService;
import com.digiwin.dap.middleware.gmc.support.remote.OmcService;
import com.digiwin.dap.middleware.gmc.support.remote.RemoteLMCService;
import com.digiwin.dap.middleware.gmc.support.stream.PutawayMessageService;
import com.digiwin.dap.middleware.gmc.util.SpringBeanUtils;
import com.digiwin.dap.middleware.language.service.LanguageCrudService;
import com.digiwin.dap.middleware.mybatis.pagehelper.CustomPageSettingsHolder;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageSerializable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class GoodServiceImpl
implements GoodsService {
    private static final Logger logger = LoggerFactory.getLogger(GoodServiceImpl.class);
    private static final ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    public static final String DEPLOY_DEFAULT_CODE = "_deploy_default";
    public static final String DAPLCDP_DEFAULT_CODE = "_daplcdp_default";
    private static final String ATHENA_LCDP_PM_EMAILS = "emmabi@digiwin.com";
    @Autowired
    private GoodsRepository goodsRepository;
    @Autowired
    private GoodsCrudService goodsCrudService;
    @Autowired
    private SellingStrategyService sellingStrategyService;
    @Autowired
    private SellingStrategyRepository sellingStrategyRepository;
    @Autowired
    private SellingStrategyCrudService sellingStrategyCrudService;
    @Autowired
    private IamService iamService;
    @Autowired
    private PutawayMessageService putawayMessageService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private SellingStrategyMapper sellingStrategyMapper;
    @Autowired
    private CouponQueryService couponQueryService;
    @Autowired
    private CacService cacService;
    @Autowired
    private MailService mailService;
    @Autowired
    private MultiLanguageResourceQueryService multiLanguageResourceQueryService;
    @Autowired
    private MultiLanguageResourceRepository multiLanguageResourceRepository;
    @Autowired
    private PackDetailRepository packDetailRepository;
    @Autowired
    private MultipleItemRepository multipleItemRepository;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private GoodsOnPlatformService goodsOnPlatformService;
    @Autowired
    private GoodsOnPlatformRepository goodsOnPlatformRepository;
    @Autowired
    private MarketingConfigRepository marketingConfigRepository;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private OmcService omcService;
    @Autowired
    private LanguageService languageService;
    @Autowired
    private RemoteLMCService remoteLMCService;
    @Autowired
    private GoodsMappingService goodsMappingService;
    @Autowired
    private GoodsAliasCrudService goodsAliasCrudService;
    @Autowired
    private LanguageCrudService languageCrudService;
    @Autowired
    private CloudMappingRepository cloudMappingRepository;
    @Autowired
    private PackService packService;
    @Autowired
    private ExperienceGoodsRepository experienceGoodsRepository;
    @Autowired
    private ExperienceGoodsCrudService experienceGoodsCrudService;
    @Autowired
    private BundleService bundleService;
    @Autowired
    private MarketingConfigCrudService marketingConfigCrudService;
    @Autowired
    private ProductRepository productRepository;
    @Autowired
    private GoodsExtraCrudService goodsExtraCrudService;
    @Autowired
    private GoodsCloudWebsiteRepository goodsCloudWebsiteRepository;

    private static String handleModule(String newModuleStr, String oldModuleStr) {
        try {
            List newModules = (List)objectMapper.readValue(newModuleStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            List oldModules = (List)objectMapper.readValue(oldModuleStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            List intersection = oldModules.stream().filter(newModules::contains).collect(Collectors.toList());
            return objectMapper.writeValueAsString(intersection);
        }
        catch (IOException iOException) {
            return "[]";
        }
    }

    public GoodsVO getGoodsInfoByCode(String code) {
        GoodsVO goodsVO = this.goodsMapper.selectGoodsByCode(code);
        if (goodsVO != null) {
            goodsVO.changeModulesAndCustomAttributeType();
            List mappings = this.goodsMappingService.getMappings(code);
            goodsVO.setMappings(mappings);
        }
        return goodsVO;
    }

    public GoodsVO getGoodsDetailByCode(String code, boolean isIncludeDealerSales, AuthoredUser authoredUser) {
        GoodsVO goodsVO = this.goodsMapper.selectGoodsByCode(code);
        if (goodsVO != null) {
            GoodsExtra goodsExtra = this.goodsExtraCrudService.findByGoodsCode(code);
            goodsVO.fromExtra(goodsExtra);
            goodsVO.changeModulesAndCustomAttributeType();
            List sellingStrategyVOS = this.sellingStrategyService.getSellingStrategyList(code, isIncludeDealerSales);
            sellingStrategyVOS.forEach(SellingStrategyVO::changeModulesAndCustomAttributeType);
            goodsVO.setSellingStrategys(sellingStrategyVOS);
            List goodsCanUseCouponVOS = new ArrayList();
            goodsCanUseCouponVOS = authoredUser == null ? this.couponQueryService.getGoodsCanUseCoupon(0L, 0L, goodsVO.getCategoryId(), code) : this.couponQueryService.getGoodsCanUseCoupon(authoredUser.getTenantSid(), authoredUser.getSid(), goodsVO.getCategoryId(), code);
            goodsVO.setGoodsCanUseCoupons(goodsCanUseCouponVOS);
            List mappings = this.goodsMappingService.getMappings(code);
            goodsVO.setMappings(mappings);
            BundleGoodsVO bundleGoodsVO = new BundleGoodsVO();
            bundleGoodsVO.setChildGoodsCode(code);
            List listReverse = this.bundleService.findListReverse(bundleGoodsVO);
            goodsVO.setBundleChildApp(Boolean.valueOf(!CollectionUtils.isEmpty((Collection)listReverse)));
            List goodsCloudWebSites = this.goodsCloudWebsiteRepository.findByGoodsCode(code);
            ArrayList goodsCloudWebsiteVOS = new ArrayList();
            goodsCloudWebSites.forEach(w -> {
                GoodsCloudWebsiteVO cloudWebsiteVO = new GoodsCloudWebsiteVO();
                BeanUtils.copyProperties((Object)w, (Object)cloudWebsiteVO);
                goodsCloudWebsiteVOS.add(cloudWebsiteVO);
            });
            goodsVO.setCloudWebsiteVOS(goodsCloudWebsiteVOS);
        }
        return goodsVO;
    }

    public GoodsVO getGoodsDetailBySid(Long sid, boolean isIncludeDealerSales, AuthoredUser authoredUser) {
        GoodsVO goodsVO = this.goodsMapper.selectGoodsBySid(sid);
        if (goodsVO != null) {
            String code = goodsVO.getCode();
            goodsVO.changeModulesAndCustomAttributeType();
            List sellingStrategyVOS = this.sellingStrategyService.getSellingStrategyList(code, isIncludeDealerSales);
            sellingStrategyVOS.forEach(SellingStrategyVO::changeModulesAndCustomAttributeType);
            goodsVO.setSellingStrategys(sellingStrategyVOS);
            List goodsCanUseCouponVOS = new ArrayList();
            goodsCanUseCouponVOS = authoredUser == null ? this.couponQueryService.getGoodsCanUseCoupon(0L, 0L, goodsVO.getCategoryId(), code) : this.couponQueryService.getGoodsCanUseCoupon(authoredUser.getTenantSid(), authoredUser.getSid(), goodsVO.getCategoryId(), code);
            goodsVO.setGoodsCanUseCoupons(goodsCanUseCouponVOS);
            List mappings = this.goodsMappingService.getMappings(code);
            goodsVO.setMappings(mappings);
        }
        return goodsVO;
    }

    public PageSerializable<GoodsVO> getGoodsDetails(SearchParamVO searchParamVO, int pageNum, int pageSize, String orderBy) {
        CustomPageSettingsHolder.commonOptimize((Integer)pageSize);
        List goodsVOS = this.goodsMapper.findGoods(searchParamVO, pageNum, pageSize, orderBy);
        if (CollectionUtils.isEmpty((Collection)goodsVOS)) {
            return new PageSerializable(goodsVOS);
        }
        return new PageSerializable(this.generateGoodsVOWithSellingStrategy(goodsVOS));
    }

    public PageSerializable<GoodsVO> getGoodsDetailsWithoutDataPolicy(SearchParamVO searchParamVO, int pageNum, int pageSize, String orderBy) {
        List goodsVOS = this.goodsMapper.findGoodsWithoutDataPolicy(searchParamVO, pageNum, pageSize, orderBy);
        return new PageSerializable(this.generateGoodsVOWithSellingStrategy(goodsVOS));
    }

    public List<GoodsVO> getGoodsByCondition(SearchParamVO searchParamVO, int pageNum, int pageSize, String orderBy) {
        List goodsVOS = this.goodsMapper.findGoodsCondition(searchParamVO, pageNum, pageSize, orderBy);
        this.generateGoodsVOWithSellingStrategy(goodsVOS);
        return goodsVOS;
    }

    public List<GoodsVO2> listGoodsSimpleInfo(SearchParamVO searchParamVO) {
        return this.goodsMapper.listGoodsSimpleInfo(searchParamVO);
    }

    public PageSerializable getAuthorizationGoodsList(int pageNum, int pageSize, String orderBy, String goodsContent) {
        List goodsVOs = this.goodsMapper.findAuthorizationGoods(pageNum, pageSize, orderBy, goodsContent);
        List codes = goodsVOs.stream().map(GoodsVO::getCode).collect(Collectors.toList());
        if (codes.size() > 0) {
            List sellingStrategyVOList = this.sellingStrategyMapper.findAuthorizationSellingStrategys(codes);
            goodsVOs.forEach(goodsVO -> {
                if (goodsVO.getSellingStrategys() == null) {
                    goodsVO.setSellingStrategys(new ArrayList());
                }
                sellingStrategyVOList.forEach(sellingStrategyVO -> {
                    if (sellingStrategyVO.getGoodsCode().equals(goodsVO.getCode())) {
                        if (goodsVO.getEquip().booleanValue() || "device".equals(goodsVO.getCategoryId())) {
                            if (sellingStrategyVO.getUseCount() == 1L) {
                                goodsVO.getSellingStrategys().add(sellingStrategyVO);
                            }
                        } else {
                            goodsVO.getSellingStrategys().add(sellingStrategyVO);
                        }
                    }
                });
            });
        }
        return new PageSerializable(goodsVOs);
    }

    public List<SellingStrategyVO> getAuthorizationGoodsDealerSellingStrategy(String goodsCode) {
        List sellingStrategyList = this.sellingStrategyRepository.findAllByGoodsCodeAndDealer(goodsCode, true);
        ArrayList<SellingStrategyVO> sellingStrategyVOList = new ArrayList<SellingStrategyVO>();
        sellingStrategyList.stream().forEach(sellingStrategy -> {
            SellingStrategyVO sellingStrategyVO = new SellingStrategyVO();
            sellingStrategyVO.setId(Long.valueOf(sellingStrategy.getSid()));
            sellingStrategyVO.setCode(sellingStrategy.getCode());
            sellingStrategyVO.setName(sellingStrategy.getName());
            sellingStrategyVOList.add(sellingStrategyVO);
        });
        return sellingStrategyVOList;
    }

    public List<GoodsVO> getGoodsList(GmcConstant.GoodsStatus onSale, boolean containSellingStrategy, Boolean isIncludeDealerSales) {
        List goodsVOList;
        SearchParamVO paramVO = new SearchParamVO();
        if (GmcConstant.GoodsStatus.OnSale.equals((Object)onSale)) {
            paramVO.setOnSaleStatus(Integer.valueOf(onSale.ordinal()));
        }
        if ((goodsVOList = this.goodsMapper.selectGoodsVOExcludeLargeFields(paramVO)).isEmpty()) {
            return Collections.emptyList();
        }
        List goodsCodes = goodsVOList.stream().map(GoodsVO::getCode).collect(Collectors.toList());
        List goodsMultiLanguageVOList = this.multiLanguageResourceQueryService.getGoodsMultiLanguageVOs(goodsCodes);
        Map<String, MultiLanguageQueryVO> goodsMultiLanguageMap = goodsMultiLanguageVOList.stream().collect(Collectors.toMap(MultiLanguageQueryVO::getId, v -> v, (k1, k2) -> k1));
        goodsVOList.forEach(vo -> {
            Optional.ofNullable(goodsMultiLanguageMap.get(vo.getCode())).map(MultiLanguageQueryVO::getContents).orElse(Collections.emptyList()).forEach(content -> {
                if ("goodsName".equals(content.getFieldName())) {
                    vo.setDisplayName(content.getContent());
                } else if ("customunit".equals(content.getFieldName())) {
                    vo.setCustomUnit(content.getContent());
                }
            });
            vo.changeModulesAndCustomAttributeType();
            vo.setAdminEmails("");
            vo.setPmEmails("");
            vo.setEditTime(null);
            vo.setEditUser(null);
            vo.setCreateUser(null);
            vo.setCreateTime(null);
        });
        if (!containSellingStrategy) {
            return goodsVOList;
        }
        List sellingStrategyVOList = this.sellingStrategyService.getSellingStrategyList(goodsCodes, true);
        if (sellingStrategyVOList.isEmpty()) {
            return goodsVOList;
        }
        List sellingSids = sellingStrategyVOList.stream().map(SellingStrategyVO::getId).collect(Collectors.toList());
        List strategyMultiLanguageVOList = this.multiLanguageResourceQueryService.getSellingStrategyMultiLanguageVOs(sellingSids);
        Map<Long, MultiLanguageQueryVO> strategyMultiLanguageMap = strategyMultiLanguageVOList.stream().collect(Collectors.toMap(MultiLanguageQueryVO::getDataSid, v -> v, (k1, k2) -> k1));
        ArrayList dealerSellingStrategyVOList = new ArrayList();
        sellingStrategyVOList.forEach(vo -> {
            vo.changeModulesAndCustomAttributeType();
            if (!Boolean.TRUE.equals(isIncludeDealerSales)) {
                if (!Boolean.TRUE.equals(vo.getDealer())) {
                    this.setSellingNameResource(strategyMultiLanguageMap, vo);
                    vo.setCreateById("");
                    vo.setCreateDate(null);
                    vo.setModifyById("");
                    vo.setModifyDate(null);
                    vo.setCustomerServicesInfo("");
                    dealerSellingStrategyVOList.add(vo);
                }
            } else {
                this.setSellingNameResource(strategyMultiLanguageMap, vo);
                vo.setCreateById("");
                vo.setCreateDate(null);
                vo.setModifyById("");
                vo.setModifyDate(null);
                vo.setCustomerServicesInfo("");
                dealerSellingStrategyVOList.add(vo);
            }
        });
        Map<String, List<SellingStrategyVO>> sellingStrategyVOMap = dealerSellingStrategyVOList.stream().collect(Collectors.groupingBy(SellingStrategyVO::getGoodsCode));
        goodsVOList.forEach(goodsVO -> goodsVO.setSellingStrategys(sellingStrategyVOMap.getOrDefault(goodsVO.getCode(), Collections.emptyList())));
        return goodsVOList;
    }

    private void setSellingNameResource(Map<Long, MultiLanguageQueryVO> map, SellingStrategyVO vo) {
        Optional.ofNullable(map.get(vo.getId())).map(MultiLanguageQueryVO::getContents).orElse(Collections.emptyList()).forEach(dataVO -> {
            if ("sellingstrategyName".equals(dataVO.getFieldName())) {
                vo.setName(dataVO.getContent());
            }
        });
    }

    public void updateOnSaleStatus(GoodsVO goodsVO, int onSale) {
        String[] split;
        if (goodsVO.getCategoryId().equals("pack")) {
            goodsVO.setCategoryName("\u7ec4\u5408\u5546\u54c1");
        }
        if (goodsVO.getPaymentType() == 2 && ("app".equalsIgnoreCase(goodsVO.getCategoryId()) || "device".equalsIgnoreCase(goodsVO.getCategoryId())) && goodsVO.getPaymentTypeName() != null && (split = goodsVO.getPaymentTypeName().split("/")).length == 2) {
            goodsVO.setPaymentTypeName(goodsVO.getCustomUnit() + "/" + split[1]);
        }
        this.checkPackGoods(goodsVO, onSale);
        if (onSale == GmcConstant.GoodsStatus.OnSale.ordinal()) {
            if (GoodsCategoryEnum.isApp((String)goodsVO.getCategoryId())) {
                goodsVO.changeModulesAndCustomAttributeType();
                List resources = this.multiLanguageResourceRepository.findByDataSidAndFieldName(goodsVO.getId().longValue(), "modules");
                this.iamService.addDefaultApp(goodsVO, resources, "");
                this.iamService.updateBackUri(goodsVO);
                this.goodsMappingService.syncMappings(goodsVO.getCode(), goodsVO.getDisplayName());
            }
            this.goodsRepository.updateOnSale(onSale, goodsVO.getCode());
            goodsVO.changeModulesAndCustomAttributeType();
            this.putawayMessageService.send(goodsVO, NoticeTypeEnum.GMC_GOODS_SHELVE_PASS.name());
        } else {
            if (onSale == GmcConstant.GoodsStatus.Audit.ordinal()) {
                goodsVO.changeModulesAndCustomAttributeType();
                if (!StringUtils.isEmpty((Object)goodsVO.getServicerId())) {
                    goodsVO.setCategoryId("isv");
                    goodsVO.setCategoryName("\u670d\u52a1\u5546\u5546\u54c1");
                }
                this.putawayMessageService.send(goodsVO, NoticeTypeEnum.GMC_GOODS_SHELVE.name());
            }
            this.goodsRepository.updateOnSale(onSale, goodsVO.getCode());
        }
    }

    private void checkPackGoods(GoodsVO goodsVO, int onSale) {
        List packDetails;
        if (GoodsCategoryEnum.PACK.id().equals(goodsVO.getCategoryId()) && (onSale == GmcConstant.GoodsStatus.OnSale.ordinal() || onSale == GmcConstant.GoodsStatus.Audit.ordinal()) && !(packDetails = this.packDetailRepository.findByPackSid(goodsVO.getId())).isEmpty()) {
            packDetails.forEach(p -> {
                Goods packGoods = (Goods)this.goodsCrudService.findBySid(p.getGoodsSid().longValue());
                if (GmcConstant.GoodsStatus.OnSale.ordinal() != packGoods.getOnSale().intValue()) {
                    throw new BusinessException((ErrorHandler)I18nError.GOODS_ONSALE_PACKAGE_GOODS_ERROR, new Object[]{packGoods.getDisplayName()});
                }
                SellingStrategy packStrategy = (SellingStrategy)this.sellingStrategyCrudService.findBySid(p.getStrategySid().longValue());
                if (Boolean.TRUE.equals(goodsVO.getMarket()) && !Boolean.TRUE.equals(packStrategy.getEnable())) {
                    throw new BusinessException((ErrorHandler)I18nError.GOODS_ONSALE_PACKAGE_STRATEGY_ERROR, new Object[]{packGoods.getDisplayName(), packStrategy.getName()});
                }
            });
        }
    }

    @Transactional
    public void updateCustomAttributes(String code, List<CustomAttributeVO> customAttributes) {
        try {
            this.updateStrategyCustomAttributes(code, customAttributes);
            this.goodsRepository.updateCustomAttributes(code, JsonUtils.createObjectMapper().writeValueAsString(customAttributes));
        }
        catch (JsonProcessingException e) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u81ea\u5b9a\u4e49\u5c5e\u6027\u89e3\u6790\u5f02\u5e38");
        }
    }

    private void updateStrategyCustomAttributes(String code, List<CustomAttributeVO> customAttributes) throws JsonProcessingException {
        List exist = this.getCustomAttributeVOS(code);
        Set nowIds = customAttributes.stream().map(CustomAttributeVO::getId).collect(Collectors.toSet());
        List deletedIds = exist.stream().map(CustomAttributeVO::getId).filter(id -> !nowIds.contains(id)).collect(Collectors.toList());
        if (!deletedIds.isEmpty()) {
            List sellingStrategies = this.sellingStrategyRepository.findAllByGoodsCode(code);
            ArrayList<SellingStrategy> changed = new ArrayList<SellingStrategy>();
            for (SellingStrategy sellingStrategy : sellingStrategies) {
                String customAttributesStr = sellingStrategy.getCustomAttributes();
                List customAttributeVOS = (List)JsonUtils.createObjectMapper().readValue(customAttributesStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                if (!customAttributeVOS.removeIf(attr -> deletedIds.contains(attr.getId()))) continue;
                sellingStrategy.setCustomAttributes(JsonUtils.createObjectMapper().writeValueAsString((Object)customAttributeVOS));
                changed.add(sellingStrategy);
            }
            this.sellingStrategyCrudService.updateAll(changed);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void cascadeDeleteGoods(String code) {
        Goods goods = this.goodsRepository.findByCode(code);
        if (goods != null) {
            this.packService.checkDeletablePackGoods(Long.valueOf(goods.getSid()));
            this.packService.checkDeletableResourceGoods(goods.getCategoryId(), goods.getCode(), true);
            this.goodsCrudService.deleteByCode(code);
            List sellingStrategies = this.sellingStrategyRepository.findAllByGoodsCode(code);
            sellingStrategies.forEach(sellingStrategy -> this.sellingStrategyCrudService.deleteByCode(sellingStrategy.getCode()));
            this.goodsAliasCrudService.deleteByCodesCode(code);
            this.languageCrudService.deleteByDataSid(goods.getSid());
            this.goodsOnPlatformRepository.deleteByCode(code);
            this.marketingConfigRepository.deleteMarketingConfigByMainGoodsCode(code);
            this.cloudMappingRepository.deleteByGoodsCode(code);
        }
    }

    public PageSerializable<PurchaseDetailVO> generalAuthExpireGoods(PageSerializable<PurchaseDetailVO> willExpiredApps) {
        if (CollectionUtils.isEmpty((Collection)willExpiredApps.getList())) {
            return PageSerializable.of(Collections.emptyList());
        }
        List tenantIds = willExpiredApps.getList().stream().map(PurchaseDetailVO::getTenantId).collect(Collectors.toList());
        List commonVOS = this.iamService.getTenantSimples(tenantIds);
        SearchParamVO searchParamVO = new SearchParamVO();
        searchParamVO.setGoodsCodeList(willExpiredApps.getList().stream().map(PurchaseDetailVO::getGoodsCode).collect(Collectors.toList()));
        List goodsVOList = this.goodsMapper.selectGoodsVOExcludeLargeFields(searchParamVO);
        List strategySids = willExpiredApps.getList().stream().map(PurchaseDetailVO::getStrategySid).collect(Collectors.toList());
        List sellingStrategies = this.sellingStrategyRepository.findAllById(strategySids);
        willExpiredApps.getList().forEach(vo -> {
            commonVOS.stream().filter(t -> vo.getTenantId().equals(t.getId())).findFirst().ifPresent(x -> vo.setPotentialCustomerId(x.getPotentialCustomerId()));
            GoodsVO goodsVO = goodsVOList.stream().filter(g -> g.getCode().equals(vo.getGoodsCode())).findFirst().orElse(null);
            if (goodsVO == null) {
                return;
            }
            vo.setGoodsName(goodsVO.getDisplayName());
            vo.setPaymentTypeName(goodsVO.getPaymentTypeName());
            vo.setPaymentType(goodsVO.getPaymentType());
            vo.setCustomUnit(goodsVO.getCustomUnit());
            vo.setProductCode(goodsVO.getProductCode());
            vo.setProductName(goodsVO.getProductName());
            if (goodsVO.getPaymentType() == 1) {
                vo.setCount(vo.getTotalCount().toString());
            } else if (goodsVO.getPaymentType() == 2) {
                vo.setCount(vo.getTotalUsage().toString());
            } else {
                vo.setCount("\u221e");
            }
            long remainingDays = ChronoUnit.DAYS.between(LocalDateTime.now(), vo.getExpiredTime());
            vo.setRemainingDays(Long.valueOf(remainingDays));
            sellingStrategies.stream().filter(s -> s.getSid() == vo.getStrategySid().longValue()).findFirst().ifPresent(x -> vo.setSellingStrategyName(x.getName()));
        });
        return willExpiredApps;
    }

    public PageSerializable getOnSaleGoodsWithSellingStratery(String searchContent, Boolean isIncludeDealerSales, int pageNum, int pageSize, String orderBy) {
        List contents = Arrays.asList(searchContent.split(" ")).stream().filter(str -> str.length() > 1).collect(Collectors.toList());
        List goodsVOList = this.goodsMapper.findOnSalesGoods(contents, pageNum, pageSize, orderBy);
        List goodsVOListWithSellingStratery = this.generateGoodsVOWithSellingStrategy(goodsVOList);
        for (int i = goodsVOListWithSellingStratery.size() - 1; i >= 0; --i) {
            boolean isDeleted = true;
            List sellingStrategyVOList = ((GoodsVO)goodsVOList.get(i)).getSellingStrategys();
            for (int j = sellingStrategyVOList.size() - 1; j >= 0; --j) {
                if (!((SellingStrategyVO)sellingStrategyVOList.get(j)).getDealer().booleanValue()) {
                    isDeleted = false;
                    continue;
                }
                if (isIncludeDealerSales.booleanValue()) continue;
                sellingStrategyVOList.remove(j);
            }
            if (!isDeleted) continue;
            goodsVOList.remove(i);
        }
        List packGoods = this.goodsMapper.findPackGoods(contents);
        goodsVOListWithSellingStratery.addAll(packGoods);
        PageSerializable pageResult = new PageSerializable(goodsVOListWithSellingStratery);
        pageResult.setTotal((long)goodsVOListWithSellingStratery.size());
        return pageResult;
    }

    private List<GoodsVO> generateGoodsVOWithSellingStrategy(List<GoodsVO> goodsVOList) {
        if (CollectionUtils.isEmpty(goodsVOList)) {
            return goodsVOList;
        }
        List goodsCodeList = goodsVOList.stream().map(GoodsVO::getCode).collect(Collectors.toList());
        List sellingStrategyVOList = this.sellingStrategyService.getSellingStrategyList(goodsCodeList, true);
        sellingStrategyVOList.forEach(SellingStrategyVO::changeModulesAndCustomAttributeType);
        Map<String, List<SellingStrategyVO>> sellingStrategyVOMap = sellingStrategyVOList.stream().collect(Collectors.groupingBy(SellingStrategyVO::getGoodsCode));
        goodsVOList.forEach(goodsVO -> {
            goodsVO.changeModulesAndCustomAttributeType();
            goodsVO.setSellingStrategys(sellingStrategyVOMap.getOrDefault(goodsVO.getCode(), Collections.emptyList()));
        });
        return goodsVOList;
    }

    public Map<String, String> getBackUri(List<String> goodsCodes) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(goodsCodes)) {
            List goodsBackUriVOS = this.goodsMapper.getBackUriByGoodsCodes(goodsCodes);
            for (GoodsBackUriVO goodsBackUriVO : goodsBackUriVOS) {
                map.put(goodsBackUriVO.getGoodsCode(), goodsBackUriVO.getBackUri());
            }
        }
        return map;
    }

    public void deployGoods(DeployGoodsInfo deployGoodsInfo) {
        SysFullInfoVO result = this.iamService.getDevSysFullInfo(deployGoodsInfo.getSysId(), deployGoodsInfo.getSourceIamUri());
        if (result == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, " \u67e5\u8be2\u6570\u636e\u4e3a\u7a7a, sysId : " + deployGoodsInfo.getSysId());
        }
        logger.info(String.format("\u5f00\u59cb\u90e8\u7f72%s\u533a\u57df", deployGoodsInfo.getCloud()));
        deployGoodsInfo.setSysFullInfoVO(result);
        this.setDefaultProductCode(deployGoodsInfo);
        logger.info("\u5b9a\u4f4d\u95ee\u9898\uff0c\u5165\u53c2\uff1a{}", (Object)JsonUtils.objToJson((Object)deployGoodsInfo));
        if (deployGoodsInfo.isOther().booleanValue()) {
            this.gmcService.autoCreateOrUpdateGoods(deployGoodsInfo);
        } else {
            this.createOrUpdateGoods(deployGoodsInfo, Boolean.valueOf(false));
        }
    }

    private List createOrUpdateGoods(DeployGoodsInfo deployGoodsInfo, Boolean isTest) {
        logger.info(" sysId : [{}] ", (Object)deployGoodsInfo.getSysId());
        String sysId = deployGoodsInfo.getSysId();
        if (deployGoodsInfo.getSysFullInfoVO() == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, " \u67e5\u8be2\u6570\u636e\u4e3a\u7a7a, sysId : " + sysId);
        }
        DevSys sys = deployGoodsInfo.getSysFullInfoVO().getDevSys();
        if (sys == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, " \u67e5\u8be2sys\u5e94\u7528\u6570\u636e\u4e3a\u7a7a, sysId : " + sysId);
        }
        String token = deployGoodsInfo.getSysFullInfoVO().getAppToken();
        if (StringUtils.isEmpty((Object)token)) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, " \u67e5\u8be2\u5e94\u7528token\u4e3a\u7a7a, sysId : " + sysId);
        }
        List modules = deployGoodsInfo.getSysFullInfoVO().getModules();
        List actions = deployGoodsInfo.getSysFullInfoVO().getActions();
        List conditions = deployGoodsInfo.getSysFullInfoVO().getConditions();
        Goods goods = this.goodsRepository.findByCode(sysId);
        String module = "";
        if (goods == null) {
            logger.warn(" goods [{}] not exists , execute insert.", (Object)sysId);
            sys.setMultiLogin(true);
            module = this.buildGoodsModules(sys, modules, actions, conditions, token, Integer.valueOf(1));
            String pmEmails = this.getPmEmails(deployGoodsInfo.getPmEmails());
            goods = this.buildGoods(sys, deployGoodsInfo.getCloud(), deployGoodsInfo.getAppCloudUrl(), isTest, pmEmails, deployGoodsInfo.getSourceCloud(), deployGoodsInfo.getSourceArea(), deployGoodsInfo);
        } else {
            sys.setMultiLogin(goods.getMultiLogin().booleanValue());
            module = null != sys.getSysCategory() && 1 != sys.getSysCategory() ? this.buildGoodsModules(sys, modules, actions, conditions, token, Integer.valueOf(1)) : goods.getModules();
            if (module.equals(goods.getModules())) {
                logger.warn(" goods module info has no different, stop update goods info .");
                return null;
            }
            EntityUtils.setModifyFields((BaseEntity)goods);
        }
        goods.setModules(module);
        goods = (Goods)this.goodsRepository.saveAndFlush((Object)goods);
        logger.info(" goods sid : [{}] ", (Object)goods.getSid());
        this.buildMultiLanguage(Long.valueOf(goods.getSid()), sys, modules, actions, conditions, token, module);
        List moduleArray = (List)((Map)JsonUtils.readValue((String)module, Map.class)).get("modules");
        this.buildSellingStrategy(goods, sys, JsonUtils.writeValue((Object)moduleArray), "_deploy_default", deployGoodsInfo);
        GoodsVO goodsVO = new GoodsVO(goods, deployGoodsInfo);
        goodsVO.setModules(JsonUtils.readValue((String)module, Object.class));
        List resources = this.multiLanguageResourceRepository.findByDataSidAndFieldName(goods.getSid(), "modules");
        Long iamStart = System.currentTimeMillis();
        this.iamService.addDefaultApp(goodsVO, resources, deployGoodsInfo.getSourceIamUri());
        this.iamService.updateBackUri(goodsVO);
        this.goodsMappingService.syncMappings(goodsVO.getCode(), goodsVO.getDisplayName());
        Long iamEnd = System.currentTimeMillis();
        logger.info(" \u8c03\u7528iam \u63a5\u53e3\u8017\u65f6 \uff1a[{}] ", (Object)(iamEnd - iamStart));
        if (CollectionUtils.isEmpty((Collection)modules)) {
            logger.warn(" modules is null , stop invoke cac interface !");
        }
        if (null != sys.getSysCategory() && 1 == sys.getSysCategory()) {
            this.saveAthenaDefaultStrategyMarketConfig(sys.getId(), "Athena");
        } else {
            this.deleteAthenaDefaultStrategyMarketConfig(sys.getId(), "Athena");
        }
        return moduleArray;
    }

    public void autoCreateOrUpdateGoodsForOther(DeployGoodsInfo deployGoodsInfo) {
        this.createOrUpdateGoods(deployGoodsInfo, Boolean.valueOf(true));
    }

    public void deleteServicerGoodsByCode(String code) {
        Goods goods = this.goodsRepository.findByCode(code);
        if (goods == null) {
            return;
        }
        if (StringUtils.isEmpty((Object)goods.getDevId()) || StringUtils.isEmpty((Object)goods.getServicerId())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GOODS_DEV_RELATION_ISV, new Object[]{code});
        }
        if (this.orderMapper.existsOrderByGoodsCode(code)) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GOODS_ORDERS_EXISTED, new Object[]{code});
        }
        goods.setServicerId(null);
        goods.setServicerName(null);
        EntityUtils.setModifyFields((BaseEntity)goods);
        this.goodsRepository.save((Object)goods);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deletePurchase(DeletePurchase body) {
        Goods goods = this.goodsRepository.findByCode(body.getGoodsCode());
        if (goods != null) {
            int oldPaymentType = goods.getPaymentType();
            this.sellingStrategyRepository.deleteByGoodsCode(goods.getCode());
            goods.setPaymentType(body.getPaymentType());
            this.goodsRepository.save((Object)goods);
            this.cacService.removeGoods(body.getGoodsCode());
            this.mailService.sendChangePaymentType(goods, oldPaymentType, body.getPaymentType().intValue());
        }
    }

    private void buildSellingStrategy(Goods goods, DevSys sys, String modules, String codeSuffix, DeployGoodsInfo deployGoodsInfo) {
        String goodsCode = goods.getCode();
        Long dataSid = goods.getSid();
        String sellingStrategyCode = goodsCode;
        SellingStrategy sale = this.sellingStrategyRepository.getByCode(sellingStrategyCode);
        if (null == sale) {
            sellingStrategyCode = sys.getId() + codeSuffix;
            sale = this.sellingStrategyRepository.getByCode(sellingStrategyCode);
        }
        if (sale != null) {
            logger.info(" goodsCode : [{}] , salesGoodsCode : [{}]", (Object)goods.getCode(), (Object)sale.getGoodsCode());
            if (null != goods.getCode() && !goods.getCode().equals(sale.getGoodsCode())) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_SELLING_STRATEGY_AUTO_CREATE);
            }
            modules = GoodServiceImpl.handleModule((String)modules, (String)sale.getEnabledModules());
            this.sellingStrategyRepository.deleteByCodeAndGoodsCode(sellingStrategyCode, goodsCode);
            this.sellingStrategyRepository.flush();
            this.multipleItemRepository.deleteBySellingStrategySid(sale.getSid());
            this.multipleItemRepository.flush();
        }
        sale = new SellingStrategy();
        sale.setCode(sellingStrategyCode);
        sale.setGoodsCode(goods.getCode());
        if ("_daplcdp_default".equals(codeSuffix)) {
            sale.setName("\u4f4e\u4ee3\u7801\u8bbe\u8ba1\u5e73\u53f0\u9884\u8bbe\u9500\u552e\u65b9\u6848");
            sale.setUsersNumber(Optional.ofNullable(deployGoodsInfo.getUsersNumber()).orElse(50L));
            sale.setTenancyPeriod(Optional.ofNullable(deployGoodsInfo.getTenancyPeriod()).orElse(12L));
        } else {
            sale.setName("\u90e8\u7f72\u9810\u8a2d\u65b9\u6848");
            sale.setUsersNumber(Long.valueOf(5L));
            sale.setTenancyPeriod(Long.valueOf(999L));
        }
        sale.setInfinity(Boolean.valueOf(true));
        sale.setLimitPurchaseQuantity(Long.valueOf(9999L));
        sale.setSortNumber(Long.valueOf(999L));
        sale.setEnable(Boolean.valueOf(true));
        sale.setPrice(BigDecimal.ZERO);
        sale.setEnabledModules(modules);
        sale.setDealer(Boolean.valueOf(false));
        sale.setAdvisory(Boolean.valueOf(false));
        sale.setContractDate(Boolean.valueOf(false));
        sale.setMainPush(Boolean.valueOf(false));
        sale.setUseCount(Long.valueOf(-1L));
        sale.setTrialDays(Long.valueOf(0L));
        sale.setPromotionPrice(BigDecimal.ZERO);
        sale.setOriginalPrice(BigDecimal.ZERO);
        sale.setLimitUsersNumber(Boolean.valueOf(false));
        sale.setExperienceScheme(Boolean.valueOf(false));
        sale.setBeta(Boolean.valueOf(false));
        this.sellingStrategyRepository.save((Object)sale);
        logger.info(" sellingStrategyCode : [{}] ", (Object)sale.getCode());
        ArrayList<MultiLanguageResource> sellMultiInfo = new ArrayList<MultiLanguageResource>();
        sellMultiInfo.add(new MultiLanguageResource(dataSid.longValue(), "sellingstrategyName", sys.getNameCN(), "zh-CN"));
        sellMultiInfo.add(new MultiLanguageResource(dataSid.longValue(), "sellingstrategyName", sys.getNameTW(), "zh-TW"));
        sellMultiInfo.add(new MultiLanguageResource(dataSid.longValue(), "sellingstrategyName", sys.getNameUS(), "en-US"));
        this.multiLanguageResourceRepository.saveAll(sellMultiInfo);
        MultipleItem multipleItem = new MultipleItem();
        multipleItem.setSellingStrategySid(Long.valueOf(sale.getSid()));
        multipleItem.setItemCode(goodsCode);
        multipleItem.setItemName(goods.getDisplayName());
        multipleItem.setApportionType(ApportionType.VARIABLECOST);
        multipleItem.setQuantity(Integer.valueOf(1));
        multipleItem.setUnit("\u5355\u4f4d");
        multipleItem.setUnitPrice(BigDecimal.ZERO);
        multipleItem.setOriginalPrice(BigDecimal.ZERO);
        multipleItem.setContractPrice(BigDecimal.ZERO);
        multipleItem.setStandardPrice(BigDecimal.ZERO);
        multipleItem.setPreset(Boolean.valueOf(false));
        EntityUtils.setCreateFields((BaseEntity)multipleItem);
        this.multipleItemRepository.save((Object)multipleItem);
    }

    private void buildMultiLanguage(Long dataSid, DevSys sys, List<DevModule> modules, List<DevAction> actions, List<DevCondition> conditions, String token, String module) {
        ArrayList<MultiLanguageResource> goodMultiInfo = new ArrayList<MultiLanguageResource>();
        goodMultiInfo.add(new MultiLanguageResource(dataSid.longValue(), "goodsName", sys.getNameCN(), "zh-CN"));
        goodMultiInfo.add(new MultiLanguageResource(dataSid.longValue(), "goodsName", sys.getNameTW(), "zh-TW"));
        goodMultiInfo.add(new MultiLanguageResource(dataSid.longValue(), "goodsName", sys.getNameUS(), "en-US"));
        goodMultiInfo.add(new MultiLanguageResource(dataSid.longValue(), "goodsName", sys.getNameVN(), "vi-VN"));
        goodMultiInfo.add(new MultiLanguageResource(dataSid.longValue(), "modules", module, "zh-CN"));
        goodMultiInfo.add(new MultiLanguageResource(dataSid.longValue(), "modules", this.buildGoodsModules(sys, modules, actions, conditions, token, Integer.valueOf(2)), "zh-TW"));
        goodMultiInfo.add(new MultiLanguageResource(dataSid.longValue(), "modules", this.buildGoodsModules(sys, modules, actions, conditions, token, Integer.valueOf(3)), "en-US"));
        goodMultiInfo.add(new MultiLanguageResource(dataSid.longValue(), "modules", this.buildGoodsModules(sys, modules, actions, conditions, token, Integer.valueOf(4)), "vi-VN"));
        this.multiLanguageResourceRepository.deleteByDataSidAndFieldName(dataSid, "sellingstrategyName");
        this.multiLanguageResourceRepository.deleteByDataSidAndFieldName(dataSid, "goodsName");
        this.multiLanguageResourceRepository.deleteByDataSidAndFieldName(dataSid, "modules");
        this.multiLanguageResourceRepository.flush();
        this.multiLanguageResourceRepository.saveAll(goodMultiInfo);
    }

    private String buildGoodsModules(DevSys sys, List<DevModule> modules, List<DevAction> actions, List<DevCondition> conditions, String token, Integer flag) {
        DevSysVO sysZH = DevSysVO.builder().categoryId(GoodsCategoryEnum.APP.id()).id(sys.getId()).isMultiLogin(Integer.valueOf(sys.isMultiLogin() ? 1 : 0)).name(this.getNameByFlag(flag.intValue(), (Object)sys)).build();
        List<Object> moduleVOS = new ArrayList();
        List<Object> conditionVOS = new ArrayList();
        List<Object> actionVOS = new ArrayList();
        if (!CollectionUtils.isEmpty(modules) && !Integer.valueOf(1).equals(sys.getSysCategory())) {
            moduleVOS = modules.stream().map(i -> DevModuleVO.builder().id(i.getId()).name(this.getNameByFlag(flag.intValue(), i)).build()).collect(Collectors.toList());
            Map<Long, String> moduleSidWithId = modules.stream().collect(Collectors.toMap(BaseEntity::getSid, DevModule::getId));
            if (!CollectionUtils.isEmpty(actions)) {
                Map<Long, String> actionSidWithId = actions.stream().collect(Collectors.toMap(BaseEntity::getSid, DevAction::getId));
                conditionVOS = conditions.stream().map(i -> DevConditionVO.builder().sid(Long.valueOf(i.getSid())).devActionSid(Long.valueOf(i.getDevActionSid())).key(i.getKey()).name(this.getNameByFlag(flag.intValue(), i)).type(i.getType()).typeParameter((List)JsonUtils.readValue((String)i.getTypeParameter(), List.class)).parameter(i.getTypeParameter()).defaultValue(i.getDefaultValue()).actionId((String)actionSidWithId.get(i.getDevActionSid())).hash(i.getHash()).createBy(i.getCreateById()).build()).collect(Collectors.toList());
                Map<Long, List<DevConditionVO>> actionIdWithConditionVO = conditionVOS.stream().collect(Collectors.groupingBy(DevConditionVO::getDevActionSid));
                actionVOS = actions.stream().map(i -> DevActionVO.builder().moduleId((String)moduleSidWithId.get(i.getDevModuleSid())).id(i.getId()).name(this.getNameByFlag(flag.intValue(), i)).condition((List)actionIdWithConditionVO.get(i.getSid())).build()).collect(Collectors.toList());
            }
        }
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("appToken", token);
        jsonObject.put("app", sysZH);
        jsonObject.put("modules", moduleVOS);
        jsonObject.put("actions", actionVOS);
        return JsonUtils.writeValue(jsonObject);
    }

    public String getNameByFlag(int flag, Object object) {
        String methodName;
        switch (flag) {
            case 1: {
                methodName = "getNameCN";
                break;
            }
            case 2: {
                methodName = "getNameTW";
                break;
            }
            case 3: {
                methodName = "getNameUS";
                break;
            }
            default: {
                methodName = "getNameVN";
            }
        }
        try {
            Method method = object.getClass().getMethod(methodName, new Class[0]);
            return (String)method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            logger.error("getNameByFlag failed", (Throwable)e);
            return null;
        }
    }

    private Goods buildGoods(DevSys sys, String cloud, String appCloudUrl, Boolean isTest, String pmEmails, String sourceCloud, String sourceArea, DeployGoodsInfo deployGoodsInfo) {
        Goods goods = new Goods();
        goods.setCode(sys.getId());
        goods.setCategoryId(GoodsCategoryEnum.APP.id());
        goods.setMarket(Boolean.valueOf(false));
        goods.setNotificationCycle(GmcConstant.NOTIFICATION_CYCLE_NO);
        goods.setCloudWebsite(StringUtils.isEmpty((Object)appCloudUrl) ? this.getDefaultWebsite(appCloudUrl, sys.getId(), cloud, isTest) : appCloudUrl);
        goods.setVersion("1.0.0.0");
        goods.setItemId(sys.getId());
        goods.setUserNumberCode(Optional.ofNullable(deployGoodsInfo.getUserNumberCode()).orElse("0"));
        goods.setPurchasePrice(BigDecimal.ONE);
        goods.setAdminEmails(pmEmails);
        goods.setDescription(sys.getRemarks());
        goods.setDisplayName(sys.getNameCN());
        if (this.envProperties.isCloud()) {
            goods.setPaymentType(GmcConstant.PAYMENT_TYPE_PERSON_PER_MONTH);
        } else {
            goods.setPaymentType(GmcConstant.PAYMENT_TYPE_NOT_CONTROL);
        }
        goods.setMultiLogin(Boolean.valueOf(sys.isMultiLogin()));
        goods.setProductCode(deployGoodsInfo.getProductCode());
        goods.setOnSale(Integer.valueOf(1));
        goods.setInitialize(Boolean.valueOf(false));
        goods.setSortNumber(Long.valueOf(999L));
        goods.setOverlayTenancyPeriod(Boolean.valueOf(true));
        goods.setOpenMode(Integer.valueOf(1));
        goods.setDevId(sys.getTenantId());
        goods.setDevName(sys.getTenantName());
        goods.setCreateById("devAdmin");
        goods.setCreateDate(LocalDateTime.now());
        goods.setShowEntry(Boolean.FALSE);
        goods.setShowConsole(Boolean.TRUE);
        goods.setSourceCloud(sourceCloud);
        goods.setSourceArea(sourceArea);
        goods.setCustomUnit("\u6b21");
        goods.setCloud(Boolean.valueOf(false));
        return goods;
    }

    private Goods buildAthenaLcdpGoods(DevSys sys, String cloud, String appCloudUrl, Boolean isTest, String pmEmails, DeployGoodsInfo deployGoodsInfo) {
        Goods goods = new Goods();
        goods.setCode(sys.getId());
        goods.setCategoryId(GoodsCategoryEnum.APP.id());
        goods.setMarket(Boolean.valueOf(false));
        goods.setNotificationCycle(GmcConstant.NOTIFICATION_CYCLE_NO);
        goods.setCloudWebsite(StringUtils.isEmpty((Object)appCloudUrl) ? this.getDefaultWebsite(appCloudUrl, sys.getId(), cloud, isTest) : appCloudUrl);
        goods.setVersion("1.0.0.0");
        goods.setItemId(sys.getId());
        goods.setUserNumberCode(Optional.ofNullable(deployGoodsInfo.getUserNumberCode()).orElse(sys.getId()));
        goods.setPurchasePrice(BigDecimal.ONE);
        goods.setAdminEmails(pmEmails);
        goods.setDescription(sys.getRemarks());
        goods.setDisplayName(sys.getNameCN());
        if (this.envProperties.isCloud()) {
            goods.setPaymentType(Optional.ofNullable(deployGoodsInfo.getPaymentType()).orElse(GmcConstant.PAYMENT_TYPE_PERSON_PER_MONTH));
        } else {
            goods.setPaymentType(Optional.ofNullable(deployGoodsInfo.getPaymentType()).orElse(GmcConstant.PAYMENT_TYPE_NOT_CONTROL));
        }
        goods.setMultiLogin(Boolean.valueOf(sys.isMultiLogin()));
        goods.setProductCode(deployGoodsInfo.getProductCode());
        goods.setOnSale(Integer.valueOf(0));
        goods.setInitialize(Boolean.valueOf(false));
        goods.setSortNumber(Long.valueOf(999L));
        goods.setOverlayTenancyPeriod(Boolean.valueOf(true));
        goods.setOpenMode(Integer.valueOf(1));
        goods.setDevId(sys.getTenantId());
        goods.setDevName(sys.getTenantName());
        goods.setShowEntry(Boolean.FALSE);
        goods.setShowConsole(Optional.ofNullable(deployGoodsInfo.getShowConsole()).orElse(true));
        goods.setCloud(Boolean.valueOf(false));
        goods.setCustomUnit("\u6b21");
        return goods;
    }

    private String getDefaultWebsite(String appCloudUrl, String sysId, String cloud, Boolean isTest) {
        if (cloud == null && isTest == null) {
            return appCloudUrl;
        }
        if ("Huawei".equals(cloud)) {
            return String.format("https://%s.apps.digiwincloud.com.cn", sysId);
        }
        if ("Azure".equals(cloud)) {
            if (isTest.booleanValue()) {
                return String.format("https://%s-test.apps.digiwincloud.com", sysId);
            }
            return String.format("https://%s.apps.digiwincloud.com", sysId);
        }
        if (Boolean.TRUE.equals(isTest)) {
            return String.format("https://%s-test.apps.digiwincloud.com.cn", sysId);
        }
        return String.format("https://%s.apps.digiwincloud.com.cn", sysId);
    }

    public List<Goods> findAllByDevIdAndServicerId(List<String> devIds, String servicerId) {
        return this.goodsMapper.findGoodsByDevIdAndServicerId(devIds, servicerId);
    }

    public void saveGoodModules(Goods goods, GoodsAndLanguageVO goodsVO) {
        SysCascadeVO modules = goodsVO.getModules();
        String moduleStr = Optional.ofNullable(modules).map(JsonUtils::objToJson).orElse("{}");
        if (Objects.equals(goods.getModules(), moduleStr)) {
            logger.info("\u5546\u54c1[{}]\u5e8f\u5217\u5316\u540e\u7684modules\u76f8\u7b49\uff0c\u9000\u51fa\u66f4\u65b0...", (Object)goodsVO.getCode());
            return;
        }
        GoodsAndLanguageVO oldGoodsVO = new GoodsAndLanguageVO();
        oldGoodsVO.setCode(goods.getCode());
        oldGoodsVO.setModules((SysCascadeVO)JsonUtils.jsonToObj((String)goods.getModules(), SysCascadeVO.class));
        Optional.ofNullable(modules).map(SysCascadeVO::getApp).ifPresent(sysVO -> sysVO.setMultiLogin(goods.getMultiLogin()));
        goods.setModules(moduleStr);
        ((GoodServiceImpl)SpringBeanUtils.getBean(this.getClass())).updateWithMultiLanguage(goodsVO, goods);
        this.iamService.addDefaultApp(goodsVO);
        AuthoredUser authoredUser = UserUtils.getAuthoredUser();
        CompletableFuture.supplyAsync(() -> {
            this.remoteLMCService.saveGoodsModulesOpLog(goodsVO, oldGoodsVO, goods, authoredUser);
            return null;
        });
    }

    @Transactional
    public void updateWithMultiLanguage(GoodsAndLanguageVO goodsVO, Goods goods) {
        this.goodsCrudService.update((BaseEntity)goods);
        this.languageService.saveMultiLanguage(goods, goodsVO.getMultiLanguageResource());
    }

    public void setGoodsInfo(List<String> goodsCodes, List<GoodsLanguage> goods) {
        if (CollectionUtils.isEmpty(goods)) {
            return;
        }
        Map goodsOnPlatformMap = this.marketingConfigCrudService.findPlatformByMainGoodsCodeIn(goodsCodes).stream().collect(Collectors.groupingBy(MarketingConfigDetailVO::getMainGoodsCode, Collectors.mapping(MarketingConfigDetailVO::getAttachedGoodsCode, Collectors.toList())));
        List goodsDetails = this.goodsRepository.findByCodeIn(goodsCodes);
        goods.stream().forEach(o -> {
            o.setPlatformCodes((List)goodsOnPlatformMap.get(o.getGoodsCode()));
            goodsDetails.stream().forEach(g -> {
                if (g.getCode().equals(o.getGoodsCode())) {
                    o.setDescription(g.getDescription());
                    o.setLogoImage(g.getLogoImage());
                    o.setCloudwebsite(g.getCloudWebsite());
                    o.setTags(g.getTags());
                }
            });
        });
    }

    public void setGoodsInfo4MultiLanguage(List<String> goodsCodes, List<MultiLanguageQueryVO> goods) {
        if (CollectionUtils.isEmpty(goods)) {
            return;
        }
        List goodsDetails = this.goodsRepository.findByCodeIn(goodsCodes);
        Map goodsOnPlatformMap = this.marketingConfigCrudService.findPlatformByMainGoodsCodeIn(goodsCodes).stream().collect(Collectors.groupingBy(MarketingConfigDetailVO::getMainGoodsCode, Collectors.mapping(MarketingConfigDetailVO::getAttachedGoodsCode, Collectors.toList())));
        Map<String, GoodsExtra> goodsExtraMap = this.goodsExtraCrudService.findByGoodsCodeIn(goodsCodes).stream().collect(Collectors.toMap(GoodsExtra::getGoodsCode, a -> a, (k1, k2) -> k1));
        goods.forEach(o -> {
            o.setPlatformCodes((List)goodsOnPlatformMap.get(o.getId()));
            goodsDetails.forEach(g -> {
                if (g.getCode().equals(o.getId())) {
                    o.setDescription(g.getDescription());
                    o.setLogoImage(g.getLogoImage());
                    o.setCloudwebsite(g.getCloudWebsite());
                }
            });
        });
    }

    public Boolean autoDeployGoods(DeployGoodsInfo deployGoodsInfo) {
        String sysId = deployGoodsInfo.getSysId();
        SysFullInfoVO result = this.iamService.getDevSysFullInfo(sysId, this.envProperties.getIamUri());
        this.setDefaultProductCode(deployGoodsInfo);
        logger.info("1.\u81ea\u52a8\u90e8\u7f72\uff0c\u83b7\u53d6\u5f00\u53d1\u5546\u5e94\u7528\u4fe1\u606f:{}", (Object)JsonUtils.objToJson((Object)result));
        if (result == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u67e5\u8be2\u5e94\u7528\u4fe1\u606f\u4e3a\u7a7a, sysId : " + sysId);
        }
        DevSys sys = Optional.ofNullable(result.getDevSys()).orElseThrow(() -> new BusinessException(" \u67e5\u8be2sys\u5e94\u7528\u6570\u636e\u4e3a\u7a7a, sysId : " + sysId));
        String appToken = Optional.ofNullable(result.getAppToken()).filter(x -> !StringUtils.isEmpty((Object)x)).orElseThrow(() -> new BusinessException(" \u67e5\u8be2\u5e94\u7528token\u4e3a\u7a7a, sysId : " + sysId));
        List modules = Optional.ofNullable(result.getModules()).orElse(Collections.emptyList());
        List actions = result.getActions();
        List conditions = result.getConditions();
        Goods goods = this.goodsRepository.findByCode(sysId);
        ((GoodServiceImpl)SpringBeanUtils.getBean(this.getClass())).handleGoodsInfo(sysId, sys, appToken, modules, actions, conditions, goods, deployGoodsInfo.getPlatformCode(), deployGoodsInfo);
        AuthorizationVO authorizationVO = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(UserUtils.getTenantId(), sysId);
        if (authorizationVO == null) {
            this.omcService.addPreOrder(sysId, UserUtils.getAuthoredUser());
        }
        this.cacService.addAuthorization(UserUtils.getTenantId(), sysId, UserUtils.getUserId());
        return Boolean.TRUE;
    }

    private void setDefaultProductCode(DeployGoodsInfo deployGoodsInfo) {
        String tenantId = deployGoodsInfo.getTenantId();
        if ("4".equalsIgnoreCase(this.iamService.getTenantSimples(Collections.singletonList(tenantId)).stream().filter(a -> tenantId.equals(a.getId())).findFirst().map(CommonVO::getTeamId).orElse(null))) {
            deployGoodsInfo.setProductCode(Optional.ofNullable(deployGoodsInfo.getProductCode()).orElse("ODM"));
        } else {
            deployGoodsInfo.setProductCode(Optional.ofNullable(deployGoodsInfo.getProductCode()).orElse("all"));
        }
        Product product = this.productRepository.findByProductCode(deployGoodsInfo.getProductCode());
        if (product != null) {
            deployGoodsInfo.setProductName(product.getProductName());
        }
    }

    @Transactional
    public void handleGoodsInfo(String sysId, DevSys sys, String appToken, List<DevModule> modules, List<DevAction> actions, List<DevCondition> conditions, Goods goods, String platformCode, DeployGoodsInfo deployGoodsInfo) {
        String module = "";
        if (goods == null) {
            logger.info("2.\u81ea\u52a8\u90e8\u7f72\uff0c\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a,\u5f00\u59cb\u90e8\u7f72,\u6a21\u7ec4:{}:\u884c\u4e3a:{}", (Object)JsonUtils.objToJson(modules), (Object)JsonUtils.objToJson(actions));
            sys.setMultiLogin(true);
            module = this.buildGoodsModules(sys, modules, actions, conditions, appToken, Integer.valueOf(1));
            logger.info("3.\u81ea\u52a8\u90e8\u7f72\uff0c\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a,\u5f00\u59cb\u90e8\u7f72,\u6a21\u7ec4:{}", (Object)JsonUtils.objToJson((Object)module));
            GoodsVO athenaLcdp = this.goodsMapper.selectGoodsByCode(platformCode);
            if (athenaLcdp == null) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u5173\u8054\u7684\u5e73\u53f0\u5546\u54c1[%s]\u4e0d\u5b58\u5728", platformCode));
            }
            String pmEmails = this.getPmEmails(deployGoodsInfo.getPmEmails());
            goods = this.buildAthenaLcdpGoods(sys, null, athenaLcdp.getCloudWebsite(), null, pmEmails, deployGoodsInfo);
            goods.setModules(module);
            EntityUtils.setCreateFields((BaseEntity)goods);
            this.goodsRepository.saveAndFlush((Object)goods);
            logger.info(" goods sid : [{}] ", (Object)goods.getSid());
            this.buildMultiLanguage(Long.valueOf(goods.getSid()), sys, modules, actions, conditions, appToken, module);
            List moduleArray = (List)((Map)JsonUtils.readValue((String)module, Map.class)).get("modules");
            this.buildSellingStrategy(goods, sys, JsonUtils.writeValue((Object)moduleArray), "_daplcdp_default", deployGoodsInfo);
            if (Integer.valueOf(1).equals(sys.getDevPlatform()) || Integer.valueOf(1).equals(sys.getSysCategory())) {
                this.saveAthenaDefaultStrategyMarketConfig(sysId, platformCode);
            }
            GoodsVO goodsVO = new GoodsVO(goods, deployGoodsInfo);
            goodsVO.setModules(JsonUtils.readValue((String)module, Object.class));
            List resources = this.multiLanguageResourceRepository.findByDataSidAndFieldName(goods.getSid(), "modules");
            Long iamStart = System.currentTimeMillis();
            this.iamService.addDefaultApp(goodsVO, resources, this.envProperties.getIamUri());
            this.iamService.updateBackUri(goodsVO);
            Long iamEnd = System.currentTimeMillis();
            logger.info(" \u8c03\u7528iam \u63a5\u53e3\u8017\u65f6 \uff1a[{}] ", (Object)(iamEnd - iamStart));
            if (CollectionUtils.isEmpty(modules)) {
                logger.warn(" modules is null , stop invoke cac interface !");
            }
        }
    }

    public void saveAthenaDefaultStrategyMarketConfig(String mainGoodsCode, String platformCode) {
        if ("Athena".equalsIgnoreCase(platformCode)) {
            MarketingConfig exist;
            SellingStrategy strategy = this.sellingStrategyCrudService.findByCode("athena-auto");
            if (strategy != null && (exist = this.marketingConfigRepository.findByMainGoodsCodeAndTypeAndAttachedStrategySid(mainGoodsCode, MarketingConfigTypeEnum.PLATFORM.ordinal(), strategy.getSid())) == null) {
                MarketingConfig marketingConfig = new MarketingConfig();
                marketingConfig.setMainGoodsCode(mainGoodsCode);
                marketingConfig.setType(Integer.valueOf(MarketingConfigTypeEnum.PLATFORM.ordinal()));
                marketingConfig.setAttachedGoodsCode(strategy.getGoodsCode());
                marketingConfig.setAttachedStrategySid(Long.valueOf(strategy.getSid()));
                this.marketingConfigCrudService.create((BaseEntity)marketingConfig);
            }
        } else {
            logger.info("\u521b\u5efa\u5e73\u53f0\u5173\u7cfb\uff0c\u4f46\u5e73\u53f0\u975eAthena");
        }
    }

    public void deleteAthenaDefaultStrategyMarketConfig(String mainGoodsCode, String platformCode) {
        MarketingConfig exist;
        SellingStrategy strategy;
        if ("Athena".equalsIgnoreCase(platformCode) && (strategy = this.sellingStrategyCrudService.findByCode("athena-auto")) != null && (exist = this.marketingConfigRepository.findByMainGoodsCodeAndTypeAndAttachedStrategySid(mainGoodsCode, MarketingConfigTypeEnum.PLATFORM.ordinal(), strategy.getSid())) != null) {
            logger.info("\u5220\u9664athena\u9ed8\u8ba4\u65b9\u6848\u5e73\u53f0\u5173\u7cfb");
            this.marketingConfigRepository.delete((Object)exist);
        }
    }

    private String getPmEmails(String pmEmails) {
        if (StringUtils.hasLength((String)pmEmails)) {
            return pmEmails;
        }
        AuthoredUser authoredUser = UserUtils.getAuthoredUser();
        if (authoredUser == null || "integration".equals(authoredUser.getUserId())) {
            return "emmabi@digiwin.com";
        }
        UserVO vo = this.iamService.getCurrentUser(authoredUser);
        if (vo != null && StringUtils.hasLength((String)vo.getEmail())) {
            return vo.getEmail();
        }
        return "emmabi@digiwin.com";
    }

    public void saveGoodsMappings(String goodsCode, Integer platform, List<CloudMappingData> datas) {
    }

    @Transactional(rollbackFor={Exception.class})
    public void setAthenaUri(AthenaUrlSettingDTO dto) {
        Goods good = this.goodsRepository.findByCode(dto.getId());
        Optional.ofNullable(good).orElseThrow(() -> new BusinessException("\u5546\u54c1\u4e0d\u5b58\u5728"));
        good.setInitialize(Optional.ofNullable(dto.getInit()).orElse(good.getInitialize()));
        good.setBackUri(Optional.ofNullable(dto.getBackUri()).orElse(Optional.of(this.goodsRepository.findByCode("Athena")).map(Goods::getBackUri).orElse(good.getBackUri())));
        this.iamService.addNotice(dto.getNoticeTypes(), dto.getId());
    }

    public List<IndexGoodsVO> searchGoods(IndexSearchVO indexSearchVO, List<String> contents) {
        return this.goodsMapper.searchGoodsV2(indexSearchVO.getPageNum().intValue(), indexSearchVO.getPageSize().intValue(), indexSearchVO.getOrderBy(), indexSearchVO, contents);
    }

    public void addExperienceGoods(ExperiencePackVO input) {
        ExperienceGoods experienceGoods = (ExperienceGoods)input.doForward();
        ExperienceGoods exist = this.experienceGoodsRepository.findByPackSid(experienceGoods.getPackSid());
        if (exist != null) {
            throw new BusinessException("\u5df2\u5b58\u5728");
        }
        this.experienceGoodsCrudService.create((BaseEntity)experienceGoods);
    }

    public List<CustomAttributeVO> getCustomAttributeVOS(String goodsCode) {
        List customAttributeVOS;
        try {
            String customAttributeStr = this.goodsMapper.selectCustomAttributes(goodsCode);
            if (StrUtils.isEmpty((String)customAttributeStr)) {
                customAttributeStr = "[]";
            }
            customAttributeVOS = (List)JsonUtils.createObjectMapper().readValue(customAttributeStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            throw new BusinessException(goodsCode + "\u5546\u54c1\u81ea\u5b9a\u4e49\u5c5e\u6027\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
        return customAttributeVOS;
    }

    @Transactional
    public void updateTrialTypeInfo(GoodsTrialTypeDTO dto) {
        Goods goods = this.goodsCrudService.findByCode(dto.getCode());
        if (Objects.isNull(goods)) {
            throw new BusinessException((ErrorHandler)I18nError.GMC_GOODS_NOT_EXISTED, new Object[]{dto.getCode()});
        }
        goods.setTrialType(dto.getTrialType());
        Runnable clearGoodsAttributes = () -> {
            if (StringUtils.hasLength((String)goods.getGoodsAttributes())) {
                try {
                    GoodsAttributes goodsAttributes = (GoodsAttributes)objectMapper.readValue(goods.getGoodsAttributes(), GoodsAttributes.class);
                    goodsAttributes.setTrial(null);
                    goods.setGoodsAttributes(JsonUtils.writeValue((Object)goodsAttributes));
                }
                catch (JsonProcessingException e) {
                    logger.error("\u89e3\u6790\u5546\u54c1\u591a\u5c5e\u6027\u5f02\u5e38 code: {}, goodsAttributes: {}", new Object[]{goods.getCode(), goods.getGoodsAttributes(), e});
                }
            }
        };
        if (Objects.isNull(dto.getTrialType())) {
            goods.setMobileTrialUrl(null);
            goods.setMobileTrialButton(null);
            clearGoodsAttributes.run();
            goods.setDevTrialUrl(null);
            goods.setDevTrialButton(null);
            goods.setTrialCloudWebsite(null);
        } else {
            switch (5.$SwitchMap$com$digiwin$dap$middleware$gmc$constant$enums$GoodsTrialTypeEnum[GoodsTrialTypeEnum.fromValue((Integer)dto.getTrialType()).ordinal()]) {
                case 1: {
                    goods.setMobileTrialUrl(dto.getMobileTrialUrl());
                    goods.setMobileTrialButton(dto.getMobileTrialButton());
                    goods.setGoodsAttributes(Optional.ofNullable(dto.getGoodsAttributes()).map(JsonUtils::writeValue).orElse("{}"));
                    goods.setDevTrialUrl(null);
                    goods.setDevTrialButton(null);
                    goods.setTrialCloudWebsite(null);
                    break;
                }
                case 2: {
                    goods.setDevTrialUrl(dto.getDevTrialUrl());
                    goods.setDevTrialButton(dto.getDevTrialButton());
                    goods.setTrialCloudWebsite(null);
                    goods.setMobileTrialUrl(null);
                    goods.setMobileTrialButton(null);
                    clearGoodsAttributes.run();
                    break;
                }
                case 3: {
                    goods.setTrialCloudWebsite(dto.getTrialCloudWebsite());
                    goods.setMobileTrialUrl(null);
                    goods.setMobileTrialButton(null);
                    clearGoodsAttributes.run();
                    goods.setDevTrialUrl(null);
                    goods.setDevTrialButton(null);
                }
            }
        }
        EntityUtils.setModifyFields((BaseEntity)goods);
        this.goodsRepository.save((Object)goods);
    }

    public GoodsTrialTypeVO getTrialTypeInfo(String code) {
        Goods goods = this.goodsCrudService.findByCode(code);
        if (Objects.isNull(goods)) {
            throw new BusinessException((ErrorHandler)I18nError.GMC_GOODS_NOT_EXISTED, new Object[]{code});
        }
        return GoodsTrialTypeVO.builder().code(goods.getCode()).trialType(goods.getTrialType()).trialCloudWebsite(goods.getTrialCloudWebsite()).devTrialUrl(goods.getDevTrialUrl()).devTrialButton(goods.getDevTrialButton()).mobileTrialUrl(goods.getMobileTrialUrl()).mobileTrialButton(goods.getMobileTrialButton()).goodsAttributes((GoodsAttributes)JsonUtils.readValue((String)goods.getGoodsAttributes(), GoodsAttributes.class)).build();
    }
}

