/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.goods.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.domain.goods.Goods2CloudMapping;
import com.digiwin.dap.middleware.gmc.entity.CloudMapping;
import com.digiwin.dap.middleware.gmc.entity.CloudMappingData;
import com.digiwin.dap.middleware.gmc.mapper.CloudMappingMapper;
import com.digiwin.dap.middleware.gmc.repository.CloudMappingDataRepository;
import com.digiwin.dap.middleware.gmc.repository.CloudMappingRepository;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsMappingService;
import com.digiwin.dap.middleware.gmc.support.remote.IamService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GoodsMappingServiceImpl
implements GoodsMappingService {
    @Autowired
    private CloudMappingDataRepository cloudMappingDataRepository;
    @Autowired
    private CloudMappingRepository cloudMappingRepository;
    @Autowired
    private CloudMappingMapper cloudMappingMapper;
    @Autowired
    private IamService iamService;

    @Transactional
    public void saveGoodsMappings(String goodsCode, Integer platform, List<CloudMappingData> datas) {
        CloudMapping cloudMapping = this.cloudMappingRepository.findByGoodsCodeAndPlatform(goodsCode, platform);
        if (cloudMapping == null) {
            cloudMapping = new CloudMapping();
            cloudMapping.setGoodsCode(goodsCode);
            cloudMapping.setPlatform(platform);
            EntityUtils.setCreateFields((BaseEntity)cloudMapping);
            this.cloudMappingRepository.save((Object)cloudMapping);
        }
        List existedDatas = this.cloudMappingDataRepository.findByMappingSid(Long.valueOf(cloudMapping.getSid()));
        for (CloudMappingData data : datas) {
            CloudMappingData cloudMappingData = existedDatas.stream().filter(c -> c.getKey().equals(data.getKey())).findFirst().orElse(null);
            if (cloudMappingData == null) {
                cloudMappingData = new CloudMappingData();
                cloudMappingData.setMappingSid(Long.valueOf(cloudMapping.getSid()));
                cloudMappingData.setKey(data.getKey());
                cloudMappingData.setName(data.getName());
                cloudMappingData.setValue(data.getValue());
                cloudMappingData.setSid(SnowFlake.getInstance().newId());
                cloudMappingData.setCorpId(data.getCorpId());
                EntityUtils.setCreateFields((BaseEntity)cloudMappingData);
            } else {
                cloudMappingData.setValue(data.getValue());
                EntityUtils.setModifyFields((BaseEntity)cloudMappingData);
            }
            this.cloudMappingDataRepository.save((Object)cloudMappingData);
        }
    }

    public List<Goods2CloudMapping> getMappings(String goodsCode) {
        return this.cloudMappingMapper.getMappings(goodsCode);
    }

    public void syncMappings(String goodsCode, String goodsName) {
        List mappings = this.getMappings(goodsCode);
        mappings.forEach(a -> {
            a.setGoodsName(goodsName);
            a.setGoodsCode(goodsCode);
        });
        this.iamService.updateCloudMappings(mappings);
    }

    public Map getMappingInfo(Integer platform, String key, String value) {
        String goodsCode = this.cloudMappingMapper.getGoodsCode(platform, key, value);
        Map mappingMap = this.getMappingInfo(goodsCode, platform);
        return mappingMap;
    }

    public Map getMappingInfo(String goodsCode, Integer platform) {
        List dataList = this.cloudMappingMapper.getDatas(goodsCode, platform);
        HashMap<String, String> mappingMap = new HashMap<String, String>();
        mappingMap.put("sysId", goodsCode);
        dataList.forEach(d -> {
            if (!mappingMap.containsKey(d.getKey())) {
                mappingMap.put(d.getKey(), d.getValue());
            }
        });
        return mappingMap;
    }
}

