/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.goods.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsVO;
import com.digiwin.dap.middleware.gmc.entity.GoodsOnPlatform;
import com.digiwin.dap.middleware.gmc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.gmc.repository.GoodsOnPlatformRepository;
import com.digiwin.dap.middleware.gmc.repository.GoodsRepository;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsOnPlatformService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GoodsOnPlatformServiceImpl
implements GoodsOnPlatformService {
    @Autowired
    private GoodsOnPlatformRepository goodsOnPlatformRepository;
    @Autowired
    private GoodsRepository goodsRepository;
    @Autowired
    private GoodsMapper goodsMapper;

    @Transactional(rollbackOn={Exception.class})
    public void save(String code, List<String> platforms) {
        this.checkGoodsInfo(code, platforms);
        this.goodsOnPlatformRepository.deleteByCode(code);
        this.goodsOnPlatformRepository.flush();
        if (platforms.size() > 0) {
            ArrayList goodsPlatforms = new ArrayList();
            platforms.stream().distinct().forEach(p -> {
                GoodsOnPlatform goodsOnPlatform = new GoodsOnPlatform();
                goodsOnPlatform.setCode(code);
                goodsOnPlatform.setPlatformCode(p);
                EntityUtils.setCreateFields((BaseEntity)goodsOnPlatform);
                goodsPlatforms.add(goodsOnPlatform);
            });
            this.goodsOnPlatformRepository.saveAll(goodsPlatforms);
        }
    }

    private boolean checkGoodsInfo(String code, List<String> platforms) {
        if (!this.goodsRepository.existsByCode(code)) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u5546\u54c1%s\u4e0d\u5b58\u5728", code));
        }
        if (platforms.size() > 0) {
            List goodsVOS = this.goodsMapper.getGoodsBySids(null, platforms);
            if (goodsVOS.size() == 0) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u5e73\u53f0\u7c7b\u5546\u54c1%s\u4e0d\u5b58\u5728", String.join((CharSequence)";", platforms)));
            }
            if (goodsVOS.size() != platforms.size()) {
                List existedCodes = goodsVOS.stream().map(GoodsVO::getCode).collect(Collectors.toList());
                ArrayList notExistedCodes = new ArrayList();
                platforms.forEach(p -> {
                    if (!existedCodes.contains(p)) {
                        notExistedCodes.add(p);
                    }
                });
                if (notExistedCodes.size() > 0) {
                    throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u5e73\u53f0\u7c7b\u5546\u54c1%s\u4e0d\u5b58\u5728", String.join((CharSequence)";", notExistedCodes)));
                }
            }
        }
        return true;
    }
}

